/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.JComponent;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.wizard.BusyChangeListener;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardUI;
import jaxx.runtime.swing.wizard.WizardUILancher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;

public class StorageUILauncher
extends WizardUILancher<StorageStep, StorageUIModel, StorageUI> {
    private static final Log log = LogFactory.getLog(StorageUILauncher.class);
    protected String title;

    public StorageUILauncher(JAXXContext context, Window frame, StorageUIModel model, String title) {
        super(context, frame, StorageUI.class, StorageUIModel.class, (WizardModel)model);
        this.title = title;
    }

    public StorageUILauncher(JAXXContext context, Window frame, String title) {
        super(context, frame, StorageUI.class, StorageUIModel.class);
        this.title = title;
    }

    protected void init(StorageUI ui) {
        log.info((Object)("Will init " + ui.getName()));
        super.init((WizardUI)ui);
        if (this.title != null) {
            ui.setTitle(this.title);
        }
        BusyChangeListener listener = new BusyChangeListener((Component)ui);
        UIHelper.getLayer((JComponent)ui.getTabs()).setUI((LayerUI)ui.getBusyBlockLayerUI());
        listener.setBlockingUI(ui.getBusyBlockLayerUI());
        ui.getModel().addPropertyChangeListener("busy", (PropertyChangeListener)listener);
    }

    public void start() {
        super.start();
        ((StorageUI)this.ui).getModel().setBusy(false);
    }

    protected void doCancel(StorageUI ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will cancel " + ui.getName()));
        }
        ui.getModel().setBusy(true);
        super.doCancel((WizardUI)ui);
        ObserveMainUIHandler.restartEdit();
    }

    protected void doAction(StorageUI ui) {
        ui.getModel().setBusy(true);
        super.doAction((WizardUI)ui);
    }

    protected StorageUIHandler getStorageUIHandler() {
        StorageUIHandler handler = ((StorageUI)this.ui).getContextValue(StorageUIHandler.class);
        return handler;
    }

    protected void doClose(StorageUI ui, boolean wasCanceled) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will close " + ui.getName() + " (was canceled ? " + wasCanceled + ")"));
        }
        super.doClose((WizardUI)ui, wasCanceled);
        ui.getModel().setBusy(false);
        ui.dispose();
    }

    public static void changeStorage(final JAXXContext rootContext, Window mainUI, final DbMode mode, String title) {
        new StorageUILauncher(rootContext, mainUI, title){

            @Override
            protected void init(StorageUI ui) {
                super.init(ui);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Incoming dbmode : " + mode));
                }
                StorageUIModel model = ui.getModel();
                if (mode != null) {
                    log.info((Object)("will use incoming mode " + mode));
                    model.setExcludeSteps(Arrays.asList(StorageStep.SELECT_DATA, StorageStep.BACKUP, StorageStep.ROLES));
                    model.setCanCreateLocalService(false);
                    model.setCanUseLocalService(false);
                    model.setCanUseRemoteService(false);
                    switch (mode) {
                        case USE_LOCAL: {
                            model.setCanUseLocalService(true);
                            break;
                        }
                        case CREATE_LOCAL: {
                            model.setCanCreateLocalService(true);
                            break;
                        }
                        case USE_REMOTE: {
                            model.setCanUseRemoteService(true);
                        }
                    }
                    model.updateUniverse();
                    model.setDbMode(mode);
                } else {
                    ObserveConfig config = (ObserveConfig)((Object)rootContext.getContextValue(ObserveConfig.class));
                    Boolean localOpened = config.getMainStorageOpenedLocal();
                    if (model.isLocalStorageExist() && localOpened != null && localOpened.booleanValue()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Can not use local db (already opened)");
                        }
                        model.setCanUseLocalService(false);
                    }
                    model.setCanCreateLocalService(true);
                    model.setCanUseRemoteService(true);
                }
                model.updateUniverse();
            }

            @Override
            protected void doAction(StorageUI ui) {
                super.doAction(ui);
                StorageUIHandler handler = this.getStorageUIHandler();
                handler.doChangeStorage(rootContext, ui.getModel());
            }
        }.start();
    }

    public static void obtainRemoteConnexion(JAXXContext context, Window mainUI, final StorageUIModel model) {
        StorageUIHandler handler;
        if (mainUI == null) {
            mainUI = ObserveContext.get().getObserveMainUI();
        }
        if ((handler = (StorageUIHandler)context.getContextValue(StorageUIHandler.class)) == null) {
            handler = new StorageUIHandler();
            context.setContextValue((Object)handler);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Register in context an storage handler : " + handler));
            }
        } else {
            log.warn((Object)("Use existing handler " + handler));
        }
        StorageUILauncher launcher = new StorageUILauncher(context, mainUI, model, I18n._((String)"observe.title.connect.remoteDB")){

            @Override
            protected void init(StorageUI ui) {
                StorageUIModel model2 = ui.getModel();
                model2.setCanCreateLocalService(false);
                model2.setCanUseLocalService(false);
                model2.setCanUseRemoteService(true);
                model2.setExcludeSteps(Arrays.asList(StorageStep.CHOOSE_DB_MODE, StorageStep.SELECT_DATA, StorageStep.ROLES, StorageStep.BACKUP, StorageStep.CONFIRM));
                model2.setSteps(new StorageStep[]{StorageStep.CONFIG});
                model2.updateUniverse();
                model2.setDbMode(DbMode.USE_REMOTE);
            }

            protected StorageUI createUI(JAXXContext context, Window mainUI, Class<StorageUI> storageUIClass, Class<StorageUIModel> modelClass, StorageUIModel model2) throws Exception {
                if (!(mainUI instanceof JAXXObject)) {
                    mainUI = null;
                }
                return (StorageUI)super.createUI(context, mainUI, storageUIClass, modelClass, (WizardModel)model2);
            }

            @Override
            protected void doAction(StorageUI ui) {
                super.doAction(ui);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Apply new remote connexion to " + (Object)((Object)model)));
                }
                ui.getModel().copyTo(model);
                model.validate();
            }
        };
        launcher.start();
    }

    public static void obtainConnexion(JAXXContext context, Window mainUI, final StorageUIModel model) {
        StorageUIHandler handler;
        if (mainUI == null) {
            mainUI = ObserveContext.get().getObserveMainUI();
        }
        if ((handler = (StorageUIHandler)context.getContextValue(StorageUIHandler.class)) == null) {
            handler = new StorageUIHandler();
            context.setContextValue((Object)handler);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register in context an storage handler : " + handler));
            }
        }
        StorageUILauncher launcher = new StorageUILauncher(context, mainUI, model, I18n._((String)"observe.title.connect.localDB")){

            protected StorageUI createUI(JAXXContext context, Window mainUI, Class<StorageUI> storageUIClass, Class<StorageUIModel> modelClass, StorageUIModel model2) throws Exception {
                if (!(mainUI instanceof JAXXObject)) {
                    mainUI = null;
                }
                return (StorageUI)super.createUI(context, mainUI, storageUIClass, modelClass, (WizardModel)model2);
            }

            @Override
            protected void init(StorageUI ui) {
                StorageUIModel model2 = ui.getModel();
                int nbModes = 0;
                DbMode mode = null;
                if (model2.isCanCreateLocalService()) {
                    ++nbModes;
                    mode = DbMode.CREATE_LOCAL;
                }
                if (model2.isCanUseLocalService()) {
                    ++nbModes;
                    mode = DbMode.USE_LOCAL;
                }
                if (model2.isCanUseRemoteService()) {
                    ++nbModes;
                    mode = DbMode.USE_REMOTE;
                }
                if (nbModes == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Only one mode available [" + mode + "], set it in model"));
                    }
                    model2.setDbMode(mode);
                }
                model2.setExcludeSteps(Arrays.asList(StorageStep.BACKUP, StorageStep.SELECT_DATA, StorageStep.CONFIRM));
                model2.updateUniverse();
            }

            @Override
            protected void doAction(StorageUI ui) {
                super.doAction(ui);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Apply new local connexion to " + (Object)((Object)model)));
                }
                ui.getModel().copyTo(model);
                model.validate();
            }
        };
        launcher.start();
    }

    public String getTitle() {
        return this.title;
    }
}

