/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EstimationBanc;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.EstimationBancUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EstimationBancUIHandler
extends ContentTableUIHandler<Calee, EstimationBanc> {
    private static Log log = LogFactory.getLog(EstimationBancUIHandler.class);
    JAXXContextEntryDef<List<EspeceThon>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");

    public static ContentTableUIModel<Calee, EstimationBanc> newModel(EstimationBancUI ui) {
        return new ContentTableUIModel<Calee, EstimationBanc>(Calee.class, EstimationBanc.class, new String[]{"estimationBanc", "commentaire"}, new String[]{"calee", "espece", "poids", "poidsIndividuel"}, ui, ContentTableModel.newTableMeta(EstimationBanc.class, "espece", false), ContentTableModel.newTableMeta(EstimationBanc.class, "poids", false), ContentTableModel.newTableMeta(EstimationBanc.class, "poidsIndividuel", false));
    }

    public EstimationBancUIHandler(EstimationBancUI ui) {
        super(ui);
    }

    @Override
    public EstimationBancUI getUi() {
        return (EstimationBancUI)super.getUi();
    }

    @Override
    protected Calee loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        ArrayList especeList;
        if (mode == ContentMode.UPDATE) {
            especeList = new ArrayList(dataService.loadDecoratedEntities(dataSource, EspeceThon.class));
            UIHelper.filterReferentielList(especeList, null);
        } else {
            especeList = new ArrayList();
        }
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)this.getUi(), especeList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("especeList = " + especeList.size()));
        }
        return (Calee)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, EstimationBanc bean, boolean create) {
        BeanComboBox<EspeceThon> requestFocus;
        List<Object> availableEspeces;
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        EstimationBancUI ui = this.getUi();
        if (create) {
            availableEspeces = new ArrayList((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)ui));
            List list = model.getColumnValues(0);
            availableEspeces.removeAll(list);
            list.clear();
            requestFocus = ui.getEspece();
        } else {
            EspeceThon espece = bean.getEspece();
            availableEspeces = Arrays.asList(espece);
            requestFocus = ui.getPoids();
        }
        ui.getEspece().setData(availableEspeces);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.estimationBanc.especeThon"), I18n.n_((String)"observe.table.estimationBanc.especeThon.tip"), I18n.n_((String)"observe.table.estimationBanc.poids"), I18n.n_((String)"observe.table.estimationBanc.poids.tip"), I18n.n_((String)"observe.table.estimationBanc.poidsIndividuel"), I18n.n_((String)"observe.table.estimationBanc.poidsIndividuel.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected boolean prepareSave(Calee editBean, List<EstimationBanc> objets) {
        for (EstimationBanc estimationBanc : objets) {
            estimationBanc.setCalee(editBean);
        }
        return true;
    }
}

