/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list;

import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.list.ContentListUI;
import fr.ird.observe.ui.content.list.ContentListUIModel;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class ContentListUIHandler<E extends TopiaEntity, C extends TopiaEntity>
extends ContentUIHandler<E> {
    private static Log log = LogFactory.getLog(ContentListUIHandler.class);

    public ContentListUIHandler(ContentListUI<E, C> ui, DataContextType parentType, DataContextType type) {
        super(ui, parentType, type);
    }

    protected abstract List<C> getChilds(E var1) throws DataSourceException;

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    public ContentListUI<E, C> getUi() {
        return (ContentListUI)super.getUi();
    }

    public final ContentListUIModel<E, C> getModel() {
        return (ContentListUIModel)super.getModel();
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        ListCellRenderer renderer = ((ContentListUI)this.getUi()).getList().getCellRenderer();
        ObserveTreeHelper treeHelper = ContentListUIHandler.getTreeHelper((JAXXContext)this.getUi());
        EntityListCellRenderer renderer2 = new EntityListCellRenderer(renderer, treeHelper);
        ((ContentListUI)this.getUi()).getList().setCellRenderer(renderer2);
    }

    @Override
    public final void openUI() throws Exception {
        boolean canReopen;
        super.openUI();
        EntityListCellRenderer renderer = (EntityListCellRenderer)((ContentListUI)this.getUi()).getList().getCellRenderer();
        renderer.init();
        ContentUIModel model = this.getModel();
        String selectedId = this.getSelectedParentId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "selectedId   = " + selectedId));
        }
        ContentMode mode = this.computeContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "content mode = " + (Object)((Object)mode)));
        }
        model.setMode(mode);
        boolean bl = canReopen = mode == ContentMode.CREATE;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "canReopen    = " + canReopen));
        }
        ((ContentListUIModel)model).setCanReopen(canReopen);
        Object bean = this.getBean();
        this.getDataService().loadEditEntity(this.getDataSource(), selectedId, this.getLoadExecutor());
        List<C> data = this.getChilds(bean);
        ((ContentListUIModel)model).setData(data);
        this.finalizeOpenUI();
    }

    public void addChild() {
        this.addChild(((ContentListUIModel)this.getModel()).getChildType());
    }

    public void onDataSelected(MouseEvent event) {
        Object selectedData = ((ContentListUI)this.getUi()).getSelectedData();
        if (event.getClickCount() > 1) {
            this.gotoChild((TopiaEntity)selectedData);
            return;
        }
        ObserveNode node = null;
        if (selectedData != null) {
            String id = selectedData.getTopiaId();
            ObserveTreeHelper helper = ContentListUIHandler.getTreeHelper((JAXXContext)this.getUi());
            ObserveNode selectedNode = (ObserveNode)helper.getSelectedNode();
            node = (ObserveNode)helper.findNode((NavNode)selectedNode, new String[]{id});
        }
        JButton button = ((ContentListUI)this.getUi()).getGotoSelectedChild();
        button.putClientProperty("node", (Object)node);
    }

    public <E> List<E> updateList(BeanListHeader<E> list, List<E> data) {
        String message = I18n._((String)((ContentListUI)this.getUi()).getEmptyListMessage());
        return this.updateList(list, data, message);
    }

    protected void finalizeOpenUI() {
    }

    private static class EntityListCellRenderer
    extends DefaultListCellRenderer {
        protected ListCellRenderer delegate;
        protected ObserveTreeHelper treeHelper;
        protected AbstractObserveTreeCellRenderer treeRenderer;
        protected ObserveNode containerNode;

        public EntityListCellRenderer(ListCellRenderer delegate, ObserveTreeHelper treeHelper) {
            this.delegate = delegate;
            this.treeHelper = treeHelper;
            this.treeRenderer = treeHelper.getTreeCellRenderer();
        }

        public void init() {
            this.containerNode = (ObserveNode)this.treeHelper.getSelectedNode();
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value == null || !(value instanceof TopiaEntity) || this.containerNode == null) {
                return comp;
            }
            TopiaEntity e = (TopiaEntity)value;
            ObserveNode node = (ObserveNode)this.treeHelper.findNode((NavNode)this.containerNode, new String[]{e.getTopiaId()});
            if (node == null) {
                return comp;
            }
            Icon icon = this.treeRenderer.getNavigationIcon(node);
            comp.setIcon(icon);
            Color color = this.treeRenderer.getNavigationTextColor(node);
            comp.setForeground(color);
            return comp;
        }
    }
}

