/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.validate;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ui.admin.validate.ValidateModel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.validator.BeanValidatorMessage;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class ValidateEntityListCellRenderer
extends DefaultListCellRenderer
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ValidateEntityListCellRenderer.class);
    protected DecoratorService service;
    protected final ValidateModel model;
    protected final Map<Object, String> renderCache;

    public ValidateEntityListCellRenderer(ValidateModel model) {
        this.model = model;
        this.renderCache = new HashMap<Object, String>();
        this.model.addPropertyChangeListener("messages", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DecoratorService decoratorService = this.getService();
        Map value = (Map)evt.getNewValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("messages changed : " + (value == null ? 0 : value.size()) + ", rebuild render cache"));
        }
        Map<Object, String> map = this.renderCache;
        synchronized (map) {
            this.renderCache.clear();
            if (this.model.getMessages() == null) {
                return;
            }
            for (Class<?> klass : this.model.getMessageTypes()) {
                String type = I18n._((String)decoratorService.getEntityLabel(klass));
                this.renderCache.put(klass, type);
            }
        }
    }

    public DecoratorService getService() {
        if (this.service == null) {
            this.service = ObserveContext.get().getDecoratorService();
        }
        return this.service;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            DecoratorService decoratorService = this.getService();
            value = value instanceof Class ? this.renderCache.get(value) : this.valueFromEntityRef(decoratorService, (TopiaEntityRef)value);
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    public Object valueFromEntityRef(DecoratorService decoratorService, TopiaEntityRef value) {
        String s = this.renderCache.get(value);
        if (s != null) {
            return s;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("compute render cache for " + value.getRef().getTopiaId()));
        }
        List<BeanValidatorMessage<?>> messages = this.model.getMessages(value);
        EnumMap scopes = BeanValidatorUtil.getScopesCount(messages);
        StringBuilder buffer = new StringBuilder();
        TopiaEntity entity = value.getRef();
        Class type = ObserveDAOHelper.getContractClass(entity.getClass());
        Decorator decorator = decoratorService.getDecorator(type);
        buffer.append(decorator.toString((Object)entity));
        buffer.append(" (");
        Iterator itr = scopes.keySet().iterator();
        while (itr.hasNext()) {
            BeanValidatorScope scope = (BeanValidatorScope)itr.next();
            int nb = (Integer)scopes.get(scope);
            String t = I18n._((String)scope.getLabel());
            buffer.append(t).append(" : ").append(nb);
            if (!itr.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(")");
        s = buffer.toString();
        this.renderCache.put(value, s);
        return s;
    }
}

