/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.save;

import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.save.SaveLocalModel;
import fr.ird.observe.ui.admin.save.SaveLocalUI;
import fr.ird.observe.ui.admin.synchronize.SynchronizeModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeUIHandler;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.DiffState;

public class SaveLocalUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(SaveLocalUIHandler.class);
    private static final String UPDATE_VERSION_PATTERN = "UPDATE %1$s SET topiaversion = %2$d WHERE topiaid='%3$s';\n";
    protected DataSource source;

    public SaveLocalUIHandler(SaveLocalUI ui) {
        super(ui);
    }

    @Override
    public SaveLocalUI getUi() {
        return (SaveLocalUI)super.getUi();
    }

    public void initTabUI(AdminUI ui, SaveLocalUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getStartAction().setText(I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel())}));
    }

    public void updateText() {
        String text = "";
        if (this.getUi().getStepModel().containsStepForsave(AdminStep.SYNCHRONIZE)) {
            text = I18n._((String)"observe.synchro.message.need.save.for.synchro.operation");
            text = text + "\n\n";
        }
        if (this.getUi().getStepModel().containsStepForsave(AdminStep.VALIDATE)) {
            text = I18n._((String)"observe.synchro.message.need.save.for.validation.operation");
            text = text + "\n\n";
        }
        this.getUi().needSaveText.setText(text);
    }

    public String updateText(boolean localSourceNeedSave) {
        return localSourceNeedSave ? I18n._((String)"observe.message.synchro.local.modification") : I18n._((String)"observe.message.synchro.no.local.modification");
    }

    public void skipOperation() {
        this.sendMessage(I18n._((String)"observe.synchro.message.saveLocal.skip"));
        this.getModel().setStepState(AdminStep.SAVE_LOCAL, WizardState.SUCCESSED);
        if (this.model.getNextStep() != null) {
            this.model.gotoNextStep();
        }
    }

    public void chooseBackupFile() {
        File f = UIHelper.chooseDirectory(this.getUi(), I18n._((String)"observe.title.choose.db.dump.directory"), I18n._((String)"observe.action.choose.db.dump.directory"), new File(this.getUi().directoryText.getText()));
        this.changeDirectory(f);
    }

    public void changeDirectory(File f) {
        this.getUi().getStepModel().setBackupFile(new File(f, this.getUi().filenameText.getText()));
    }

    public void changeFilename(String filename) {
        this.getUi().getStepModel().setBackupFile(new File(this.getUi().directoryText.getText(), filename));
    }

    public void doStartAction() {
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = this.getUi().getStartAction().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return SaveLocalUIHandler.this.doAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    public WizardState doAction() throws Exception {
        log.debug((Object)this);
        this.source = this.model.getSafeLocalSource(false);
        SaveLocalModel stepModel = this.model.getSaveLocalModel();
        if (!stepModel.isLocalSourceNeedSave()) {
            this.sendMessage("Aucune modification sur la base locale, op\u00e9ration non requise.");
            return WizardState.SUCCESSED;
        }
        this.openSource(this.source);
        if (stepModel.isDoBackup()) {
            this.sendMessage("Sauvegarde de la base locale vers " + stepModel.getBackupFile());
            File backupFile = stepModel.getBackupFile();
            this.source.storeDB(backupFile);
        }
        if (stepModel.containsStepForsave(AdminStep.SYNCHRONIZE)) {
            this.sendMessage("Sauvegarde du r\u00e9f\u00e9rentiel.");
            this.saveReferentiel();
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReferentiel() throws Exception {
        SynchronizeModel stepModel = this.getModel().getSynchronizeReferentielModel();
        DataSource source = stepModel.getSource();
        DataSource targetSource = stepModel.getTmpSource();
        if (targetSource == null) {
            targetSource = stepModel.getCentralSource();
        }
        DiffState.DiffStateMap diff = stepModel.getDiff();
        String txName = "saveReferentiel";
        TopiaContext sourceCtxt = this.beginTransaction(source, txName);
        try {
            TopiaContext tmpCtxt = this.beginTransaction(targetSource, txName);
            try {
                Map<TopiaEntity, Long> versionsToUpdate;
                TopiaEntity entity;
                List ids = (List)diff.get((Object)DiffState.NEW);
                if (ids != null) {
                    for (String id : ids) {
                        entity = tmpCtxt.findByTopiaId(id);
                        this.sendMessage("ajout de l'objet " + id + " dans la base locale");
                        tmpCtxt.replicateEntity(sourceCtxt, entity);
                    }
                }
                if ((ids = (List)diff.get((Object)DiffState.MODIFIED)) != null && !ids.isEmpty()) {
                    for (String id : ids) {
                        entity = tmpCtxt.findByTopiaId(id);
                        this.copyEntity(stepModel, sourceCtxt, entity);
                    }
                }
                for (SynchronizeUIHandler.ObsoleteRefReplaceAction action : stepModel.getReplaceActions()) {
                    this.sendMessage("Application du remplacement d'une entit\u00e9 obsol\u00e8te : " + action.getObsoleteId());
                    action.doAction(sourceCtxt);
                }
                this.commitTransaction(source, sourceCtxt, txName);
                ids = (List)diff.get((Object)DiffState.REMOVED);
                if (ids != null) {
                    for (String id : ids) {
                        this.sendMessage("suppression de l'objet " + id + " de la base locale");
                        entity = sourceCtxt.findByTopiaId(id);
                        this.getDAO(sourceCtxt, entity).delete(entity);
                    }
                }
                if ((versionsToUpdate = stepModel.getVersionsToUpdate()) != null && !versionsToUpdate.isEmpty()) {
                    StringBuilder buffer = new StringBuilder();
                    for (Map.Entry<TopiaEntity, Long> entry : versionsToUpdate.entrySet()) {
                        TopiaEntity entity2 = entry.getKey();
                        String id = entity2.getTopiaId();
                        Long version = entry.getValue();
                        Class contract = ObserveDAOHelper.getContractClass(entity2.getClass());
                        buffer.append(String.format(UPDATE_VERSION_PATTERN, contract.getSimpleName(), version, id));
                        buffer.append("UPDATE ");
                        buffer.append(contract.getSimpleName());
                        buffer.append(" SET topiaversion = ").append(version).append(" WHERE topiaid=").append(id).append(";\n");
                    }
                }
                this.commitTransaction(source, sourceCtxt, txName);
            }
            finally {
                try {
                    this.rollbackTransaction(targetSource, tmpCtxt, txName);
                }
                finally {
                    this.closeTransaction(targetSource, tmpCtxt, txName);
                }
            }
        }
        catch (Exception e) {
            this.rollbackTransaction(source, sourceCtxt, txName);
            throw e;
        }
        finally {
            this.closeTransaction(source, sourceCtxt, txName);
        }
    }

    protected <E extends TopiaEntity> void copyEntity(SynchronizeModel synchronizeModel, TopiaContext tx, E source) throws TopiaException {
        this.sendMessage("mise \u00e0 jour de l'objet " + source.getTopiaId() + " dans la base locale");
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)tx, source);
        TopiaEntity target = dao.findByTopiaId(source.getTopiaId());
        long sourceVersion = source.getTopiaVersion();
        long targetVersion = target.getTopiaVersion();
        this.getBinderService().simpleCopy(source, target, false);
        if (targetVersion + 1L < sourceVersion) {
            if (log.isInfoEnabled()) {
                String message = "register [" + source.getTopiaId() + "] to update version " + sourceVersion + " to " + targetVersion;
                log.info((Object)message);
                this.sendMessage(message);
            }
            synchronizeModel.getVersionsToUpdate().put(target, targetVersion);
        }
        target.setTopiaVersion(source.getTopiaVersion() - 1L);
        dao.update(target);
    }
}

