/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report.model;

import fr.ird.observe.ui.admin.report.model.DataMatrix;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ReportRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ReportRequest.class);
    protected RequestLayout layout;
    protected String request;
    protected Point location;

    public ReportRequest(RequestLayout layout, int x, int y, String request) {
        this.layout = layout;
        this.request = request;
        this.location = new Point(x, y);
    }

    public RequestLayout getLayout() {
        return this.layout;
    }

    public int getX() {
        return (int)this.location.getX();
    }

    public int getY() {
        return (int)this.location.getY();
    }

    public Point getLocation() {
        return this.location;
    }

    public String getRequest() {
        return this.request;
    }

    public DataMatrix execute(TopiaContext tx, Properties params) throws TopiaException {
        Object[] datas = this.getParams(params);
        log.info((Object)("Request          : " + this.request));
        log.info((Object)("Params           : " + Arrays.toString(datas)));
        List list = tx.find(this.request, datas);
        log.info((Object)("Result size      : " + list.size()));
        Dimension dimension = this.computeDimension(list);
        log.info((Object)("Result dimension : " + dimension));
        DataMatrix result = this.computeResult(dimension, list);
        return result;
    }

    protected DataMatrix computeResult(Dimension dimension, List<?> list) {
        DataMatrix result = new DataMatrix();
        result.setDimension(dimension);
        result.createData();
        int y = 0;
        int x = 0;
        switch (this.layout) {
            case row: {
                boolean uniqueColumn = result.getWidth() == 1;
                for (Object row : list) {
                    if (uniqueColumn) {
                        result.setValue(0, y, row);
                    } else {
                        Object[] cells;
                        x = 0;
                        for (Object cell : cells = (Object[])row) {
                            result.setValue(x++, y, cell);
                        }
                    }
                    ++y;
                }
                break;
            }
            case column: {
                boolean uniqueRow = result.getHeight() == 1;
                for (Object col : list) {
                    if (uniqueRow) {
                        result.setValue(x, 0, col);
                    } else {
                        Object[] cells;
                        y = 0;
                        for (Object cell : cells = (Object[])col) {
                            result.setValue(x, y++, cell);
                        }
                    }
                    ++x;
                }
                break;
            }
        }
        return result;
    }

    protected Dimension computeDimension(List<?> list) {
        int height = 0;
        int width = 0;
        switch (this.layout) {
            case row: {
                height = list.size();
                if (list.isEmpty()) {
                    width = 0;
                    break;
                }
                Object o = list.get(0);
                if (o == null || !o.getClass().isArray()) {
                    width = 1;
                    break;
                }
                width = ((Object[])o).length;
                break;
            }
            case column: {
                Object o;
                width = list.size();
                height = list.isEmpty() ? 0 : ((o = list.get(0)) == null || !o.getClass().isArray() ? 1 : ((Object[])o).length);
            }
        }
        return new Dimension(width, height);
    }

    protected Object[] getParams(Properties params) {
        Object[] datas = new Object[params.size() * 2];
        int index = 0;
        for (Map.Entry<Object, Object> entry : params.entrySet()) {
            datas[index * 2] = entry.getKey();
            datas[index * 2 + 1] = entry.getValue();
            ++index;
        }
        return datas;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("request", (Object)this.getRequest());
        builder.append("layout", (Object)this.getLayout());
        builder.append("location", (Object)this.getLocation());
        return builder.toString();
    }

    public static enum RequestLayout {
        row,
        column;

    }
}

