/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report.model;

import fr.ird.observe.ui.admin.report.model.Report;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataMatrix {
    private static final Log log = LogFactory.getLog(Report.class);
    Object[][] data;
    int width;
    int height;
    int x;
    int y;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Object[][] getData() {
        return this.data;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void createData() {
        this.data = new Object[this.height][this.width];
    }

    public void setData(Object[][] data) {
        this.data = data;
    }

    public void copyData(DataMatrix incoming) {
        int x = incoming.getX();
        int y = incoming.getY();
        Integer height = incoming.getHeight();
        Integer width = incoming.getWidth();
        if (log.isDebugEnabled()) {
            log.debug((Object)("copying incoming matrix (dim: " + incoming.getDimension() + ", location: " + incoming.getLocation() + ")"));
        }
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                Serializable value = incoming.getValue(i, j);
                this.setValue(x + i, y + j, value);
            }
        }
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public void setDimension(Dimension dim) {
        this.height = (int)dim.getHeight();
        this.width = (int)dim.getWidth();
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point location) {
        this.x = (int)location.getX();
        this.y = (int)location.getY();
    }

    public Serializable getValue(int x, int y) {
        return this.data == null ? null : (Serializable)this.data[y][x];
    }

    public void setValue(int x, int y, Object data) {
        String cellData;
        String string = cellData = data == null ? null : String.valueOf(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Put data [" + x + "," + y + "] = " + cellData));
        }
        this.data[y][x] = cellData;
    }

    public static Dimension getDimension(DataMatrix ... datas) {
        int width = 0;
        int height = 0;
        for (DataMatrix request : datas) {
            int nWidth = request.getX() + request.getWidth();
            int nHeight = request.getY() + request.getHeight();
            if (nWidth > width) {
                width = nWidth;
            }
            if (nHeight <= height) continue;
            height = nHeight;
        }
        return new Dimension(width, height);
    }

    public static DataMatrix merge(DataMatrix ... incomings) {
        DataMatrix result = DataMatrix.merge(-1, -1, incomings);
        return result;
    }

    public static DataMatrix merge(int rows, int columns, DataMatrix ... incomings) {
        int width;
        int height;
        Dimension dimension = DataMatrix.getDimension(incomings);
        if (rows != -1 && rows != (height = (int)dimension.getHeight())) {
            log.warn((Object)("No matching rows number : should have " + rows + ", but was " + height));
        }
        if (columns != -1 && columns != (width = (int)dimension.getWidth())) {
            log.warn((Object)("No matching columns number : should have " + columns + ", but was " + width));
        }
        DataMatrix result = new DataMatrix();
        result.setDimension(dimension);
        result.createData();
        for (DataMatrix incoming : incomings) {
            result.copyData(incoming);
        }
        return result;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("dimension", (Object)this.getDimension());
        builder.append("location", (Object)this.getLocation());
        return builder.toString();
    }

    public String getClipbordContent() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        char sep = '\t';
        char eol = '\n';
        int rows = this.getHeight();
        for (int y = 0; y < rows; ++y) {
            Serializable value;
            int x;
            int columns = this.getWidth() - 1;
            for (x = 0; x < columns; ++x) {
                value = this.getValue(x, y);
                buffer.append(value).append(sep);
            }
            value = this.getValue(x, y);
            buffer.append(value);
            buffer.append(eol);
        }
        return buffer.toString();
    }
}

