/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class HitModel<K extends Serializable>
implements Iterable<Map.Entry<K, Long>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final PropertyChangeSupport pcs;
    protected SortedMap<K, Long> hits;
    private final Class<K> type;

    protected abstract HitModel<K> newModel();

    public HitModel(Class<K> type) {
        this.type = type;
        this.pcs = new PropertyChangeSupport(this);
        this.hits = new TreeMap<K, Long>();
    }

    public long getTotalHit() {
        long result = 0L;
        for (Map.Entry<K, Long> entry : this) {
            result += entry.getValue().longValue();
        }
        return result;
    }

    public long getHit(K type) {
        Long result = (Long)this.hits.get(type);
        return result == null ? 0L : result;
    }

    @Override
    public Iterator<Map.Entry<K, Long>> iterator() {
        return this.hits.entrySet().iterator();
    }

    public void addHit(K type) {
        long result = this.getHit(type);
        this.addHit0(type, true, result, result + 1L);
    }

    public HitModel<K> getSnapshot() {
        HitModel<Serializable> result = this.newModel();
        for (Map.Entry<K, Long> entry : this) {
            result.addHit0((Serializable)entry.getKey(), false, 0L, entry.getValue());
        }
        return result;
    }

    public HitModel<K> applyTo(HitModel<K> before) {
        HitModel<Serializable> result = this.newModel();
        for (Map.Entry<K, Long> entry : this) {
            Serializable key = (Serializable)entry.getKey();
            long beforeHit = before.getHit(key);
            long nowHit = entry.getValue();
            result.addHit0(key, false, 0L, nowHit - beforeHit);
        }
        return result;
    }

    public K[] getKeys() {
        Set<K> set = this.hits.keySet();
        Serializable[] result = (Serializable[])Array.newInstance(this.type, set.size());
        int i = 0;
        for (Serializable k : set) {
            result[i++] = k;
        }
        return result;
    }

    public void clear() {
        this.hits.clear();
    }

    protected void addHit0(K type, boolean fire, Long old, Long result) {
        this.hits.put(type, result);
        if (fire) {
            this.firePropertyChange(type.toString(), old, result);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, Object newValue) {
        this.pcs.firePropertyChange(propertyName, null, newValue);
    }
}

