/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.tree.ObserveNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavigationTreeSelectionModel
extends DefaultTreeSelectionModel {
    private static final Log log = LogFactory.getLog(NavigationTreeSelectionModel.class);
    private static final long serialVersionUID = 1L;

    @Override
    public void setSelectionPath(TreePath path) {
        ObserveNode node;
        this.setSelectionMode(1);
        if (path.equals(this.getSelectionPath())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skip stay on path " + path));
            }
            return;
        }
        if (!this.isSelectionEmpty() && !this.canCloseNode(node = (ObserveNode)((Object)path.getLastPathComponent()))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"changing node canceled!");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will select path " + path));
        }
        super.setSelectionPath(path);
    }

    public boolean canCloseNode(ObserveNode node) {
        ContentUI<?> content = ObserveContext.get().getSelectedContentUI();
        boolean result = true;
        if (content != null) {
            try {
                result = content.close();
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                log.error((Object)e);
                result = false;
            }
        }
        return result;
    }
}

