/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.list.ContentListUIModel;
import fr.ird.observe.ui.content.list.impl.RoutesUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;

public class RoutesUIHandler
extends ContentUIHandler<Maree> {
    private static Log log = LogFactory.getLog(RoutesUIHandler.class);

    public RoutesUIHandler(RoutesUI ui) {
        super(ui);
    }

    @Override
    protected TopiaEntityBinder<Maree> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Maree.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(Maree.class, new String[]{"open", "route"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"route"});
            r = binderService.registerTopiaBinder(Maree.class, builder, binderName);
        }
        return r;
    }

    public ContentListUIModel<Maree, Route> getModel() {
        return (ContentListUIModel)super.getModel();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openMareeId = dataContext.getOpenMareeId();
        if (openMareeId == null) {
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.maree.found"));
            return ContentMode.READ;
        }
        if (dataContext.isSelectedOpen(Maree.class)) {
            if (dataContext.isOpenRoute()) {
                this.addInfoMessage(I18n.n_((String)"observe.message.active.route.found"));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.route.found"));
            return ContentMode.CREATE;
        }
        this.addInfoMessage(I18n.n_((String)"observe.message.active.route.found.for.other.maree"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String mareeId = this.getDataContext().getSelectedMareeId();
        log.info((Object)("mareeId = " + mareeId));
        Maree bean = (Maree)this.getBean();
        this.getDataService().loadEditEntity(this.getDataSource(), mareeId, this.getOpeningExecutor());
        ContentMode mode = this.prepareContentMode();
        ContentUIModel model = this.getModel();
        ((ContentListUIModel)model).setData(bean.getRoute());
        model.setMode(mode);
    }
}

