/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.list.ContentListUIModel;
import fr.ird.observe.ui.content.list.impl.MareesUI;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderBuilder;

public class MareesUIHandler
extends ContentUIHandler<Programme> {
    private static final Log log = LogFactory.getLog(MareesUIHandler.class);

    public MareesUIHandler(MareesUI ui) {
        super(ui);
    }

    public ContentListUIModel<Programme, Maree> getModel() {
        return (ContentListUIModel)super.getModel();
    }

    @Override
    protected TopiaEntityBinder<Programme> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Programme.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(Programme.class, new String[]{"libelle1", "libelle2", "libelle3", "libelle4", "libelle5", "libelle6", "libelle7", "libelle8"});
            r = binderService.registerTopiaBinder(Programme.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openProgrammeId = dataContext.getOpenProgrammeId();
        if (openProgrammeId == null) {
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.maree.found"));
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Programme.class)) {
            this.addInfoMessage(I18n.n_((String)"observe.message.active.maree.found"));
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.n_((String)"observe.message.active.maree.found.for.other.programme"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        List data;
        super.openUI();
        DataSource source = this.getDataSource();
        DecoratorService decoratorService = this.getDecoratorService();
        DataService dataService = this.getDataService();
        DataContext dataContext = this.getDataContext();
        String programmeId = dataContext.getSelectedProgrammeId();
        Programme bean = (Programme)this.getBean();
        dataService.loadEditEntity(source, programmeId, this.getOpeningExecutor());
        ContentMode mode = this.prepareContentMode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("programme to load " + bean.getTopiaId()));
        }
        if ((data = dataService.getMareeByProgramme(source, bean.getTopiaId())) == null) {
            data = Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("marees of programme " + data));
        }
        ContentUIModel model = this.getModel();
        ((ContentListUIModel)model).setData(data);
        model.setMode(mode);
        Decorator decorator = decoratorService.getDecorator(Programme.class);
        String title = decorator.toString((Object)bean);
        this.getUi().setContentTitle(title);
    }
}

