/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.MareeUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;

public class MareeUIHandler
extends ContentUIHandler<Maree> {
    private static final Log log = LogFactory.getLog(MareeUIHandler.class);
    private static final String POSITION_MAREE = "positionMaree";

    public MareeUIHandler(MareeUI ui) {
        super(ui);
    }

    public MareeUI getUi() {
        return (MareeUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Maree> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Maree.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(Maree.class, new String[]{"dateDebut", "dateFin", "formulairesUrl", "rapportsUrl", "commentaire", "bateau", "senne", "observateur", "ocean", "programme", "route", "open"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"route"});
            r = binderService.registerTopiaBinder(Maree.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String mareeId = dataContext.getSelectedMareeId();
        if (mareeId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Maree.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n._((String)"observe.message.maree.not.open"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        ContentMode mode = this.prepareContentMode();
        DataContext dataContext = this.getDataContext();
        String mareeId = dataContext.getSelectedMareeId();
        String programmeId = dataContext.getSelectedProgrammeId();
        log.info((Object)("programmeId = " + programmeId));
        log.info((Object)("mareeId     = " + mareeId));
        log.info((Object)("mode        = " + (Object)((Object)mode)));
        DataService dataService = this.getDataService();
        Maree bean = (Maree)this.getBean();
        DataSource source = this.getDataSource();
        if (mareeId == null) {
            log.info((Object)"create a new maree");
            dataService.preCreateEntity(source, programmeId, (TopiaEntity)bean, this.getOpeningBinder(), this.getPreCreateExecutor());
        } else {
            log.info((Object)("using existing maree " + mareeId));
            dataService.loadEditEntity(source, mareeId, this.getOpeningExecutor());
            if (!bean.isRouteEmpty()) {
                DBHelper.sortRoutes((List)bean.getRoute());
            }
        }
        this.getModel().setMode(mode);
        if (mode != ContentMode.READ) {
            this.ui.startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        MareeUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        ContentMode mode = model.getMode();
        boolean create = mode == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(mode);
        ui.getValidator().setContextName(contextName);
        if (create) {
            this.addInfoMessage(I18n._((String)"observe.message.creating.maree"));
        } else {
            this.addInfoMessage(I18n._((String)"observe.message.updating.maree"));
        }
        if (model.getMode() == ContentMode.UPDATE && ((Maree)this.getBean()).getDateFin() == null) {
            Date date = DBHelper.getEndOfDay((Date)new Date());
            ((Maree)this.getBean()).setDateFin(date);
            log.info((Object)("date fin " + date));
        }
        super.startEditUI("bateau.selectedItem", "observateur.selectedItem", "ocean.selectedItem", "senne.selectedItem", "dateDebut.date", "dateFin.date", "commentaire2.text", "close.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(Maree bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Maree> binder) throws Exception {
        String programmeId = this.getDataContext().getSelectedProgrammeId();
        Date date = DBHelper.getDay((Date)bean.getDateDebut());
        Date dateFin1 = bean.getDateFin();
        Date dateFin = DBHelper.getMareeDateFin((Maree)bean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dateDebut " + date + " / dateFin : " + dateFin));
        }
        bean.setDateDebut(date);
        if (dateFin1 != null && dateFin1.after(dateFin)) {
            dateFin = DBHelper.getEndOfDay((Date)dateFin1);
        }
        bean.setDateFin(dateFin);
        if (bean.getTopiaId() == null) {
            bean.setOpen(true);
            dataService.create(dataSource, programmeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, (TopiaEntity)bean, binder, new String[]{"route"});
        }
        int position = dataService.getMareePosition(dataSource, programmeId, bean.getTopiaId());
        log.info((Object)("Position of maree : " + position));
        this.ui.setContextValue(position, POSITION_MAREE);
        return true;
    }

    @Override
    protected boolean doDelete(Maree bean, DataService dataService, DataSource dataSource, Deletor<Object, Maree> deletor) throws Exception {
        if (!UIHelper.confirmForEntityDelete(this.ui, Maree.class, bean)) {
            return false;
        }
        dataService.delete(dataSource, bean.getTopiaId());
        return true;
    }

    @Override
    protected Maree onPreCreate(TopiaContext tx, Object parent, Maree bean) throws TopiaException {
        Programme parentBean = (Programme)parent;
        Date date = DBHelper.getDay((Date)new Date());
        bean.setDateDebut(date);
        if (log.isDebugEnabled()) {
            log.debug((Object)("date debut " + date));
            log.debug((Object)("programme : " + parentBean));
        }
        bean.setProgramme(parentBean);
        return bean;
    }

    @Override
    protected Maree onCreate(TopiaContext tx, Object parent, Maree bean) throws TopiaException {
        Maree beanToSave = (Maree)ObserveDAOHelper.getMareeDAO((TopiaContext)tx).create(new Object[0]);
        bean.setTopiaId(beanToSave.getTopiaId());
        return beanToSave;
    }

    @Override
    public void afterOpenData() {
        ObserveTreeHelper treeHelper = MareeUIHandler.getTreeHelper((JAXXContext)this.ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        treeHelper.refreshNode((NavNode)node.getParent(), true);
        this.getUi().restartEdit();
    }

    @Override
    public void afterCloseData() {
        this.closeOpenable((Openable)this.getBean(), I18n._((String)"observe.message.maree.not.open"));
    }

    @Override
    protected void afterSave(boolean refresh) {
        BeanValidatorUtil.setValidatorChanged((JAXXObject)this.ui, (boolean)false, (String[])new String[0]);
        int position = this.ui.getContextValue(Integer.class, POSITION_MAREE);
        ObserveTreeHelper treeHelper = MareeUIHandler.getTreeHelper((JAXXContext)this.ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        ObserveNode parentNode = (ObserveNode)node.getParent();
        boolean create = node.getId() == null;
        Maree bean = (Maree)this.getBean();
        int oldPosition = create ? parentNode.getChildCount() : parentNode.getIndex((TreeNode)((Object)node));
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            treeHelper.removeNode((NavNode)node);
            node = treeHelper.addMaree(parentNode, bean);
            this.stopEditUI();
            if (oldPosition != position) {
                treeHelper.moveNode((NavNode)parentNode, (NavNode)node, position);
            }
            treeHelper.selectNode((NavNode)node);
        } else {
            if (oldPosition != position) {
                treeHelper.moveNode((NavNode)parentNode, (NavNode)node, position);
                treeHelper.selectNode((NavNode)node);
            }
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected void afterDelete() {
        this.ui.stopEdit();
        ObserveTreeHelper treeHelper = MareeUIHandler.getTreeHelper((JAXXContext)this.ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
        treeHelper.selectNode((NavNode)parentNode);
    }
}

