/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.TopiaExecutor;
import fr.ird.observe.db.TopiaExecutor2;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public abstract class ContentUIHandler<E extends TopiaEntity> {
    private static final Log log = LogFactory.getLog(ContentUIHandler.class);
    public static final String OBSERVE_ACTION = "observeAction";
    protected final ContentUI<E> ui;
    private TopiaEntityBinder<E> openingBinder;
    private TopiaExecutor<E> openingExecutor;
    private TopiaExecutor2<? extends TopiaEntity, E> preCreateExecutor;
    private TopiaExecutor2<? extends TopiaEntity, E> createExecutor;
    private Deletor<Object, E> deletator;
    private TopiaExecutor<E> updator;

    public ContentUIHandler(ContentUI<E> ui) {
        this.ui = ui;
        if (log.isDebugEnabled()) {
            log.debug((Object)("New handler [" + this + "] for ui : " + ((Object)ui).getClass().getName()));
        }
    }

    public ContentUI<E> getUi() {
        return this.ui;
    }

    public ContentUIModel<E> getModel() {
        return this.getUi().getModel();
    }

    public Class<E> getBeanType() {
        Class<E> mainEntityClass = this.getModel().getBeanType();
        return mainEntityClass;
    }

    public E getBean() {
        ContentUIModel<E> model = this.getModel();
        E bean = model.getBean();
        return bean;
    }

    protected DataContext getDataContext() {
        DataContext dataContext = this.ui.getDataContext();
        return dataContext;
    }

    public BinderService getBinderService() {
        return ObserveContext.get().getBinderService();
    }

    protected DataSource getDataSource() {
        return this.ui.getDataSource();
    }

    protected boolean doSave(E bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<E> binder) throws Exception {
        return false;
    }

    protected boolean doDelete(E bean, DataService dataService, DataSource dataSource, Deletor<Object, E> deletor) throws Exception {
        return false;
    }

    protected void afterSave(boolean refresh) {
    }

    protected void afterDelete() {
    }

    public void doOpenData() throws Exception {
        E editBean = this.ui.getModel().getBean();
        this.getDataService().updateOpenProperty(this.getDataSource(), editBean.getTopiaId(), true);
    }

    public void afterOpenData() {
    }

    public boolean doCloseData() throws Exception {
        return this.doCloseData(this.getBean().getTopiaId());
    }

    public boolean doCloseData(String id) throws Exception {
        this.getDataService().updateOpenProperty(this.getDataSource(), id, false);
        return true;
    }

    public void afterCloseData() {
    }

    public void initUI() throws Exception {
        ObserveMainUI mainUI;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ui " + this.getClass()));
        }
        if ((mainUI = this.ui.getParentContainer(ObserveMainUI.class)) == null) {
            log.warn((Object)"could not find mainUI in context...");
            mainUI = ObserveContext.get().getObserveMainUI();
        }
        ActionMap actionMap = mainUI.getRootPane().getActionMap();
        DataSource service = this.getDataSource();
        this.init(service, (TopiaEntity)this.getBean());
        for (String name : this.ui.get$objectMap().keySet()) {
            Object o = this.ui.getObjectById(name);
            if (o == null) continue;
            if (o instanceof TopiaEntity) {
                this.init(service, (TopiaEntity)o);
                continue;
            }
            if (o instanceof AbstractButton) {
                this.init(actionMap, (AbstractButton)o);
                continue;
            }
            if (o instanceof NumberEditor) {
                this.init((NumberEditor)o);
                continue;
            }
            if (o instanceof EntityComboBox) {
                this.init(service, (EntityComboBox)o);
                continue;
            }
            if (o instanceof JList) {
                this.init(service, (JList)o);
                continue;
            }
            if (o instanceof JXDatePicker) {
                this.init((JXDatePicker)o);
                continue;
            }
            if (!(o instanceof TimeEditor)) continue;
            this.init((TimeEditor)o);
        }
    }

    public void openUI() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ui " + ((Object)this.ui).getClass()));
        }
        ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
        AbstractObserveTreeCellRenderer render = treeHelper.getTreeCellRenderer();
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        this.ui.setContentIcon(render.getNavigationIcon(node));
        this.updateActions();
    }

    public void startEditUI(String ... binding) {
        E editBean = this.getBean();
        this.prepareValidationContext();
        BeanValidatorUtil.setValidatorBean(this.ui, null, (String[])new String[0]);
        this.getModel().setEditing(true);
        BeanValidatorUtil.setValidatorBean(this.ui, editBean, (String[])new String[0]);
        if (binding.length > 0) {
            UIHelper.processDataBinding(this.ui, (String[])binding);
        }
        UIHelper.processDataBinding(this.ui, (String[])new String[]{"reset.enabled", "save.enabled"});
    }

    protected void prepareValidationContext() {
        ObserveServiceHelper.get().getValidationContext().cleanCache();
    }

    public void resetEditUI() {
        this.stopEditUI();
        ContentUIHandler.removeAllMessages(this.ui);
        try {
            this.openUI();
        }
        catch (Exception ex) {
            ErrorDialogUI.showError((Exception)ex);
            log.error((Object)ex.getMessage(), (Throwable)ex);
            this.stopEditUI();
        }
    }

    public void restartEditUI() {
        ContentUIModel<E> model = this.getModel();
        if (model.isEditable()) {
            log.info((Object)("Will restart edit " + ((Object)this.getUi()).getClass().getName()));
            ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
            ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
            ContentUIHandler.removeAllMessages(this.ui);
            treeHelper.refreshNode((NavNode)node, true);
            model.setMode(ContentMode.UPDATE);
            this.ui.startEdit(null);
            this.updateActions();
        }
    }

    public void stopEditUI() {
        ObserveServiceHelper.getValidationContext().cleanCache();
        ContentUIModel<E> model = this.getModel();
        model.setEditing(false);
        model.setValid(true);
        model.setModified(false);
        this.ui.removeContextValue(model.getBeanType(), "edit");
        BeanValidatorUtil.setValidatorBean(this.ui, null, (String[])new String[0]);
    }

    public boolean closeUI() throws Exception {
        boolean b = ContentUIHandler.checkEdit(this.ui);
        if (b) {
            ObserveTreeHelper treehelper;
            ObserveNode node;
            ContentUIHandler.removeAllMessages(this.ui);
            ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.removeContextValue((JAXXContext)ObserveContext.get());
            ContentUIModel<E> model = this.getModel();
            boolean create = model.isCreatingMode();
            if (create && model.isEditable() && (node = (ObserveNode)(treehelper = ContentUIHandler.getTreeHelper(this.ui)).getSelectedNode()).getParent() != null) {
                treehelper.removeNode((NavNode)node);
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveUI(boolean refresh) {
        boolean ok = false;
        try {
            ok = this.doSave(this.getBean(), this.getDataService(), this.getDataSource(), this.getOpeningBinder());
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e);
        }
        finally {
            if (ok) {
                this.afterSave(refresh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteUI() {
        boolean ok = false;
        try {
            ok = this.doDelete(this.getBean(), this.getDataService(), this.getDataSource(), this.getDeletator());
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e);
        }
        finally {
            if (ok) {
                this.afterDelete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDataUI() {
        boolean ok = false;
        try {
            this.doOpenData();
            ok = true;
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e);
        }
        finally {
            if (ok) {
                this.afterOpenData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDataUI() {
        boolean ok = false;
        try {
            ok = this.doCloseData();
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e);
        }
        finally {
            if (ok) {
                this.afterCloseData();
            }
        }
    }

    public void gotoChild(TopiaEntity entity) {
        if (entity == null) {
            return;
        }
        ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
        ObserveNode parentNode = (ObserveNode)treeHelper.getSelectedNode();
        String id = entity.getTopiaId();
        ObserveNode node = (ObserveNode)treeHelper.findNode((NavNode)parentNode, new String[]{id});
        if (log.isInfoEnabled()) {
            log.info((Object)("will go to node " + (Object)((Object)node) + " for " + id));
        }
        treeHelper.selectNode((NavNode)node);
    }

    public void addChild(Class<?> type) {
        ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
        ObserveNode parentNode = (ObserveNode)treeHelper.getSelectedNode();
        ObserveNode node = treeHelper.addUnsavedNode(parentNode, type);
    }

    protected void closeOpenable(Openable bean, String message) {
        this.ui.stopEdit();
        this.ui.getModel().setMode(ContentMode.READ);
        ContentUIHandler.removeAllMessages(this.ui);
        ContentUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(bean.getClass()), message);
        ObserveTreeHelper treeHelper = ContentUIHandler.getTreeHelper(this.ui);
        ObserveNode selectedNode = (ObserveNode)treeHelper.getSelectedNode();
        if (bean instanceof Maree) {
            selectedNode = (ObserveNode)selectedNode.getParent();
        }
        treeHelper.refreshNode((NavNode)selectedNode, true);
        this.updateActions();
    }

    protected void onLoad(TopiaContext tx, E bean) throws TopiaException {
        this.getOpeningBinder().load(bean, this.getBean(), true, new String[0]);
    }

    protected E onPreCreate(TopiaContext tx, Object parentBean, E bean) throws TopiaException {
        return bean;
    }

    protected E onCreate(TopiaContext tx, Object parentBean, E bean) throws TopiaException {
        return bean;
    }

    protected void onDelete(TopiaContext tx, Object parentBean, E bean) {
    }

    protected E onUpdate(TopiaContext tx, E bean) throws TopiaException {
        return bean;
    }

    protected void addInfoMessage(String message) {
        ContentUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(this.getModel().getBeanType()), I18n._((String)message));
    }

    protected String getEntityLabel(Class<?> klass) {
        String result = this.getDecoratorService().getEntityLabel(klass);
        return result;
    }

    protected void init(DataSource service, TopiaEntity entity) throws DataSourceException {
        if (entity == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init entity " + entity.getClass()));
        }
        ContentUIHandler.attachTopiaContext(service, (TopiaEntityAbstract)entity);
    }

    protected void init(ActionMap actionMap, AbstractButton editor) throws DataSourceException {
        String actionId = (String)editor.getClientProperty(OBSERVE_ACTION);
        if (actionId == null) {
            return;
        }
        AbstractUIAction action = (AbstractUIAction)actionMap.get(actionId);
        if (action == null) {
            throw new IllegalStateException("action [" + actionId + "] not found for ui " + ((Object)this.ui).getClass().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("init common action " + actionId));
        }
        action.initAction(null, editor);
    }

    protected void init(NumberEditor editor) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
    }

    protected void init(DataSource service, EntityComboBox entityComboBox) throws DataSourceException {
        Class klass = entityComboBox.getHandler().getTargetClass();
        if (log.isInfoEnabled()) {
            log.info((Object)("init combobox for " + klass));
        }
        entityComboBox.setI18nPrefix("observe.common.");
        entityComboBox.setMinimumSize(new Dimension(0, 24));
        UIHelper.prepareEntityComboBox(service, klass, entityComboBox);
    }

    protected void init(DataSource service, JList jlist) throws DataSourceException {
        Class klass;
        Object init = jlist.getClientProperty("doInit");
        if (init != null) {
            klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("init list for " + klass));
            }
            UIHelper.prepareEntityList(service, klass, jlist);
        }
        if ((init = jlist.getClientProperty("addDecorator")) != null) {
            klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            Decorator decorator = this.getDecoratorService().getDecorator(klass);
            jlist.putClientProperty("decorator", decorator);
            jlist.setCellRenderer(new DecoratorListCellRenderer(decorator));
        }
        if ((init = jlist.getClientProperty("addToogleListSelectionModel")) != null && init instanceof Boolean && ((Boolean)init).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            UIHelper.prepareToogleListSelectionModel(jlist);
        }
    }

    protected void init(TimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName() + " for property " + editor.getProperty()));
        }
        editor.init();
    }

    protected void init(JXDatePicker picker) {
        log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        picker.getEditor().setEditable(false);
    }

    protected TopiaEntityBinder<E> getOpeningBinder() {
        if (this.openingBinder == null) {
            this.openingBinder = this.createOpeningBinder(this.getBinderService());
        }
        return this.openingBinder;
    }

    public TopiaExecutor2<? extends TopiaEntity, E> getPreCreateExecutor() {
        if (this.preCreateExecutor == null) {
            this.preCreateExecutor = new TopiaExecutor2<TopiaEntity, E>(){

                public E execute(TopiaContext tx, TopiaEntity parentBean, E bean) throws TopiaException {
                    return ContentUIHandler.this.onPreCreate(tx, parentBean, bean);
                }
            };
        }
        return this.preCreateExecutor;
    }

    public TopiaExecutor2<? extends TopiaEntity, E> getCreateExecutor() {
        if (this.createExecutor == null) {
            this.createExecutor = new TopiaExecutor2<TopiaEntity, E>(){

                public E execute(TopiaContext tx, TopiaEntity parentBean, E bean) throws TopiaException {
                    return ContentUIHandler.this.onCreate(tx, parentBean, bean);
                }
            };
        }
        return this.createExecutor;
    }

    public TopiaExecutor<E> getOpeningExecutor() {
        if (this.openingExecutor == null) {
            this.openingExecutor = this.createOpeningExecutor();
        }
        return this.openingExecutor;
    }

    protected Deletor<Object, E> getDeletator() {
        if (this.deletator == null) {
            this.deletator = this.createDeletator();
        }
        return this.deletator;
    }

    public TopiaExecutor<E> getUpdator() {
        if (this.updator == null) {
            this.updator = new TopiaExecutor<E>(){

                public void execute(TopiaContext tx, E bean) throws TopiaException {
                    ContentUIHandler.this.onUpdate(tx, bean);
                }
            };
        }
        return this.updator;
    }

    protected final TopiaExecutor<E> createOpeningExecutor() {
        return new TopiaExecutor<E>(){

            public void execute(TopiaContext tx, E bean) throws TopiaException {
                ContentUIHandler.this.onLoad(tx, bean);
            }
        };
    }

    protected final Deletor<Object, E> createDeletator() {
        Deletor result = new Deletor<Object, E>(){

            public void delete(TopiaContext tx, Object parent, E from) {
                ContentUIHandler.this.onDelete(tx, parent, from);
            }
        };
        return result;
    }

    protected TopiaEntityBinder<E> createOpeningBinder(BinderService binderService) {
        return null;
    }

    public DecoratorService getDecoratorService() {
        DecoratorService result = ObserveContext.get().getDecoratorService();
        return result;
    }

    protected abstract ContentMode getContentMode(DataContext var1);

    protected ContentMode prepareContentMode() {
        ContentMode mode;
        if (!this.getDataSource().canWriteData()) {
            this.addInfoMessage(I18n._((String)"observe.message.can.not.write.data"));
            mode = ContentMode.READ;
        } else {
            mode = this.getContentMode(this.getDataContext());
        }
        return mode;
    }

    public void openLink(String url) {
        try {
            UIHelper.openLink((String)url);
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e);
        }
    }

    protected String getValidatorContextName(ContentMode mode) {
        String contextName = mode == ContentMode.CREATE ? "n1-create" : "n1-update";
        return contextName;
    }

    protected DataService getDataService() {
        return ObserveContext.get().getDataService();
    }

    protected static void attachTopiaContext(DataSource service, TopiaEntityAbstract entity) {
        DBHelper.attachTopiaContext((TopiaContext)service.getRootCtxt(), (TopiaEntityAbstract)entity);
    }

    protected void updateActions() {
        this.updateToolbarActions();
        ActionMap actionMap = ObserveContext.get().getActionMap();
        for (String name : this.ui.get$objectMap().keySet()) {
            AbstractButton button;
            String actionId;
            Object o = this.ui.getObjectById(name);
            if (!(o instanceof AbstractButton) || (actionId = (String)(button = (AbstractButton)o).getClientProperty(OBSERVE_ACTION)) == null) continue;
            AbstractUIAction action = (AbstractUIAction)actionMap.get(actionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("update common action " + actionId));
            }
            action.updateAction(this.ui, button);
        }
    }

    protected void updateToolbarActions() {
        Component[] components;
        ContentUI<E> ui = this.getUi();
        JToolBar toolBar = ui.getTitleRightToolBar();
        for (Component component : components = toolBar.getComponents()) {
            JComponent jcompo;
            if (component instanceof JComponent && (jcompo = (JComponent)component).getClientProperty("original") != null) continue;
            toolBar.remove(component);
        }
    }

    public static ObserveTreeHelper getTreeHelper(JAXXContext context) {
        return (ObserveTreeHelper)((Object)context.getContextValue(ObserveTreeHelper.class));
    }

    public static boolean checkEdit(ContentUI<?> ui) {
        ContentUIModel<?> model = ui.getModel();
        if (!(model.isEnabled() && model.isEditing() && model.isModified())) {
            if (model.isEditing()) {
                ui.stopEdit();
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"previousUI is in edit mode");
        }
        boolean wasClosed = true;
        if (model.isValid()) {
            int reponse = UIHelper.askUser(ui, I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.quit.valid.edit"), 2, new Object[]{I18n._((String)"observe.choice.save"), I18n._((String)"observe.choice.doNotSave"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 2: {
                    wasClosed = false;
                    break;
                }
                case 0: {
                    ui.save(false);
                    break;
                }
                case 1: {
                    ui.resetEdit();
                }
            }
        } else {
            int reponse = UIHelper.askUser(ui, I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.quit.invalid.edit"), 0, new Object[]{I18n._((String)"observe.choice.continue"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 1: {
                    wasClosed = false;
                    break;
                }
                case 0: {
                    ui.resetEdit();
                }
            }
        }
        if (wasClosed) {
            ui.stopEdit();
        }
        return wasClosed;
    }

    public static void addMessage(ContentUI<?> ui, BeanValidatorScope scope, String fieldName, String message) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.addMessages(ui, fieldName, scope, new String[]{message});
    }

    public static void removeAllMessages(ContentUI<?> ui, BeanValidatorScope scope, String fieldName) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.removeMessages(ui, fieldName, scope);
    }

    public static void removeAllMessages(ContentUI<?> ui) {
        SwingValidatorMessageTableModel model = ui.getErrorTableModel();
        model.removeMessages(ui, null);
    }
}

