/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report;

import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.report.ReportBuilder;
import fr.ird.observe.ui.admin.report.ResultTableModel;
import fr.ird.observe.ui.admin.report.model.Report;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportModel
extends AdminActionModel {
    private static final Log log = LogFactory.getLog(ReportModel.class);
    public static final String SELECTED_MAREE_PROPERTY_NAME = "selectedMaree";
    public static final String SELECTED_REPORT_PROPERTY_NAME = "selectedReport";
    public static final String REPORTS_PROPERTY_NAME = "reports";
    public static final String REPORT_FILE_PROPERTY_NAME = "reportFile";
    public static final String AUTO_COPY_TO_CLIPBOARD_PROPERTY_NAME = "autoCopyToClipboard";
    public static final Pattern REPORT_DEFINITION_PATTERN = Pattern.compile("report.(\\w+).name");
    protected File reportFile;
    protected List<Report> reports;
    protected Report selectedReport;
    protected ResultTableModel resultModel;
    protected DataSelectionModel selectReportDataModel = new DataSelectionModel();
    protected boolean autoCopyToClipboard;

    public ReportModel() {
        super(AdminStep.REPORT);
        this.selectReportDataModel.addPropertyChangeListener("selectedData", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ReportModel.this.setSelectedReport(null);
                ReportModel.this.firePropertyChange(ReportModel.SELECTED_MAREE_PROPERTY_NAME, ReportModel.this.getSelectedMaree());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Report> loadReports(URL resource) throws IOException {
        ReportBuilder builder = new ReportBuilder();
        try {
            List<Report> result;
            List<Report> list = result = builder.load(resource);
            return list;
        }
        finally {
            builder.clear();
        }
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        File old = this.reportFile;
        this.reportFile = reportFile;
        this.firePropertyChange(REPORT_FILE_PROPERTY_NAME, old, reportFile);
        this.reports = null;
        this.getReports();
    }

    public boolean isAutoCopyToClipboard() {
        return this.autoCopyToClipboard;
    }

    public void setAutoCopyToClipboard(boolean autoCopyToClipboard) {
        boolean oldValue = this.autoCopyToClipboard;
        this.autoCopyToClipboard = autoCopyToClipboard;
        this.firePropertyChange(AUTO_COPY_TO_CLIPBOARD_PROPERTY_NAME, oldValue, autoCopyToClipboard);
    }

    public DataSelectionModel getSelectReportDataModel() {
        return this.selectReportDataModel;
    }

    public String getSelectedMaree() {
        Set data = this.selectReportDataModel.getSelectedData();
        if (data.isEmpty()) {
            return null;
        }
        String id = (String)data.iterator().next();
        if (id.startsWith(Maree.class.getName())) {
            return id;
        }
        return null;
    }

    public ResultTableModel getResultModel() {
        if (this.resultModel == null) {
            this.resultModel = new ResultTableModel();
        }
        return this.resultModel;
    }

    public boolean isInit() {
        return this.reports != null;
    }

    public List<Report> getReports() {
        if (this.reports == null) {
            try {
                URL resource = this.reportFile.toURI().toURL();
                List<Report> reports = this.loadReports(resource);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add loaded " + reports.size() + " report(s)."));
                }
                this.setReports(reports);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not load reports definition file (" + this.reportFile + ").", e);
            }
        }
        return this.reports;
    }

    public Report getSelectedReport() {
        return this.selectedReport;
    }

    public void setSelectedReport(Report selectedReport) {
        Report old = this.selectedReport;
        this.selectedReport = selectedReport;
        this.firePropertyChange(SELECTED_REPORT_PROPERTY_NAME, old, selectedReport);
    }

    public void setReports(List<Report> reports) {
        this.reports = reports;
        this.firePropertyChange(REPORTS_PROPERTY_NAME, reports);
    }

    public void destroy() {
        super.destroy();
        this.selectReportDataModel.destroy();
    }
}

