/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIHandler;
import fr.ird.observe.ui.admin.AdminUIModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.wizard.BusyChangeListener;
import jaxx.runtime.swing.wizard.WizardUI;
import jaxx.runtime.swing.wizard.WizardUILancher;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;

public class AdminUILauncher
extends WizardUILancher<AdminStep, AdminUIModel, AdminUI> {
    private static final Log log = LogFactory.getLog(AdminUILauncher.class);
    protected Component parent;
    protected final AdminStep uniqueAction;

    public static AdminUILauncher newLauncher(JAXXContext context, AdminStep action) {
        AdminUIHandler handler = (AdminUIHandler)context.getContextValue(AdminUIHandler.class);
        if (handler == null) {
            handler = new AdminUIHandler();
            context.setContextValue((Object)handler);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register in context an admin handler : " + handler));
            }
        }
        return new AdminUILauncher(context, action);
    }

    protected AdminUILauncher(JAXXContext context, AdminStep uniqueAction) {
        super(context, AdminUI.class, AdminUIModel.class, I18n._((String)uniqueAction.getTitle()), I18n._((String)uniqueAction.getTitleTip()), uniqueAction.getIcon());
        this.uniqueAction = uniqueAction;
    }

    protected void init(AdminUI ui) {
        this.parent = this.getParent(ui);
        AdminUIModel model = ui.getModel();
        model.addOperation(this.uniqueAction);
        model.updateUniverse();
        if (this.uniqueAction != null) {
            ui.blockOperations();
        }
        BusyChangeListener listener = new BusyChangeListener(this.parent){

            protected void setBusy(Component ui) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Busy for component " + ui));
                }
                if (AdminUILauncher.this.parent instanceof ObserveMainUI) {
                    ((ObserveMainUI)AdminUILauncher.this.parent).setBusy(true);
                    super.setBusy(AdminUILauncher.this.parent);
                }
                super.setBusy(ui);
            }

            protected void setUnBusy(Component ui) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("UnBusy for component " + ui));
                }
                if (AdminUILauncher.this.parent instanceof ObserveMainUI) {
                    ((ObserveMainUI)AdminUILauncher.this.parent).setBusy(false);
                    super.setUnBusy(AdminUILauncher.this.parent);
                }
                super.setUnBusy(ui);
            }
        };
        UIHelper.getLayer((JComponent)ui.getTabs()).setUI((LayerUI)ui.getTabBusyBlockLayerUI());
        listener.setBlockingUI(ui.getTabBusyBlockLayerUI());
        model.addPropertyChangeListener("busy", (PropertyChangeListener)listener);
    }

    protected Component getParent(AdminUI ui) {
        ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
        ImageIcon icon = (ImageIcon)ui.getClientProperty("icon");
        if (mainUI == null) {
            JDialog dialog = new JDialog();
            dialog.setSize(650, 800);
            if (icon != null) {
                dialog.setIconImage(icon.getImage());
            }
            dialog.setDefaultCloseOperation(2);
            dialog.setAlwaysOnTop(true);
            dialog.setModal(true);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("closing dialog " + e.getWindow().getName()));
                    }
                    if (((AdminUI)AdminUILauncher.this.ui).getModel().getModelState() != WizardState.CANCELED) {
                        log.info((Object)("cancel panel from dialog !" + e.getWindow().getName()));
                        ((AdminUI)AdminUILauncher.this.ui).cancel();
                    }
                }
            });
            return dialog;
        }
        return mainUI;
    }

    protected void start(final AdminUI ui) {
        super.start((WizardUI)ui);
        ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
        String title = (String)ui.getClientProperty("title");
        if (mainUI == null) {
            JDialog dialog = (JDialog)this.parent;
            dialog.setTitle(I18n._((String)title));
            dialog.setContentPane(ui);
            dialog.pack();
            dialog.setVisible(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)"After dispay dialog");
            }
        } else {
            String tip = (String)ui.getClientProperty("tip");
            JXTitledPanel panel = mainUI.getSynchroWizard();
            panel.setTitle(I18n._((String)title));
            panel.setToolTipText(I18n._((String)tip));
            panel.setContentContainer((Container)ui);
            mainUI.setContextValue(ui.getModel());
            mainUI.setMode(ObserveUIMode.SYNCHRO);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ui.getTabs().getSelectedComponent().validate();
                }
            });
        }
    }

    protected void doClose(AdminUI ui, boolean wasCanceled) {
        block4: {
            log.info((Object)((Object)((Object)this) + ", was canceled ? " + wasCanceled));
            ObserveMainUI mainUI = null;
            AdminUIModel model = ui.getModel();
            try {
                model.doCloseSource(model.getTmpSource(), false);
                model.doCloseSource(model.getCentralSource(), false);
                model.doCloseSource(model.getLocalSource(), false);
                if (!(this.parent instanceof ObserveMainUI)) {
                    JDialog dialog = (JDialog)this.parent;
                    log.info((Object)"dispose ui! ");
                    ui.dispose();
                    dialog.setVisible(false);
                    dialog.dispose();
                    log.info((Object)"After dispose.");
                    ObserveContext.get().releaseLock();
                    return;
                }
                mainUI = (ObserveMainUI)this.parent;
                mainUI.getSynchroWizard().remove((Component)ui);
                mainUI.removeContextValue(((Object)((Object)model)).getClass());
                Object source = model.getPreviousSource();
                if (source == null) {
                    mainUI.setMode(ObserveUIMode.NO_DB);
                    return;
                }
                model.doCloseSource((DataSource)source, false);
                DataSourceConfig sourceConfig = source.getConfig();
                source = sourceConfig instanceof H2DataSourceConfig ? DataSourceFactory.newService((H2DataSourceConfig)((H2DataSourceConfig)sourceConfig)) : DataSourceFactory.newService((PGDataSourceConfig)((PGDataSourceConfig)sourceConfig));
                ObserveContext.get().prepareMainStorage((DataSource)source);
                source.doOpen();
            }
            catch (Exception e) {
                ErrorDialogUI.showError((Exception)e);
                log.error((Object)"Could not close ", (Throwable)e);
                if (mainUI == null) break block4;
                mainUI.setMode(ObserveUIMode.NO_DB);
            }
        }
    }
}

