/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureFaune;
import fr.ird.observe.entities.CaptureThon;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.EspeceFauneObservee;
import fr.ird.observe.entities.EstimationBanc;
import fr.ird.observe.entities.EstimationBancObjet;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.model.SelectDataModel;
import fr.ird.observe.entities.referentiel.ActiviteBateau;
import fr.ird.observe.entities.referentiel.ActiviteEnvironnante;
import fr.ird.observe.entities.referentiel.Bateau;
import fr.ird.observe.entities.referentiel.CategorieBateau;
import fr.ird.observe.entities.referentiel.CategoriePoids;
import fr.ird.observe.entities.referentiel.CauseCoupNul;
import fr.ird.observe.entities.referentiel.CauseNonCoupSenne;
import fr.ird.observe.entities.referentiel.DevenirFaune;
import fr.ird.observe.entities.referentiel.DevenirObjet;
import fr.ird.observe.entities.referentiel.EspeceFaune;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.entities.referentiel.GroupeEspeceFaune;
import fr.ird.observe.entities.referentiel.ModeDetection;
import fr.ird.observe.entities.referentiel.Observateur;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.OperationBalise;
import fr.ird.observe.entities.referentiel.OperationObjet;
import fr.ird.observe.entities.referentiel.Organisme;
import fr.ird.observe.entities.referentiel.ParametrageTaillePoidsFaune;
import fr.ird.observe.entities.referentiel.Pays;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.entities.referentiel.RaisonRejet;
import fr.ird.observe.entities.referentiel.Senne;
import fr.ird.observe.entities.referentiel.StatutEspece;
import fr.ird.observe.entities.referentiel.SystemeObserve;
import fr.ird.observe.entities.referentiel.TypeBalise;
import fr.ird.observe.entities.referentiel.TypeBateau;
import fr.ird.observe.entities.referentiel.TypeObjet;
import fr.ird.observe.entities.referentiel.VentBeaufort;
import fr.ird.observe.services.DecoratorService;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.content.data.ActiviteHandler;
import fr.ird.observe.ui.content.data.ActiviteUI;
import fr.ird.observe.ui.content.data.ActivitesHandler;
import fr.ird.observe.ui.content.data.ActivitesUI;
import fr.ird.observe.ui.content.data.CaleeHandler;
import fr.ird.observe.ui.content.data.CaleeUI;
import fr.ird.observe.ui.content.data.CaptureFauneHandler;
import fr.ird.observe.ui.content.data.CaptureFauneUI;
import fr.ird.observe.ui.content.data.CaptureThonHandler;
import fr.ird.observe.ui.content.data.CaptureThonUI;
import fr.ird.observe.ui.content.data.EchantillonFauneHandler;
import fr.ird.observe.ui.content.data.EchantillonFauneUI;
import fr.ird.observe.ui.content.data.EchantillonThonHandler;
import fr.ird.observe.ui.content.data.EchantillonThonUI;
import fr.ird.observe.ui.content.data.EspeceFauneObserveeHandler;
import fr.ird.observe.ui.content.data.EspeceFauneObserveeUI;
import fr.ird.observe.ui.content.data.EstimationBancHandler;
import fr.ird.observe.ui.content.data.EstimationBancObjetHandler;
import fr.ird.observe.ui.content.data.EstimationBancObjetUI;
import fr.ird.observe.ui.content.data.EstimationBancUI;
import fr.ird.observe.ui.content.data.MareeHandler;
import fr.ird.observe.ui.content.data.MareeUI;
import fr.ird.observe.ui.content.data.ObjetFlottantHandler;
import fr.ird.observe.ui.content.data.ObjetFlottantUI;
import fr.ird.observe.ui.content.data.OperationBaliseHandler;
import fr.ird.observe.ui.content.data.OperationBaliseUI;
import fr.ird.observe.ui.content.data.ProgrammeHandler;
import fr.ird.observe.ui.content.data.ProgrammeUI;
import fr.ird.observe.ui.content.data.RejetThonHandler;
import fr.ird.observe.ui.content.data.RejetThonUI;
import fr.ird.observe.ui.content.data.RouteHandler;
import fr.ird.observe.ui.content.data.RouteUI;
import fr.ird.observe.ui.content.data.RoutesHandler;
import fr.ird.observe.ui.content.data.RoutesUI;
import fr.ird.observe.ui.content.data.SystemObserveHandler;
import fr.ird.observe.ui.content.data.SystemObserveUI;
import fr.ird.observe.ui.content.referentiel.ActiviteBateauxHandler;
import fr.ird.observe.ui.content.referentiel.ActiviteBateauxUI;
import fr.ird.observe.ui.content.referentiel.ActiviteEnvironnantesHandler;
import fr.ird.observe.ui.content.referentiel.ActiviteEnvironnantesUI;
import fr.ird.observe.ui.content.referentiel.BateauxHandler;
import fr.ird.observe.ui.content.referentiel.BateauxUI;
import fr.ird.observe.ui.content.referentiel.CategorieBateauxHandler;
import fr.ird.observe.ui.content.referentiel.CategorieBateauxUI;
import fr.ird.observe.ui.content.referentiel.CategoriePoidsHandler;
import fr.ird.observe.ui.content.referentiel.CategoriePoidsUI;
import fr.ird.observe.ui.content.referentiel.CauseCoupNulsHandler;
import fr.ird.observe.ui.content.referentiel.CauseCoupNulsUI;
import fr.ird.observe.ui.content.referentiel.CauseNonCoupSennesHandler;
import fr.ird.observe.ui.content.referentiel.CauseNonCoupSennesUI;
import fr.ird.observe.ui.content.referentiel.DevenirFaunesHandler;
import fr.ird.observe.ui.content.referentiel.DevenirFaunesUI;
import fr.ird.observe.ui.content.referentiel.DevenirObjetsHandler;
import fr.ird.observe.ui.content.referentiel.DevenirObjetsUI;
import fr.ird.observe.ui.content.referentiel.EspeceFaunesHandler;
import fr.ird.observe.ui.content.referentiel.EspeceFaunesUI;
import fr.ird.observe.ui.content.referentiel.EspeceThonsHandler;
import fr.ird.observe.ui.content.referentiel.EspeceThonsUI;
import fr.ird.observe.ui.content.referentiel.GroupeEspeceFaunesHandler;
import fr.ird.observe.ui.content.referentiel.GroupeEspeceFaunesUI;
import fr.ird.observe.ui.content.referentiel.ModeDetectionsHandler;
import fr.ird.observe.ui.content.referentiel.ModeDetectionsUI;
import fr.ird.observe.ui.content.referentiel.ObservateursHandler;
import fr.ird.observe.ui.content.referentiel.ObservateursUI;
import fr.ird.observe.ui.content.referentiel.OceansHandler;
import fr.ird.observe.ui.content.referentiel.OceansUI;
import fr.ird.observe.ui.content.referentiel.OperationBalisesHandler;
import fr.ird.observe.ui.content.referentiel.OperationBalisesUI;
import fr.ird.observe.ui.content.referentiel.OperationObjetsHandler;
import fr.ird.observe.ui.content.referentiel.OperationObjetsUI;
import fr.ird.observe.ui.content.referentiel.OrganismesHandler;
import fr.ird.observe.ui.content.referentiel.OrganismesUI;
import fr.ird.observe.ui.content.referentiel.ParametrageTaillePoidsFaunesHandler;
import fr.ird.observe.ui.content.referentiel.ParametrageTaillePoidsFaunesUI;
import fr.ird.observe.ui.content.referentiel.PaysHandler;
import fr.ird.observe.ui.content.referentiel.PaysUI;
import fr.ird.observe.ui.content.referentiel.ProgrammesHandler;
import fr.ird.observe.ui.content.referentiel.ProgrammesUI;
import fr.ird.observe.ui.content.referentiel.RaisonRejetsHandler;
import fr.ird.observe.ui.content.referentiel.RaisonRejetsUI;
import fr.ird.observe.ui.content.referentiel.ReferentielHomeHandler;
import fr.ird.observe.ui.content.referentiel.ReferentielHomeUI;
import fr.ird.observe.ui.content.referentiel.SennesHandler;
import fr.ird.observe.ui.content.referentiel.SennesUI;
import fr.ird.observe.ui.content.referentiel.StatutEspecesHandler;
import fr.ird.observe.ui.content.referentiel.StatutEspecesUI;
import fr.ird.observe.ui.content.referentiel.SystemeObservesHandler;
import fr.ird.observe.ui.content.referentiel.SystemeObservesUI;
import fr.ird.observe.ui.content.referentiel.TypeBalisesHandler;
import fr.ird.observe.ui.content.referentiel.TypeBalisesUI;
import fr.ird.observe.ui.content.referentiel.TypeBateauxHandler;
import fr.ird.observe.ui.content.referentiel.TypeBateauxUI;
import fr.ird.observe.ui.content.referentiel.TypeObjetsHandler;
import fr.ird.observe.ui.content.referentiel.TypeObjetsUI;
import fr.ird.observe.ui.content.referentiel.VentBeaufortsHandler;
import fr.ird.observe.ui.content.referentiel.VentBeaufortsUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModel;
import jaxx.runtime.swing.navigation.tree.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class ObserveTreeModelBuilder
extends NavigationTreeModelBuilder {
    private static final Log log = LogFactory.getLog(ObserveTreeModelBuilder.class);

    public ObserveTreeModelBuilder(JAXXContext context) {
        this(context, false);
    }

    public ObserveTreeModelBuilder(JAXXContext context, boolean useSimpleContext) {
        super(ObserveContentUI.class, ObserveContentHandler.class, useSimpleContext ? new NavigationTreeModel("/", context) : new NavigationTreeModel("/", context){

            public JAXXContext getContext() {
                JAXXContext context = super.getContext();
                ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
                if (dataContext != null && !dataContext.getDelegate().equals(context)) {
                    context = dataContext.getDelegate();
                }
                return context;
            }
        });
    }

    public void createEmptyModel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create empty model " + (Object)((Object)this)));
        }
        NavigationTreeNode rootNode = this.buildEmptyRoot((JAXXContextEntryDef<?>)null, "$root");
        this.build((NavigationNode)rootNode, I18n.n_((String)"observe.message.db.none.loaded"), null, "nodb", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInitialModel(SelectDataModel model, boolean valueAdjusting) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create model for " + model));
        }
        if (valueAdjusting) {
            this.model.setAdjustingValue(true);
        }
        try {
            NavigationTreeNode node = this.buildEmptyRoot((JAXXContextEntryDef<?>)ObserveDataContext.dataEntry, "$root");
            if (model.isUseData()) {
                Map datas = model.getDatas();
                ArrayList programmes = new ArrayList(datas.keySet());
                DBHelper.sortProgrammes(programmes);
                for (Programme programme : programmes) {
                    NavigationTreeNode programmeNode = this.createProgrammeNode(node, programme);
                    List list = (List)datas.get(programme);
                    if (list == null) continue;
                    for (Maree maree : list) {
                        this.addMaree(programmeNode, maree, false);
                    }
                }
            }
            if (model.isUseReferentiel()) {
                this.buildReferentiel(node);
            }
        }
        finally {
            if (valueAdjusting) {
                this.model.setAdjustingValue(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInitialModel(Map<Programme, List<Maree>> datas) {
        this.model.setAdjustingValue(true);
        try {
            ArrayList<Programme> programmes = new ArrayList<Programme>(datas.keySet());
            if (log.isDebugEnabled()) {
                log.debug((Object)("create model for " + programmes.size() + " program(s)"));
            }
            NavigationTreeNode node = this.buildEmptyRoot((JAXXContextEntryDef<?>)ObserveDataContext.dataEntry, "$root");
            DBHelper.sortProgrammes(programmes);
            for (Programme programme : programmes) {
                NavigationTreeNode programmeNode = this.createProgrammeNode(node, programme);
                List<Maree> list = datas.get(programme);
                if (list == null) continue;
                for (Maree maree : list) {
                    this.addMaree(programmeNode, maree);
                }
            }
            this.buildReferentiel(node);
        }
        finally {
            this.model.setAdjustingValue(false);
        }
    }

    public NavigationTreeNode buildEmptyRoot(JAXXContextEntryDef<?> entryDef, String contextName) {
        NavigationTreeNode node = (NavigationTreeNode)super.buildEmptyRoot(entryDef, contextName);
        return node;
    }

    public DecoratorService getDecoratorService() {
        DecoratorService result = ObserveContext.get().getDecoratorService();
        return result;
    }

    protected void buildReferentiel(NavigationTreeNode rootNode) {
        NavigationTreeNode refNodes = this.createReferentielNode(rootNode);
        this.buildReferentiel(refNodes, ActiviteBateauxUI.class, ActiviteBateauxHandler.class, ActiviteBateau.class);
        this.buildReferentiel(refNodes, ActiviteEnvironnantesUI.class, ActiviteEnvironnantesHandler.class, ActiviteEnvironnante.class);
        this.buildReferentiel(refNodes, BateauxUI.class, BateauxHandler.class, Bateau.class);
        this.buildReferentiel(refNodes, CategorieBateauxUI.class, CategorieBateauxHandler.class, CategorieBateau.class);
        this.buildReferentiel(refNodes, CategoriePoidsUI.class, CategoriePoidsHandler.class, CategoriePoids.class);
        this.buildReferentiel(refNodes, CauseCoupNulsUI.class, CauseCoupNulsHandler.class, CauseCoupNul.class);
        this.buildReferentiel(refNodes, CauseNonCoupSennesUI.class, CauseNonCoupSennesHandler.class, CauseNonCoupSenne.class);
        this.buildReferentiel(refNodes, DevenirFaunesUI.class, DevenirFaunesHandler.class, DevenirFaune.class);
        this.buildReferentiel(refNodes, DevenirObjetsUI.class, DevenirObjetsHandler.class, DevenirObjet.class);
        this.buildReferentiel(refNodes, EspeceFaunesUI.class, EspeceFaunesHandler.class, EspeceFaune.class);
        this.buildReferentiel(refNodes, EspeceThonsUI.class, EspeceThonsHandler.class, EspeceThon.class);
        this.buildReferentiel(refNodes, GroupeEspeceFaunesUI.class, GroupeEspeceFaunesHandler.class, GroupeEspeceFaune.class);
        this.buildReferentiel(refNodes, ModeDetectionsUI.class, ModeDetectionsHandler.class, ModeDetection.class);
        this.buildReferentiel(refNodes, ObservateursUI.class, ObservateursHandler.class, Observateur.class);
        this.buildReferentiel(refNodes, OceansUI.class, OceansHandler.class, Ocean.class);
        this.buildReferentiel(refNodes, OperationBalisesUI.class, OperationBalisesHandler.class, OperationBalise.class);
        this.buildReferentiel(refNodes, OperationObjetsUI.class, OperationObjetsHandler.class, OperationObjet.class);
        this.buildReferentiel(refNodes, OrganismesUI.class, OrganismesHandler.class, Organisme.class);
        this.buildReferentiel(refNodes, ParametrageTaillePoidsFaunesUI.class, ParametrageTaillePoidsFaunesHandler.class, ParametrageTaillePoidsFaune.class);
        this.buildReferentiel(refNodes, PaysUI.class, PaysHandler.class, Pays.class);
        this.buildReferentiel(refNodes, ProgrammesUI.class, ProgrammesHandler.class, Programme.class);
        this.buildReferentiel(refNodes, RaisonRejetsUI.class, RaisonRejetsHandler.class, RaisonRejet.class);
        this.buildReferentiel(refNodes, SennesUI.class, SennesHandler.class, Senne.class);
        this.buildReferentiel(refNodes, StatutEspecesUI.class, StatutEspecesHandler.class, StatutEspece.class);
        this.buildReferentiel(refNodes, SystemeObservesUI.class, SystemeObservesHandler.class, SystemeObserve.class);
        this.buildReferentiel(refNodes, TypeBalisesUI.class, TypeBalisesHandler.class, TypeBalise.class);
        this.buildReferentiel(refNodes, TypeBateauxUI.class, TypeBateauxHandler.class, TypeBateau.class);
        this.buildReferentiel(refNodes, TypeObjetsUI.class, TypeObjetsHandler.class, TypeObjet.class);
        this.buildReferentiel(refNodes, VentBeaufortsUI.class, VentBeaufortsHandler.class, VentBeaufort.class);
    }

    public NavigationTreeNode createReferentielNode(NavigationTreeNode rootNode) {
        NavigationTreeNode refNodes = (NavigationTreeNode)this.build((NavigationNode)rootNode, I18n.n_((String)"observe.common.referentiel"), null, "referentiel", ReferentielHomeUI.class, ReferentielHomeHandler.class);
        return refNodes;
    }

    public NavigationTreeNode createProgrammeNode(NavigationTreeNode rootNode, Programme programme) {
        Decorator decorator = this.getDecoratorService().getDecorator(Programme.class);
        String programmeId = programme.getTopiaId();
        NavigationTreeNode node = (NavigationTreeNode)this.build((NavigationNode)rootNode, decorator, "..[@name=\"key:" + programmeId + "\"]", programmeId, ProgrammeUI.class, ProgrammeHandler.class);
        node.setBean((Object)programme);
        return node;
    }

    public NavigationTreeNode createMareeNode(NavigationTreeNode programmeNode, Maree maree) {
        NavigationTreeNode node = maree == null ? this.build(programmeNode, I18n.n_((String)"observe.common.unsaved.maree"), "../.", null, MareeUI.class, MareeHandler.class, Maree.class) : (NavigationTreeNode)this.build((NavigationNode)programmeNode, this.getDecoratorService().getDecorator(Maree.class), ObserveDataContext.dataEntry, ".[@name=\"value:" + maree.getTopiaId() + "\"]", maree.getTopiaId(), MareeUI.class, MareeHandler.class);
        node.setBean((Object)maree);
        return node;
    }

    public NavigationTreeNode createRoutesNode(NavigationTreeNode mareeNode) {
        NavigationTreeNode routesNode = this.build(mareeNode, I18n.n_((String)"observe.common.routes"), "../.", "route", RoutesUI.class, RoutesHandler.class, Route.class);
        return routesNode;
    }

    public NavigationTreeNode createRouteNode(NavigationTreeNode routesNode, Route route) {
        NavigationTreeNode node = route == null ? this.build(routesNode, I18n.n_((String)"observe.common.unsaved.route"), "..", null, RouteUI.class, RouteHandler.class, Route.class) : (NavigationTreeNode)this.build((NavigationNode)routesNode, this.getDecoratorService().getDecorator(Route.class), "../route[@topiaId=\"" + route.getTopiaId() + "\"]", route.getTopiaId(), RouteUI.class, RouteHandler.class);
        node.setBean((Object)route);
        return node;
    }

    public NavigationTreeNode createActivitesNode(NavigationTreeNode routeNode) {
        NavigationTreeNode activitesNode = this.build(routeNode, I18n.n_((String)"observe.common.activites"), "..", "activite", ActivitesUI.class, ActivitesHandler.class, Activite.class);
        return activitesNode;
    }

    public NavigationTreeNode createSystemeObserveNode(NavigationTreeNode activiteNode) {
        NavigationTreeNode node = this.build(activiteNode, I18n.n_((String)"observe.common.systemeObserve"), "..", "systemeObserve", SystemObserveUI.class, SystemObserveHandler.class, SystemeObserve.class);
        return node;
    }

    public NavigationTreeNode createActiviteNode(NavigationTreeNode activitesNode, Activite activite) {
        NavigationTreeNode activiteNode;
        if (activite == null) {
            activiteNode = this.build(activitesNode, I18n.n_((String)"observe.common.unsaved.activite"), "..", null, ActiviteUI.class, ActiviteHandler.class, Activite.class);
        } else {
            activiteNode = (NavigationTreeNode)this.build((NavigationNode)activitesNode, this.getDecoratorService().getDecorator(Activite.class), "../activite[@topiaId=\"" + activite.getTopiaId() + "\"]", activite.getTopiaId(), ActiviteUI.class, ActiviteHandler.class);
            activiteNode.setBean((Object)activite);
        }
        return activiteNode;
    }

    public NavigationTreeNode createObjetFlottantNode(NavigationTreeNode activiteNode, ObjetFlottant objetFlottant) {
        NavigationTreeNode node = objetFlottant == null ? this.build(activiteNode, I18n.n_((String)"observe.common.unsaved.objetFlottant"), "../objetFlottant", null, ObjetFlottantUI.class, ObjetFlottantHandler.class, OperationBalise.class) : (NavigationTreeNode)this.build((NavigationNode)activiteNode, this.getDecoratorService().getDecorator(ObjetFlottant.class), "../objetFlottant[@topiaId=\"" + objetFlottant.getTopiaId() + "\"]", objetFlottant.getTopiaId(), ObjetFlottantUI.class, ObjetFlottantHandler.class);
        node.setBean((Object)objetFlottant);
        return node;
    }

    public NavigationTreeNode createEspeceFauneObserveNode(NavigationTreeNode objetFlottantNode) {
        return this.build(objetFlottantNode, I18n.n_((String)"observe.common.especeFauneObservee"), "..", "especeFauneObservee", EspeceFauneObserveeUI.class, EspeceFauneObserveeHandler.class, EspeceFauneObservee.class);
    }

    public NavigationTreeNode createEstimationBancObjetNode(NavigationTreeNode objetFlottantNode) {
        return this.build(objetFlottantNode, I18n.n_((String)"observe.common.estimationBancObjet"), "..", "estimationBancObjet", EstimationBancObjetUI.class, EstimationBancObjetHandler.class, EstimationBancObjet.class);
    }

    public NavigationTreeNode createOperationBaliseNode(NavigationTreeNode objetFlottantNode) {
        return this.build(objetFlottantNode, I18n.n_((String)"observe.common.operationBalise"), "..", "operationBalise", OperationBaliseUI.class, OperationBaliseHandler.class, OperationBalise.class);
    }

    public NavigationTreeNode createEchantillonFauneNode(NavigationTreeNode caleeNode) {
        return this.build(caleeNode, I18n.n_((String)"observe.common.echantillonFaune"), "../echantillonFaune[\"0\"]", "echantillonFaune", EchantillonFauneUI.class, EchantillonFauneHandler.class, EchantillonFaune.class);
    }

    public NavigationTreeNode createCaleeNode(NavigationTreeNode activiteNode, Calee calee) {
        NavigationTreeNode node = calee == null ? this.build(activiteNode, I18n.n_((String)"observe.common.unsaved.calee"), "../calee", null, CaleeUI.class, CaleeHandler.class, CaptureThon.class) : this.build(activiteNode, I18n.n_((String)"observe.common.calee"), "../calee", calee.getTopiaId(), CaleeUI.class, CaleeHandler.class, Calee.class);
        node.setBean((Object)calee);
        return node;
    }

    public NavigationTreeNode createCaptureFauneNode(NavigationTreeNode caleeNode) {
        return this.build(caleeNode, I18n.n_((String)"observe.common.captureFaune"), "..", "captureFaune", CaptureFauneUI.class, CaptureFauneHandler.class, CaptureFaune.class);
    }

    public NavigationTreeNode createEchantillonThonNode(NavigationTreeNode caleeNode) {
        return this.build(caleeNode, I18n.n_((String)"observe.common.echantillonThon"), "../echantillonThon[\"0\"]", "echantillonThon", EchantillonThonUI.class, EchantillonThonHandler.class, EchantillonThon.class);
    }

    public NavigationTreeNode createRejetThonNode(NavigationTreeNode caleeNode) {
        return this.build(caleeNode, I18n.n_((String)"observe.common.rejetThon"), "..", "rejetThon", RejetThonUI.class, RejetThonHandler.class, CaptureThon.class);
    }

    public NavigationTreeNode createCaptureThonNode(NavigationTreeNode caleeNode) {
        return this.build(caleeNode, I18n.n_((String)"observe.common.captureThon"), "..", "captureThon", CaptureThonUI.class, CaptureThonHandler.class, CaptureThon.class);
    }

    public NavigationTreeNode createEstimationBancNode(NavigationTreeNode caleeNode) {
        return this.build(caleeNode, I18n.n_((String)"observe.common.estimationBanc"), "..", "estimationBanc", EstimationBancUI.class, EstimationBancHandler.class, EstimationBanc.class);
    }

    public NavigationTreeNode addMaree(NavigationTreeNode programmeNode, Maree maree) {
        NavigationTreeNode node = this.addMaree(programmeNode, maree, true);
        return node;
    }

    public NavigationTreeNode addMaree(NavigationTreeNode programmeNode, Maree maree, boolean copyRoute) {
        NavigationTreeNode node = this.createMareeNode(programmeNode, maree);
        if (maree != null && copyRoute) {
            NavigationTreeNode routesNode = this.createRoutesNode(node);
            if (maree.getRoute() != null) {
                for (Route route : maree.getRoute()) {
                    this.addRoute(routesNode, route);
                }
            }
        }
        return node;
    }

    public NavigationTreeNode addRoute(NavigationTreeNode routesNode, Route route) {
        NavigationTreeNode node = this.createRouteNode(routesNode, route);
        if (route != null) {
            NavigationTreeNode activitesNode = this.createActivitesNode(node);
            if (route.getActivite() != null) {
                for (Activite activite : route.getActivite()) {
                    this.addActivite(activitesNode, activite);
                }
            }
        }
        return node;
    }

    public NavigationTreeNode addActivite(NavigationTreeNode activitesNode, Activite activite) {
        NavigationTreeNode node = this.createActiviteNode(activitesNode, activite);
        if (activite != null) {
            this.createSystemeObserveNode(node);
            if (activite.getCalee() != null) {
                this.addCalee(node, activite.getCalee());
            }
            if (activite.getObjetFlottant() != null) {
                for (ObjetFlottant flottant : activite.getObjetFlottant()) {
                    this.addObjetFlottant(node, flottant);
                }
            }
        }
        return node;
    }

    public NavigationTreeNode addObjetFlottant(NavigationTreeNode activiteNode, ObjetFlottant objetFlottant) {
        NavigationTreeNode node = this.createObjetFlottantNode(activiteNode, objetFlottant);
        if (objetFlottant != null) {
            this.createOperationBaliseNode(node);
            this.createEstimationBancObjetNode(node);
            this.createEspeceFauneObserveNode(node);
        }
        return node;
    }

    public NavigationTreeNode addCalee(NavigationTreeNode activiteNode, Calee calee) {
        NavigationTreeNode node = this.createCaleeNode(activiteNode, calee);
        if (calee != null) {
            this.createEstimationBancNode(node);
            this.createCaptureThonNode(node);
            this.createRejetThonNode(node);
            this.createEchantillonThonNode(node);
            this.createCaptureFauneNode(node);
            this.createEchantillonFauneNode(node);
        }
        return node;
    }

    protected NavigationTreeNode buildReferentiel(NavigationTreeNode parentNode, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass, Class<? extends TopiaEntity> internalClass) {
        DecoratorService dService = this.getDecoratorService();
        String contextName = internalClass.getSimpleName();
        String libelle = dService.getEntityLabel(internalClass);
        JAXXContextEntryDef entryDef = UIHelper.newListContextEntryDef((String)contextName);
        NavigationTreeNode node = (NavigationTreeNode)this.build((NavigationNode)parentNode, libelle, entryDef, contextName, uiClass, actionClass);
        node.setInternalClass(internalClass);
        return node;
    }

    protected NavigationTreeNode build(NavigationTreeNode parentNode, String libelle, JAXXContextEntryDef<?> entryDef, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass, Class<?> internalClass) {
        NavigationTreeNode node = (NavigationTreeNode)this.build((NavigationNode)parentNode, libelle, entryDef, contextName, uiClass, actionClass);
        node.setInternalClass(internalClass);
        return node;
    }

    protected NavigationTreeNode build(NavigationTreeNode parentNode, String libelle, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass, Class<?> internalClass) {
        NavigationTreeNode node = (NavigationTreeNode)this.build((NavigationNode)parentNode, libelle, entryPath, contextName, uiClass, actionClass);
        node.setInternalClass(internalClass);
        return node;
    }
}

