/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.model.SelectDataModel;
import fr.ird.observe.services.storage.StorageConfig;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.constants.ConnexionStatus;
import fr.ird.observe.services.storage.constants.CreationMode;
import fr.ird.observe.services.storage.constants.DbMode;
import fr.ird.observe.services.storage.impl.H2StorageConfig;
import fr.ird.observe.services.storage.impl.PGStorageConfig;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

public class StorageUIModel
extends WizardModel<StorageStep> {
    private static Log log = LogFactory.getLog(StorageUIModel.class);
    public static final String DB_MODE_PROPERTY_NAME = "dbMode";
    public static final String CREATION_MODE_PROPERTY_NAME = "creationMode";
    public static final String DO_BACKUP_PROPERTY_NAME = "doBackup";
    public static final String BACKUP_FILE_PROPERTY_NAME = "backupFile";
    public static final String DUMP_FILE_PROPERTY_NAME = "dumpFile";
    public static final String LOCAL_STORAGE_EXIST_PROPERTY_NAME = "localStorageExist";
    public static final String USE_SSL_PROPERTY_NAME = "useSsl";
    public static final String SSL_CERTIFICAT_FILE_PROPERTY_NAME = "sslCertificatFile";
    public static final String SSL_CERTIFICAT_PASSWORD_PROPERTY_NAME = "sslCertificatPassword";
    public static final String REMOTE_URL_ROPERTY_NAME = "remoteUrl";
    public static final String REMOTE_LOGIN_ROPERTY_NAME = "remoteLogin";
    public static final String REMOTE_PASSWORD_PROPERTY_NAME = "remotePassword";
    public static final String STORE_REMOTE_CONFIG_PROPERTY_NAME = "storeRemoteConfig";
    public static final String CONNEXION_STATUS_PROPERTY_NAME = "connexionStatus";
    public static final String PREVIOUS_SERVICE_PROPERTY_NAME = "previousService";
    public static final String CAN_MIGRATE_PROPERTY_NAME = "canMigrate";
    private static final String CAN_USE_LOCALE_SERVICE_PROPERTY_NAME = "canUseLocalService";
    public static final String VALID_PROPERTY_NAME = "valid";
    private static final char[] EMPTY_PASSWORD = new char[0];
    private static final String LOGIN_REFERENTIEL = "referentiel";
    protected DbMode dbMode;
    protected boolean localStorageExist;
    protected boolean doBackup;
    protected File backupFile = new File("");
    protected boolean storeRemoteConfig;
    protected StorageService<?> previousService;
    protected boolean canUseLocalService;
    protected SelectDataModel selectDataModel;
    protected H2StorageConfig h2Config;
    protected PGStorageConfig pgConfig = new PGStorageConfig(I18n.n_((String)"observe.storage.label.remote"));
    protected ObserveConfig config;
    protected List<StorageStep> excludeSteps;

    public StorageUIModel() {
        super(StorageStep.class, (WizardStep[])new StorageStep[]{StorageStep.CHOOSE_DB_MODE, StorageStep.CHOOSE_CREATION_MODE, StorageStep.BACKUP, StorageStep.CONFIRM});
        this.h2Config = new H2StorageConfig(I18n.n_((String)"observe.storage.label.local"));
        this.h2Config.setImportConfig((StorageConfig)this.pgConfig);
    }

    public void init(JAXXContext context) {
        StorageUIModel incomingModel = (StorageUIModel)((Object)context.getContextValue(StorageUIModel.class, "incoming"));
        this.config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        if (incomingModel != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("from a incoming model " + (Object)((Object)incomingModel)));
            }
            incomingModel.copyTo(this);
            return;
        }
        ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
        StorageService service = dataContext.getStorage();
        StorageUIHandler storageUIHandler = (StorageUIHandler)context.getContextValue(StorageUIHandler.class);
        SelectDataModel dataModel = (SelectDataModel)context.getContextValue(SelectDataModel.class);
        this.setLocalStorageExist(this.config.isLocalStorageExist());
        this.setStoreRemoteConfig(this.config.isStoreRemoteStorage());
        this.setBackupFile(new File(this.config.getBackupDirectory(), storageUIHandler.getDefaultBackupFilename()));
        this.setDoBackup(false);
        this.setPreviousService(service);
        if (log.isDebugEnabled()) {
            log.debug((Object)("canMigrate ? " + this.isCanMigrate()));
        }
        CreationMode defaultcreationMode = this.config.getDefaultCreationMode();
        if (service != null) {
            StorageConfig previousConfig;
            if (log.isDebugEnabled()) {
                log.debug((Object)("from a previous service " + service));
            }
            if ((previousConfig = service.getConfig()) instanceof H2StorageConfig) {
                this.fromStorageConfig(this.config.toPostgresStorageConfig(this.pgConfig.getLabel()));
                this.fromStorageConfig((H2StorageConfig)previousConfig);
                this.setCanUseLocalService(false);
            } else {
                this.setCanUseLocalService(true);
                this.fromStorageConfig(this.config.toH2StorageConfig(this.pgConfig.getLabel()));
                if (!this.config.isLocalStorageExist()) {
                    this.setCreationMode(defaultcreationMode);
                }
                this.fromStorageConfig((PGStorageConfig)previousConfig);
            }
            this.setDumpFile(this.config.getBackupDirectory());
            if (dataModel != null) {
                this.setSelectDataModel(dataModel);
            }
            return;
        }
        this.setCanUseLocalService(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"no service found, using default configuration ");
        }
        this.fromStorageConfig(this.config.toH2StorageConfig(this.pgConfig.getLabel()));
        this.fromStorageConfig(this.config.toPostgresStorageConfig(this.pgConfig.getLabel()));
        DbMode defaultDbMode = this.config.getDefaultDbMode();
        if (this.isCanUseLocalService()) {
            defaultDbMode = DbMode.USE_LOCAL;
            defaultcreationMode = CreationMode.USE_LOCAL_STORAGE;
        }
        this.setDbMode(defaultDbMode);
        this.setCreationMode(defaultcreationMode);
        this.setDumpFile(this.config.getBackupDirectory());
    }

    public void start() {
        super.start();
        this.firePropertyChange(DB_MODE_PROPERTY_NAME, this.getDbMode());
        this.firePropertyChange(CREATION_MODE_PROPERTY_NAME, this.getCreationMode());
        this.firePropertyChange(DUMP_FILE_PROPERTY_NAME, this.h2Config.getDbDump());
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, this.getBackupFile());
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, this.isDoBackup());
        this.firePropertyChange(CAN_USE_LOCALE_SERVICE_PROPERTY_NAME, this.isCanUseLocalService());
        this.firePropertyChange(CONNEXION_STATUS_PROPERTY_NAME, this.pgConfig.getConnexionStatus());
        this.firePropertyChange(PREVIOUS_SERVICE_PROPERTY_NAME, this.getPreviousService());
        this.firePropertyChange(LOCAL_STORAGE_EXIST_PROPERTY_NAME, this.isLocalStorageExist());
        this.firePropertyChange(STORE_REMOTE_CONFIG_PROPERTY_NAME, this.isStoreRemoteConfig());
        this.firePropertyChange(REMOTE_URL_ROPERTY_NAME, this.getRemoteUrl());
        this.firePropertyChange(REMOTE_LOGIN_ROPERTY_NAME, this.getRemoteLogin());
        this.firePropertyChange(REMOTE_PASSWORD_PROPERTY_NAME, this.getRemotePassword());
        this.firePropertyChange(USE_SSL_PROPERTY_NAME, null, this.isUseSsl());
        this.firePropertyChange(SSL_CERTIFICAT_FILE_PROPERTY_NAME, this.getSslCertificatFile());
        this.firePropertyChange(SSL_CERTIFICAT_PASSWORD_PROPERTY_NAME, this.getSslCertificatPassword());
        this.firePropertyChange(CAN_MIGRATE_PROPERTY_NAME, this.isCanMigrate());
    }

    public boolean isCanUseLocalService() {
        return this.canUseLocalService;
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.firePropertyChange(propertyName, null, newValue);
    }

    public void updateUniverse() {
        if (this.dbMode == null) {
            return;
        }
        ArrayList<StorageStep> universe = new ArrayList<StorageStep>();
        universe.add(StorageStep.CHOOSE_DB_MODE);
        this.h2Config.setImportConfig(null);
        boolean canBackup = this.localStorageExist;
        switch (this.dbMode) {
            case CREATE_LOCAL: {
                universe.add(StorageStep.CHOOSE_CREATION_MODE);
                CreationMode creationMode = this.getCreationMode();
                if (creationMode == null) break;
                switch (creationMode) {
                    case USE_LOCAL_STORAGE: {
                        canBackup = false;
                        break;
                    }
                    case IMPORT_EXTERNAL_DUMP: {
                        universe.add(StorageStep.CONFIG);
                        break;
                    }
                    case IMPORT_REMOTE_STORAGE: {
                        this.h2Config.setImportConfig((StorageConfig)this.pgConfig);
                        universe.add(StorageStep.CONFIG);
                    }
                }
                break;
            }
            case USE_REMOTE: {
                canBackup = false;
                universe.add(StorageStep.CONFIG);
                break;
            }
            case USE_LOCAL: {
                canBackup = false;
            }
        }
        if (canBackup) {
            universe.add(StorageStep.BACKUP);
        }
        universe.add(StorageStep.CONFIRM);
        if (this.excludeSteps != null) {
            universe.removeAll(this.excludeSteps);
        }
        this.setSteps(universe.toArray(new StorageStep[universe.size()]));
    }

    public boolean validate(StorageStep s) {
        boolean validate = super.validate((WizardStep)s);
        if (validate) {
            switch (s) {
                case CHOOSE_DB_MODE: {
                    validate = this.dbMode != null;
                    break;
                }
                case CHOOSE_CREATION_MODE: {
                    boolean bl = validate = this.h2Config.getCreationMode() != null;
                    if (!validate) break;
                    if (this.dbMode == DbMode.CREATE_LOCAL) {
                        validate = this.h2Config.getCreationMode() != CreationMode.USE_LOCAL_STORAGE;
                        break;
                    }
                    validate = this.h2Config.getCreationMode() == CreationMode.USE_LOCAL_STORAGE;
                    break;
                }
                case CONFIG: {
                    if (this.dbMode == DbMode.USE_REMOTE) {
                        validate = this.pgConfig.isValid();
                        break;
                    }
                    validate = this.h2Config.isValid();
                    break;
                }
                case BACKUP: {
                    validate = !this.doBackup || this.backupFile != null && !this.backupFile.exists() && this.backupFile.getName().endsWith(".sql.gz");
                    break;
                }
                case SELECT_DATA: {
                    validate = this.selectDataModel != null && (this.selectDataModel.isUseReferentiel() || !this.selectDataModel.isDataEmpty());
                    break;
                }
                case CONFIRM: {
                    validate = true;
                }
            }
        }
        return validate;
    }

    public boolean isValid() {
        boolean result = false;
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case CREATE_LOCAL: {
                    result = this.getCreationMode() != null && this.validate(StorageStep.CONFIG);
                    break;
                }
                case USE_REMOTE: {
                    result = this.validate(StorageStep.CONFIG);
                    break;
                }
                case USE_LOCAL: {
                    result = this.h2Config.isValid() && this.h2Config.isStorageExists();
                }
            }
        }
        return result;
    }

    public boolean isUseSelectData() {
        return this.getSteps() != null && this.getSteps().contains((Object)StorageStep.SELECT_DATA);
    }

    public boolean isBackupAction() {
        return this.getSteps() != null && this.getStepIndex(StorageStep.BACKUP) == 0;
    }

    public boolean isLocal() {
        return this.dbMode != null && this.dbMode != DbMode.USE_REMOTE;
    }

    public boolean isRemote() {
        return this.dbMode != null && this.dbMode == DbMode.USE_REMOTE;
    }

    public boolean isCanMigrate() {
        boolean result = false;
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case CREATE_LOCAL: 
                case USE_LOCAL: {
                    result = this.h2Config.isCanMigrate();
                    break;
                }
                case USE_REMOTE: {
                    result = this.pgConfig.isCanMigrate();
                }
            }
        }
        return result;
    }

    public String getLabel() {
        String txt = this.dbMode == DbMode.CREATE_LOCAL ? this.h2Config.getLabel() : this.pgConfig.getLabel();
        return txt;
    }

    public boolean isLocalStorageExist() {
        return this.localStorageExist;
    }

    public boolean isStoreRemoteConfig() {
        return this.storeRemoteConfig;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public boolean isDoBackup() {
        return this.doBackup;
    }

    public Version getDbVersion() {
        if (this.config == null) {
            return Version.VZERO;
        }
        return this.config.getDbVersion();
    }

    public DbMode getDbMode() {
        return this.dbMode;
    }

    public StorageService<?> getPreviousService() {
        return this.previousService;
    }

    public ObserveConfig getConfig() {
        return this.config;
    }

    public void setDbMode(DbMode dbMode) {
        DbMode oldValue = this.dbMode;
        this.dbMode = dbMode;
        this.firePropertyChange(DB_MODE_PROPERTY_NAME, oldValue, dbMode);
        if (oldValue != dbMode) {
            if (dbMode == DbMode.USE_LOCAL) {
                this.setCreationMode(CreationMode.USE_LOCAL_STORAGE);
            } else {
                this.setCreationMode(null);
            }
            this.updateUniverse();
        }
        this.validate();
    }

    public void setCanMigrate(boolean canMigrate) {
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case CREATE_LOCAL: 
                case USE_LOCAL: {
                    this.h2Config.setCanMigrate(canMigrate);
                    break;
                }
                case USE_REMOTE: {
                    this.pgConfig.setCanMigrate(canMigrate);
                }
            }
        }
        this.firePropertyChange(CAN_MIGRATE_PROPERTY_NAME, null, canMigrate);
    }

    public void setLocalStorageExist(boolean localStorageExist) {
        boolean oldValue = this.localStorageExist;
        this.localStorageExist = localStorageExist;
        this.firePropertyChange(LOCAL_STORAGE_EXIST_PROPERTY_NAME, oldValue, localStorageExist);
        this.validate();
    }

    public void setStoreRemoteConfig(boolean storeRemoteConfig) {
        boolean oldValue = this.storeRemoteConfig;
        this.storeRemoteConfig = storeRemoteConfig;
        this.firePropertyChange(STORE_REMOTE_CONFIG_PROPERTY_NAME, oldValue, storeRemoteConfig);
    }

    public void setDoBackup(boolean doBackup) {
        boolean oldValue = this.doBackup;
        this.doBackup = doBackup;
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, oldValue, doBackup);
    }

    public void setBackupFile(File backupFile) {
        File oldValue = this.backupFile;
        this.backupFile = backupFile;
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, oldValue, backupFile);
        this.validate();
    }

    public void setExcludeSteps(List<StorageStep> excludeSteps) {
        this.excludeSteps = excludeSteps;
    }

    public void destroy() {
        super.destroy();
    }

    public CreationMode getCreationMode() {
        return this.h2Config.getCreationMode();
    }

    public File getDumpFile() {
        URL dbDump = this.h2Config.getDbDump();
        if (dbDump == null) {
            return new File("");
        }
        File file = new File(dbDump.getFile().replaceAll("%20", " "));
        file = new File(file.getAbsolutePath());
        return file;
    }

    public void setCreationMode(CreationMode creationMode) {
        String s;
        CreationMode oldValue = this.getCreationMode();
        this.h2Config.setCreationMode(creationMode);
        this.firePropertyChange(CREATION_MODE_PROPERTY_NAME, oldValue, creationMode);
        if (oldValue != creationMode) {
            this.updateUniverse();
        }
        if (creationMode == CreationMode.IMPORT_REMOTE_STORAGE && (s = this.getRemoteLogin()) != null && !LOGIN_REFERENTIEL.equals(s)) {
            this.setRemoteLogin(LOGIN_REFERENTIEL);
            this.setRemotePassword(EMPTY_PASSWORD);
        }
        this.validate();
    }

    public void setDumpFile(File dumpFile) {
        try {
            File oldValue = this.getDumpFile();
            URL url = null;
            if (dumpFile != null) {
                url = dumpFile.toURI().toURL();
                log.debug((Object)("dumpFile : " + dumpFile + " (exist ? : " + dumpFile.exists() + ')'));
                log.debug((Object)("dumpFile url : " + url));
                String filePath = url.getFile().replaceAll("%20", " ");
                log.debug((Object)("dumpFile file from url : " + filePath + " (exist ? : " + new File(filePath).exists() + ')'));
            }
            this.h2Config.setDbDump(dumpFile == null ? null : url);
            this.firePropertyChange(DUMP_FILE_PROPERTY_NAME, oldValue, dumpFile);
            this.validate();
        }
        catch (MalformedURLException ex) {
            log.warn((Object)ex);
        }
    }

    public String getRemoteLogin() {
        return this.pgConfig.getLogin();
    }

    public char[] getRemotePassword() {
        return this.pgConfig.getPassword();
    }

    public String getRemoteUrl() {
        return this.pgConfig.getUrl();
    }

    public boolean isUseSsl() {
        return this.pgConfig.isUseSsl();
    }

    public File getSslCertificatFile() {
        return this.pgConfig.getSslCertificatFile();
    }

    public char[] getSslCertificatPassword() {
        return this.pgConfig.getSslCertificatPassword();
    }

    public ConnexionStatus getConnexionStatus() {
        return this.pgConfig.getConnexionStatus();
    }

    public void setPreviousService(StorageService<?> previousService) {
        this.previousService = previousService;
    }

    public H2StorageConfig getH2Config() {
        return this.h2Config;
    }

    public PGStorageConfig getPgConfig() {
        return this.pgConfig;
    }

    public void setRemoteLogin(String remoteLogin) {
        String oldValue = this.getRemoteLogin();
        this.pgConfig.setLogin(remoteLogin);
        this.firePgConfigChanged(REMOTE_LOGIN_ROPERTY_NAME, oldValue, remoteLogin);
    }

    public void setRemotePassword(char[] remotePassword) {
        char[] oldValue = this.getRemotePassword();
        this.pgConfig.setPassword(remotePassword);
        this.firePgConfigChanged(REMOTE_PASSWORD_PROPERTY_NAME, oldValue, remotePassword);
    }

    public void setCanUseLocalService(boolean canUseLocalService) {
        this.canUseLocalService = canUseLocalService;
        this.firePgConfigChanged(CAN_USE_LOCALE_SERVICE_PROPERTY_NAME, null, canUseLocalService);
    }

    public void setRemoteUrl(String remoteUrl) {
        String oldValue = this.getRemoteUrl();
        this.pgConfig.setUrl(remoteUrl);
        this.firePgConfigChanged(REMOTE_URL_ROPERTY_NAME, oldValue, remoteUrl);
    }

    public void setUseSsl(boolean useSsl) {
        boolean oldValue = this.pgConfig.isUseSsl();
        this.pgConfig.setUseSsl(useSsl);
        this.firePgConfigChanged(USE_SSL_PROPERTY_NAME, oldValue, useSsl);
    }

    public void setSslCertificatFile(File sslCertificatFile) {
        File oldValue = this.getSslCertificatFile();
        this.pgConfig.setSslCertificatFile(sslCertificatFile);
        this.firePgConfigChanged(SSL_CERTIFICAT_FILE_PROPERTY_NAME, oldValue, sslCertificatFile);
    }

    public void setSslCertificatPassword(char[] password) {
        char[] oldValue = this.getRemotePassword();
        this.pgConfig.setSslCertificatPassword(password);
        this.firePgConfigChanged(SSL_CERTIFICAT_PASSWORD_PROPERTY_NAME, oldValue, password);
    }

    public void fromStorageConfig(H2StorageConfig config) {
        this.setDbMode(DbMode.CREATE_LOCAL);
        config.copyTo((StorageConfig)this.h2Config);
    }

    public void fromStorageConfig(PGStorageConfig config) {
        this.setDbMode(DbMode.USE_REMOTE);
        config.copyTo(this.pgConfig);
    }

    public H2StorageConfig toH2StorageConfig(String label) {
        H2StorageConfig result = (H2StorageConfig)this.h2Config.clone();
        result.setShortLabel(label);
        if (this.getDbMode() == DbMode.CREATE_LOCAL) {
            CreationMode m = result.getCreationMode();
            switch (m) {
                case USE_LOCAL_STORAGE: 
                case IMPORT_EXTERNAL_DUMP: 
                case EMPTY: {
                    break;
                }
                case IMPORT_INTERNAL_DUMP: {
                    try {
                        result.setDbDump(this.config.getInitialDbDump().toURI().toURL());
                        break;
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalArgumentException("can not build url for initialDbDump for reason " + ex.getMessage(), ex);
                    }
                }
                case IMPORT_LOCAL_STORAGE: {
                    result.getH2ImportConfig().setShortLabel(I18n.n_((String)"observe.storage.label.import.local"));
                    break;
                }
                case IMPORT_REMOTE_STORAGE: {
                    result.getPGImportConfig().setShortLabel(I18n.n_((String)"observe.storage.label.import.remote"));
                }
            }
        }
        return result;
    }

    public PGStorageConfig toPostgresStorageConfig(String label) {
        if (log.isInfoEnabled()) {
            log.info((Object)("before clone pg : policy = " + this.pgConfig.getPolicy()));
        }
        PGStorageConfig result = (PGStorageConfig)this.pgConfig.clone();
        if (log.isInfoEnabled()) {
            log.info((Object)("after clone pg : policy = " + result.getPolicy()));
        }
        result.setShortLabel(label);
        return result;
    }

    public SelectDataModel getSelectDataModel() {
        return this.selectDataModel;
    }

    public void setSelectDataModel(SelectDataModel selectDataModel) {
        this.selectDataModel = selectDataModel;
    }

    protected void copyTo(StorageUIModel dst) {
        dst.setLocalStorageExist(this.isLocalStorageExist());
        dst.setDbMode(this.getDbMode());
        dst.setBackupFile(this.getBackupFile());
        dst.setDoBackup(this.isDoBackup());
        dst.setStoreRemoteConfig(this.isStoreRemoteConfig());
        dst.setPreviousService(this.getPreviousService());
        this.pgConfig.copyTo(dst.pgConfig);
        this.h2Config.copyTo((StorageConfig)dst.h2Config);
        dst.setSelectDataModel(this.getSelectDataModel());
    }

    protected void firePgConfigChanged(String propertyName, Object oldValue, Object newValue) {
        if (!CONNEXION_STATUS_PROPERTY_NAME.equals(propertyName)) {
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
        this.firePropertyChange(CONNEXION_STATUS_PROPERTY_NAME, this.pgConfig.getConnexionStatus());
        this.validate();
    }
}

