/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.storage.ConnexionStatus;
import fr.ird.observe.storage.CreationMode;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageConfig;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.impl.H2StorageConfig;
import fr.ird.observe.storage.impl.PGStorageConfig;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

public class StorageUIModel
extends WizardModel<StorageStep> {
    private static Log log = LogFactory.getLog(StorageUIModel.class);
    public static final String DB_MODE_PROPERTY_NAME = "dbMode";
    public static final String CREATION_MODE_PROPERTY_NAME = "creationMode";
    public static final String DO_BACKUP_PROPERTY_NAME = "doBackup";
    public static final String BACKUP_FILE_PROPERTY_NAME = "backupFile";
    public static final String DUMP_FILE_PROPERTY_NAME = "dumpFile";
    public static final String LOCAL_STORAGE_EXIST_PROPERTY_NAME = "localStorageExist";
    public static final String USE_SSL_PROPERTY_NAME = "useSsl";
    public static final String SSL_CERTIFICAT_FILE_PROPERTY_NAME = "sslCertificatFile";
    public static final String REMOTE_URL_ROPERTY_NAME = "remoteUrl";
    public static final String REMOTE_LOGIN_ROPERTY_NAME = "remoteLogin";
    public static final String REMOTE_PASSWORD_PROPERTY_NAME = "remotePassword";
    public static final String STORE_REMOTE_CONFIG_PROPERTY_NAME = "storeRemoteConfig";
    public static final String CONNEXION_STATUS_PROPERTY_NAME = "connexionStatus";
    public static final String PREVIOUS_SERVICE_PROPERTY_NAME = "previousService";
    public static final String CAN_MIGRATE_PROPERTY_NAME = "canMigrate";
    public static final String VALID_PROPERTY_NAME = "valid";
    protected DbMode dbMode;
    protected boolean localStorageExist;
    protected boolean doBackup;
    protected File backupFile = new File("");
    protected boolean storeRemoteConfig;
    protected StorageService<?> previousService;
    protected boolean canUseLocalService;
    protected boolean canMigrate;
    protected H2StorageConfig h2Config;
    protected PGStorageConfig pgConfig = new PGStorageConfig(I18n.n_((String)"observe.storage.label.remote"));
    protected ObserveConfig config;
    protected List<StorageStep> excludeSteps;

    public StorageUIModel() {
        super(StorageStep.class, (WizardStep[])new StorageStep[]{StorageStep.CHOOSE_DB_MODE, StorageStep.CHOOSE_CREATION_MODE, StorageStep.BACKUP, StorageStep.CONFIRM});
        this.h2Config = new H2StorageConfig(I18n.n_((String)"observe.storage.label.local"));
        this.h2Config.setImportConfig((StorageConfig)this.pgConfig);
    }

    public void init(JAXXContext context) {
        StorageUIModel incomingModel = (StorageUIModel)((Object)context.getContextValue(StorageUIModel.class, "incoming"));
        this.config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        if (incomingModel != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("from a incoming model " + (Object)((Object)incomingModel)));
            }
            incomingModel.copyTo(this);
            return;
        }
        ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
        StorageService service = dataContext.getStorage();
        this.setLocalStorageExist(this.config.isLocalStorageExist());
        this.setStoreRemoteConfig(this.config.isStoreRemoteStorage());
        this.setBackupFile(new File(this.config.getBackupDirectory(), ((StorageUIHandler)context.getContextValue(StorageUIHandler.class)).getDefaultBackupFilename()));
        this.setDoBackup(false);
        this.setPreviousService(service);
        log.info((Object)("canMigrate ? " + this.isCanMigrate()));
        if (service != null) {
            StorageConfig previousConfig;
            if (log.isDebugEnabled()) {
                log.debug((Object)("from a previous service " + service));
            }
            if ((previousConfig = service.getConfig()) instanceof H2StorageConfig) {
                this.fromStorageConfig(this.config.toPostgresStorageConfig(this.pgConfig.getLabel()));
                this.fromStorageConfig((H2StorageConfig)previousConfig);
            } else {
                this.fromStorageConfig(this.config.toH2StorageConfig(this.pgConfig.getLabel()));
                if (!this.config.isLocalStorageExist()) {
                    this.setCreationMode(this.config.getDefaultCreationMode());
                }
                this.fromStorageConfig((PGStorageConfig)previousConfig);
            }
            this.setDumpFile(this.config.getBackupDirectory());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"no service found, using default configuration ");
        }
        this.fromStorageConfig(this.config.toH2StorageConfig(this.pgConfig.getLabel()));
        this.fromStorageConfig(this.config.toPostgresStorageConfig(this.pgConfig.getLabel()));
        this.setDbMode(this.config.getDefaultDbMode());
        this.setCreationMode(this.config.getDefaultCreationMode());
        this.setDumpFile(this.config.getBackupDirectory());
    }

    public void start() {
        super.start();
        this.firePropertyChange(DB_MODE_PROPERTY_NAME, null, this.dbMode);
        this.firePropertyChange(CREATION_MODE_PROPERTY_NAME, null, this.getCreationMode());
        this.firePropertyChange(DUMP_FILE_PROPERTY_NAME, null, this.h2Config.getDbDump());
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, null, this.backupFile);
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, null, this.doBackup);
        this.firePropertyChange(CONNEXION_STATUS_PROPERTY_NAME, null, this.pgConfig.getConnexionStatus());
        this.firePropertyChange(PREVIOUS_SERVICE_PROPERTY_NAME, null, this.previousService);
        this.firePropertyChange(LOCAL_STORAGE_EXIST_PROPERTY_NAME, null, this.localStorageExist);
        this.firePropertyChange(STORE_REMOTE_CONFIG_PROPERTY_NAME, null, this.storeRemoteConfig);
        this.firePropertyChange(REMOTE_URL_ROPERTY_NAME, null, this.getRemoteUrl());
        this.firePropertyChange(REMOTE_LOGIN_ROPERTY_NAME, null, this.getRemoteLogin());
        this.firePropertyChange(REMOTE_PASSWORD_PROPERTY_NAME, null, this.getRemotePassword());
        this.firePropertyChange(USE_SSL_PROPERTY_NAME, null, this.isUseSsl());
        this.firePropertyChange(SSL_CERTIFICAT_FILE_PROPERTY_NAME, null, this.getSslCertificatFile());
        this.firePropertyChange(CAN_MIGRATE_PROPERTY_NAME, null, this.isCanMigrate());
    }

    public void updateUniverse() {
        if (this.dbMode == null) {
            return;
        }
        ArrayList<StorageStep> universe = new ArrayList<StorageStep>();
        universe.add(StorageStep.CHOOSE_DB_MODE);
        this.h2Config.setImportConfig(null);
        boolean canBackup = this.localStorageExist;
        switch (this.dbMode) {
            case LOCAL: {
                universe.add(StorageStep.CHOOSE_CREATION_MODE);
                CreationMode creationMode = this.getCreationMode();
                if (creationMode == null) break;
                switch (creationMode) {
                    case USE_LOCAL_STORAGE: {
                        canBackup = false;
                        break;
                    }
                    case IMPORT_EXTERNAL_DUMP: {
                        universe.add(StorageStep.CONFIG);
                        break;
                    }
                    case IMPORT_REMOTE_STORAGE: {
                        this.h2Config.setImportConfig((StorageConfig)this.pgConfig);
                        universe.add(StorageStep.CONFIG);
                    }
                }
                break;
            }
            case REMOTE: {
                canBackup = false;
                universe.add(StorageStep.CONFIG);
            }
        }
        if (canBackup) {
            universe.add(StorageStep.BACKUP);
        }
        universe.add(StorageStep.CONFIRM);
        if (this.excludeSteps != null) {
            universe.removeAll(this.excludeSteps);
        }
        this.setSteps(universe.toArray(new StorageStep[universe.size()]));
    }

    public boolean validate(StorageStep s) {
        boolean validate = super.validate((WizardStep)s);
        if (validate) {
            switch (s) {
                case CHOOSE_DB_MODE: {
                    validate = this.dbMode != null;
                    break;
                }
                case CHOOSE_CREATION_MODE: {
                    validate = this.h2Config.getCreationMode() != null;
                    break;
                }
                case CONFIG: {
                    if (this.dbMode == DbMode.REMOTE) {
                        validate = this.pgConfig.isValid();
                        break;
                    }
                    validate = this.h2Config.isValid();
                    break;
                }
                case BACKUP: {
                    validate = !this.doBackup || this.backupFile != null && !this.backupFile.exists() && this.backupFile.getName().endsWith(".sql.gz");
                    break;
                }
                case CONFIRM: {
                    validate = true;
                }
            }
        }
        return validate;
    }

    public boolean isValid() {
        boolean result = false;
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case LOCAL: {
                    result = this.getCreationMode() != null && this.validate(StorageStep.CONFIG);
                    break;
                }
                case REMOTE: {
                    result = this.validate(StorageStep.CONFIG);
                }
            }
        }
        return result;
    }

    public boolean isCanMigrate() {
        boolean result = false;
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case LOCAL: {
                    result = this.h2Config.isCanMigrate();
                    break;
                }
                case REMOTE: {
                    result = this.pgConfig.isCanMigrate();
                }
            }
        }
        return result;
    }

    public String getLabel() {
        String txt = this.dbMode == DbMode.LOCAL ? this.h2Config.getLabel() : this.pgConfig.getLabel();
        return txt;
    }

    public boolean isLocalStorageExist() {
        return this.localStorageExist;
    }

    public boolean isStoreRemoteConfig() {
        return this.storeRemoteConfig;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public boolean isDoBackup() {
        return this.doBackup;
    }

    public Version getDbVersion() {
        if (this.config == null) {
            return Version.VZERO;
        }
        return this.config.getDbVersion();
    }

    public DbMode getDbMode() {
        return this.dbMode;
    }

    public StorageService<?> getPreviousService() {
        return this.previousService;
    }

    public void setDbMode(DbMode dbMode) {
        DbMode oldValue = this.dbMode;
        this.dbMode = dbMode;
        this.firePropertyChange(DB_MODE_PROPERTY_NAME, oldValue, dbMode);
        if (oldValue != dbMode) {
            this.updateUniverse();
        }
        this.validate();
    }

    public void setCanMigrate(boolean canMigrate) {
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case LOCAL: {
                    this.h2Config.setCanMigrate(canMigrate);
                    break;
                }
                case REMOTE: {
                    this.pgConfig.setCanMigrate(canMigrate);
                }
            }
        }
        this.firePropertyChange(CAN_MIGRATE_PROPERTY_NAME, null, canMigrate);
    }

    public void setLocalStorageExist(boolean localStorageExist) {
        boolean oldValue = this.localStorageExist;
        this.localStorageExist = localStorageExist;
        this.firePropertyChange(LOCAL_STORAGE_EXIST_PROPERTY_NAME, oldValue, localStorageExist);
        this.validate();
    }

    public void setStoreRemoteConfig(boolean storeRemoteConfig) {
        boolean oldValue = this.storeRemoteConfig;
        this.storeRemoteConfig = storeRemoteConfig;
        this.firePropertyChange(STORE_REMOTE_CONFIG_PROPERTY_NAME, oldValue, storeRemoteConfig);
    }

    public void setDoBackup(boolean doBackup) {
        boolean oldValue = this.doBackup;
        this.doBackup = doBackup;
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, oldValue, doBackup);
    }

    public void setBackupFile(File backupFile) {
        File oldValue = this.backupFile;
        this.backupFile = backupFile;
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, oldValue, backupFile);
        this.validate();
    }

    public void setExcludeSteps(List<StorageStep> excludeSteps) {
        this.excludeSteps = excludeSteps;
    }

    public CreationMode getCreationMode() {
        return this.h2Config.getCreationMode();
    }

    public File getDumpFile() {
        URL dbDump = this.h2Config.getDbDump();
        if (dbDump == null) {
            return new File("");
        }
        File file = new File(dbDump.getFile().replaceAll("%20", " "));
        file = new File(file.getAbsolutePath());
        return file;
    }

    public void setCreationMode(CreationMode creationMode) {
        CreationMode oldValue = this.getCreationMode();
        this.h2Config.setCreationMode(creationMode);
        this.firePropertyChange(CREATION_MODE_PROPERTY_NAME, oldValue, creationMode);
        if (oldValue != creationMode) {
            this.updateUniverse();
        }
        this.validate();
    }

    public void setDumpFile(File dumpFile) {
        try {
            File oldValue = this.getDumpFile();
            URL url = null;
            if (dumpFile != null) {
                url = dumpFile.toURI().toURL();
                log.debug((Object)("dumpFile : " + dumpFile + " (exist ? : " + dumpFile.exists() + ")"));
                log.debug((Object)("dumpFile url : " + url));
                log.debug((Object)("dumpFile file from url : " + url.getFile().replaceAll("%20", " ") + " (exist ? : " + new File(url.getFile().replaceAll("%20", " ")).exists() + ")"));
            }
            this.h2Config.setDbDump(dumpFile == null ? null : url);
            this.firePropertyChange(DUMP_FILE_PROPERTY_NAME, oldValue, dumpFile);
            this.validate();
        }
        catch (MalformedURLException ex) {
            log.warn((Object)ex);
        }
    }

    public String getRemoteLogin() {
        return this.pgConfig.getLogin();
    }

    public char[] getRemotePassword() {
        return this.pgConfig.getPassword();
    }

    public String getRemoteUrl() {
        return this.pgConfig.getUrl();
    }

    public boolean isUseSsl() {
        return this.pgConfig.isUseSsl();
    }

    public File getSslCertificatFile() {
        return this.pgConfig.getSslCertificatFile();
    }

    public ConnexionStatus getConnexionStatus() {
        return this.pgConfig.getConnexionStatus();
    }

    public void setPreviousService(StorageService<?> previousService) {
        this.previousService = previousService;
    }

    public H2StorageConfig getH2Config() {
        return this.h2Config;
    }

    public PGStorageConfig getPgConfig() {
        return this.pgConfig;
    }

    public void setRemoteLogin(String remoteLogin) {
        String oldValue = this.getRemoteLogin();
        this.pgConfig.setLogin(remoteLogin);
        this.firePgConfigChanged(REMOTE_LOGIN_ROPERTY_NAME, oldValue, remoteLogin);
    }

    public void setRemotePassword(char[] remotePassword) {
        char[] oldValue = this.getRemotePassword();
        this.pgConfig.setPassword(remotePassword);
        this.firePgConfigChanged(REMOTE_PASSWORD_PROPERTY_NAME, oldValue, remotePassword);
    }

    public void setRemoteUrl(String remoteUrl) {
        String oldValue = this.getRemoteUrl();
        this.pgConfig.setUrl(remoteUrl);
        this.firePgConfigChanged(REMOTE_URL_ROPERTY_NAME, oldValue, remoteUrl);
    }

    public void setUseSsl(boolean useSsl) {
        boolean oldValue = this.pgConfig.isUseSsl();
        this.pgConfig.setUseSsl(useSsl);
        this.firePgConfigChanged(USE_SSL_PROPERTY_NAME, oldValue, useSsl);
    }

    public void setSslCertificatFile(File sslCertificatFile) {
        File oldValue = this.getSslCertificatFile();
        this.pgConfig.setSslCertificatFile(sslCertificatFile);
        this.firePgConfigChanged(SSL_CERTIFICAT_FILE_PROPERTY_NAME, oldValue, sslCertificatFile);
    }

    public void fromStorageConfig(H2StorageConfig config) {
        this.setDbMode(DbMode.LOCAL);
        config.copyTo((StorageConfig)this.h2Config);
    }

    public void fromStorageConfig(PGStorageConfig config) {
        this.setDbMode(DbMode.REMOTE);
        config.copyTo(this.pgConfig);
    }

    public H2StorageConfig toH2StorageConfig(String label) {
        H2StorageConfig result = (H2StorageConfig)this.h2Config.clone();
        result.setShortLabel(label);
        if (this.getDbMode() == DbMode.LOCAL) {
            CreationMode m = result.getCreationMode();
            switch (m) {
                case USE_LOCAL_STORAGE: 
                case IMPORT_EXTERNAL_DUMP: 
                case EMPTY: {
                    break;
                }
                case IMPORT_INTERNAL_DUMP: {
                    try {
                        result.setDbDump(this.config.getInitialDbDump().toURI().toURL());
                        break;
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalArgumentException("can not build url for initialDbDump for reason " + ex.getMessage(), ex);
                    }
                }
                case IMPORT_LOCAL_STORAGE: {
                    result.getH2ImportConfig().setShortLabel(I18n.n_((String)"observe.storage.label.import.local"));
                    break;
                }
                case IMPORT_REMOTE_STORAGE: {
                    result.getPGImportConfig().setShortLabel(I18n.n_((String)"observe.storage.label.import.remote"));
                }
            }
        }
        return result;
    }

    public PGStorageConfig toPostgresStorageConfig(String label) {
        PGStorageConfig result = (PGStorageConfig)this.pgConfig.clone();
        result.setShortLabel(label);
        return result;
    }

    protected void copyTo(StorageUIModel dst) {
        dst.setLocalStorageExist(this.isLocalStorageExist());
        dst.setDbMode(this.getDbMode());
        dst.setBackupFile(this.getBackupFile());
        dst.setDoBackup(this.isDoBackup());
        dst.setStoreRemoteConfig(this.isStoreRemoteConfig());
        dst.setPreviousService(this.getPreviousService());
        this.h2Config.copyTo((StorageConfig)dst.h2Config);
        this.pgConfig.copyTo(dst.pgConfig);
    }

    protected void firePgConfigChanged(String propertyName, Object oldValue, Object newValue) {
        if (!CONNEXION_STATUS_PROPERTY_NAME.equals(propertyName)) {
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
        this.firePropertyChange(CONNEXION_STATUS_PROPERTY_NAME, null, this.pgConfig.getConnexionStatus());
        this.validate();
    }
}

