/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.storage.CreationMode;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceAdapter;
import fr.ird.observe.storage.StorageServiceEvent;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.StorageServiceListener;
import fr.ird.observe.storage.impl.H2StorageConfig;
import fr.ird.observe.storage.impl.H2StorageService;
import fr.ird.observe.storage.impl.PGStorageConfig;
import fr.ird.observe.storage.impl.PGStorageService;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIModel;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.wizard.WizardUI;
import jaxx.runtime.swing.wizard.WizardUILancher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

@DefaultApplicationContext.AutoLoad
public class StorageUIHandler {
    private static final Log log = LogFactory.getLog(StorageUIHandler.class);

    public StorageService<?> newServiceFromModel(JAXXContext context, StorageUIModel model, boolean isMain, String localLabel, String remoteLabel) throws IOException {
        PGStorageService mainStorage = null;
        switch (model.getDbMode()) {
            case LOCAL: {
                H2StorageConfig h2Config = model.toH2StorageConfig(localLabel);
                H2StorageService h2Service = StorageServiceFactory.newService((H2StorageConfig)h2Config);
                h2Service.addStorageServiceListener((StorageServiceListener)new StorageServiceAdapter(){

                    public void onOpened(StorageServiceEvent event) {
                        H2StorageService s = (H2StorageService)event.getSource();
                        ObserveContext context = ObserveContext.get();
                        ((ObserveConfig)((Object)context.getContextValue(ObserveConfig.class))).setLocalStorageExist(true);
                        ((H2StorageConfig)s.getConfig()).setCreationMode(CreationMode.USE_LOCAL_STORAGE);
                    }
                });
                mainStorage = h2Service;
                break;
            }
            case REMOTE: {
                PGStorageService pgservice;
                PGStorageConfig pgConfig = model.toPostgresStorageConfig(remoteLabel);
                mainStorage = pgservice = StorageServiceFactory.newService((PGStorageConfig)pgConfig);
            }
        }
        if (isMain) {
            ObserveContext.get().prepareMainStorage((StorageService<?>)mainStorage);
        }
        return mainStorage;
    }

    public void doChangeStorage(JAXXContext context, StorageUIModel model) {
        block21: {
            File f;
            ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
            boolean destroyLocalBase = config.isLocalStorageExist() && model.getDbMode() == DbMode.LOCAL && model.getCreationMode() != CreationMode.USE_LOCAL_STORAGE;
            log.debug((Object)(">>> should destroy local db ? " + destroyLocalBase));
            ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
            StorageService<?> mainStorage = dataContext.getStorage();
            H2StorageService localStorage = null;
            if (mainStorage instanceof H2StorageService) {
                localStorage = (H2StorageService)mainStorage;
            }
            if ((destroyLocalBase || model.isDoBackup()) && localStorage == null) {
                try {
                    H2StorageConfig localConfig = config.toH2StorageConfig(I18n.n_((String)"observe.storage.label.local"));
                    localStorage = StorageServiceFactory.newService((H2StorageConfig)localConfig);
                    localStorage.doOpen();
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
            }
            if (model.isDoBackup()) {
                f = model.getBackupFile();
                log.debug((Object)(">>> do backup with " + localStorage + " in " + f));
                try {
                    this.backupLocalDatabase((StorageService<?>)localStorage, f);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
            }
            if (destroyLocalBase) {
                log.debug((Object)(">>> destroy local db " + localStorage));
                try {
                    localStorage.doClose(true);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
            }
            if (mainStorage != null && mainStorage.isOpen()) {
                try {
                    log.debug((Object)(">>> close main storage " + mainStorage));
                    mainStorage.doClose(false);
                }
                catch (StorageServiceException ex) {
                    ErrorDialogUI.showError((Exception)((Object)ex));
                }
            }
            mainStorage = null;
            if (localStorage != null && localStorage.isOpen()) {
                try {
                    log.debug((Object)(">>> close local storage " + localStorage));
                    localStorage.doClose(false);
                }
                catch (StorageServiceException ex) {
                    ErrorDialogUI.showError((Exception)((Object)ex));
                }
            }
            localStorage = null;
            try {
                mainStorage = this.newServiceFromModel(context, model, true, "observe.storage.label.local", "observe.storage.label.remote");
                mainStorage.doOpen();
                log.info((Object)(">>> main storage opened " + mainStorage.getLabel()));
                if (model.getDbMode() != DbMode.LOCAL || model.getCreationMode() != CreationMode.IMPORT_REMOTE_STORAGE) break block21;
                f = config.getInitialDbDump();
                if (f.exists() && !f.delete()) {
                    throw new IllegalStateException("could not delete " + f);
                }
                log.info((Object)(">>> create initial dump with " + localStorage + " in " + f));
                try {
                    this.backupLocalDatabase(mainStorage, f);
                    config.setInitialDumpExist(true);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
            }
            catch (Exception ex) {
                ErrorDialogUI.showError((Exception)ex);
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void storeRemoteConfig(JAXXContext context, StorageUIModel model) {
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        PGStorageConfig remoteConfig = model.toPostgresStorageConfig("");
        config.fromStorageConfig(remoteConfig);
    }

    public String getDefaultBackupFilename() {
        return String.format("obstuna-local-%1$tF--%1$tk-%1$tM-%1$tS.sql.gz", new Date());
    }

    public void backupLocalDatabase(StorageService<?> service, File dst) {
        if (dst == null) {
            throw new IllegalArgumentException("file where to backup can not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)dst);
        }
        try {
            service.storeDB(dst);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
    }

    public void obtainRemoteConnexion(JAXXContext rootContext, Window mainUI, final StorageUIModel model) {
        if (mainUI == null) {
            mainUI = (Window)ObserveContext.MAIN_UI_ENTRY_DEF.getContextValue(rootContext);
        }
        WizardUILancher<StorageStep, StorageUIModel, StorageUI> launcher = new WizardUILancher<StorageStep, StorageUIModel, StorageUI>(rootContext, mainUI, StorageUI.class, StorageUIModel.class, model){

            protected void init(StorageUI ui) {
                StorageUIModel model2 = ui.getModel();
                model2.setDbMode(DbMode.REMOTE);
                model2.setExcludeSteps(Arrays.asList(StorageStep.CHOOSE_DB_MODE, StorageStep.BACKUP, StorageStep.CONFIRM));
                model2.setSteps(new StorageStep[]{StorageStep.CONFIG});
                ui.setTitle(I18n._((String)"observe.title.connect.remoteDB"));
            }

            protected void doCancel(StorageUI ui) {
                super.doCancel((WizardUI)ui);
                log.info((Object)ui.getName());
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                ui.getModel().copyTo(model);
                model.validate();
            }
        };
        launcher.start();
    }

    public void obtainLocalConnexion(JAXXContext rootContext, Window mainUI, final StorageUIModel model) {
        if (mainUI == null) {
            mainUI = (Window)ObserveContext.MAIN_UI_ENTRY_DEF.getContextValue(rootContext);
        }
        WizardUILancher<StorageStep, StorageUIModel, StorageUI> launcher = new WizardUILancher<StorageStep, StorageUIModel, StorageUI>(rootContext, mainUI, StorageUI.class, StorageUIModel.class, model){

            protected void init(StorageUI ui) {
                StorageUIModel model2 = ui.getModel();
                model2.setExcludeSteps(Arrays.asList(StorageStep.CHOOSE_DB_MODE, StorageStep.BACKUP, StorageStep.CONFIRM));
                model2.updateUniverse();
                ui.setTitle(I18n._((String)"observe.title.connect.localDB"));
            }

            protected void doCancel(StorageUI ui) {
                super.doCancel((WizardUI)ui);
                log.info((Object)ui.getName());
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                ui.getModel().copyTo(model);
                model.validate();
            }
        };
        launcher.start();
    }

    public boolean testRemote(JAXXContext context, StorageUIModel model) {
        boolean result = false;
        result = model.getPgConfig().canConnect();
        if (log.isDebugEnabled()) {
            log.debug((Object)("result : " + result));
        }
        model.firePgConfigChanged("connexionStatus", null, null);
        return result;
    }

    public String computeReport(StorageUIModel model, StorageStep step) {
        StringBuilder sb = new StringBuilder();
        DbMode dbMode = model.getDbMode();
        CreationMode creationMode = model.getCreationMode();
        if (dbMode == null || creationMode == null) {
            return "";
        }
        String tmpStr = I18n._((String)dbMode.getLabel());
        sb.append(I18n._((String)"observe.storage.report.selected.dbMode", (Object[])new Object[]{tmpStr}));
        sb.append("\n\n");
        if (dbMode == DbMode.LOCAL) {
            tmpStr = I18n._((String)creationMode.getLabel());
            sb.append(I18n._((String)"observe.storage.report.selected.creationMode", (Object[])new Object[]{tmpStr}));
            sb.append("\n\n");
            switch (creationMode) {
                case IMPORT_EXTERNAL_DUMP: {
                    sb.append(I18n._((String)"observe.storage.report.config") + "\n");
                    tmpStr = model.getDumpFile().getAbsolutePath();
                    sb.append(I18n._((String)"observe.storage.report.selected.dumpFile", (Object[])new Object[]{tmpStr}));
                    break;
                }
                case IMPORT_REMOTE_STORAGE: {
                    sb.append(I18n._((String)"observe.storage.report.config") + "\n");
                    sb.append(I18n._((String)"observe.storage.report.selected.importRemoteStorage", (Object[])new Object[]{model.getPgConfig().toString()}));
                    break;
                }
                default: {
                    sb.append(I18n._((String)"observe.storage.report.no.required.config"));
                    break;
                }
            }
        } else {
            sb.append(I18n._((String)"observe.storage.report.config") + "\n");
            sb.append(I18n._((String)"observe.storage.report.selected.remoteStorage", (Object[])new Object[]{model.getPgConfig().toString()}));
        }
        if (model.isDoBackup()) {
            tmpStr = model.getBackupFile().getAbsolutePath();
            sb.append("\n\n");
            sb.append(I18n._((String)"observe.storage.report.selected.backup", (Object[])new Object[]{tmpStr}));
        }
        if (model.isCanMigrate()) {
            sb.append("\n\n");
            sb.append(I18n._((String)"observe.storage.report.can.migrate", (Object[])new Object[]{model.getDbVersion()}));
        }
        return sb.toString();
    }
}

