/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.RouteImpl;
import fr.ird.observe.entities.referentiel.ActiviteBateau;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.ObserveTreeModelBuilder;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ActiviteUI;
import fr.ird.observe.ui.content.data.RouteUI;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Creator;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.EntityLoador;

public class RouteHandler
extends ObserveContentHandler<Maree, Route, RouteUI> {
    private static Log log = LogFactory.getLog(RouteHandler.class);

    public RouteHandler() {
        super(new Creator<Maree, Route>(){

            public Route create(Maree parentBean, Route bean) throws TopiaException {
                Route lastRoute = parentBean.getLastRoute();
                if (lastRoute == null) {
                    bean.setJourObservation(parentBean.getDateDebut());
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(lastRoute.getJourObservation());
                    calendar.add(6, 1);
                    Date date = DBHelper.getDay((Date)calendar.getTime());
                    bean.setJourObservation(date);
                    bean.setLochMatin(lastRoute.getLochSoir());
                }
                return bean;
            }
        }, new Creator<Maree, Route>(){

            public Route create(Maree parentBean, Route bean) throws TopiaException {
                TopiaContext ctxt = parentBean.getTopiaContext();
                Route beanToSave = (Route)ObserveDAOHelper.getRouteDAO((TopiaContext)ctxt).create(new Object[0]);
                bean.setTopiaId(beanToSave.getTopiaId());
                parentBean.addRoute(beanToSave);
                return beanToSave;
            }
        }, new Deletor<Maree, Route>(){

            public void delete(Maree parentBean, Route bean) {
                parentBean.removeRoute(bean);
            }
        }, EntityLoador.newEntityLoador(Route.class, (String[])new String[]{"jourObservation", "lochMatin", "lochSoir", "niveauVerification", "activite", "open", "commentaire"}));
    }

    @Override
    public void openOpenable(RouteUI ui) {
        ui.getEditBean().setOpen(true);
        try {
            this.getStorageService((JAXXContext)ui).update((TopiaEntity)this.getData((JAXXContext)ui, Route.class), (TopiaEntity)ui.getEditBean(), this.loador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        this.restartEditUI(ui);
    }

    @Override
    public void closeOpenable(RouteUI ui) {
        boolean mustAddFinVeille;
        RouteImpl route = ui.getEditBean();
        List activites = route.getActivite();
        if (activites == null || activites.isEmpty()) {
            mustAddFinVeille = true;
        } else {
            DBHelper.sortActivites((List)activites);
            Activite lastactivite = (Activite)activites.get(activites.size() - 1);
            boolean bl = mustAddFinVeille = lastactivite.getActiviteBateau().getCode() != 16;
        }
        if (mustAddFinVeille) {
            int reponse = UIHelper.askUser((Component)((Object)ui), I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.need.fin.veille.activite"), 2, new Object[]{I18n._((String)"observe.choice.create.fin.veille.activite"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 1: {
                    break;
                }
                case 0: {
                    Route bean = this.getData((JAXXContext)ui, Route.class);
                    if (bean.getOpenActivite() != null) {
                        Activite a = bean.getOpenActivite();
                        a.setOpen(false);
                        try {
                            this.getStorageService((JAXXContext)ui).update((TopiaEntity)a);
                        }
                        catch (StorageServiceException ex) {
                            ErrorDialogUI.showError((Exception)((Object)ex));
                        }
                    }
                    NavigationTreeNode parentNode = this.getSelectedNode(ui);
                    parentNode = parentNode.getChild("activite");
                    NavigationTreeNode node = this.getTreeBuilder((JAXXContext)ui).addActivite(parentNode, null);
                    this.repaintNode((JAXXContext)ui, parentNode, true);
                    this.selectNode((JAXXContext)ui, node);
                    ActiviteUI selectedUI = (ActiviteUI)ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.getContextValue((JAXXContext)ui);
                    ActiviteBateau finVeilleActivite = null;
                    for (ActiviteBateau o : selectedUI.getActiviteBateau().getData()) {
                        ActiviteBateau a = o;
                        if (a.getCode() != 16) continue;
                        finVeilleActivite = a;
                        break;
                    }
                    selectedUI.getEditBean().setActiviteBateau(finVeilleActivite);
                }
            }
            return;
        }
        Route bean = this.getData((JAXXContext)ui, Route.class);
        try {
            this.closeOpenable((Openable)bean);
            bean = (Route)this.getStorageService((JAXXContext)ui).update((TopiaEntity)bean);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        this.closeOpenable(ui, (Openable)bean, I18n._((String)"observe.message.route.not.open"));
    }

    @Override
    public void openUI(RouteUI context) throws Exception {
        super.openUI(context);
        Maree maree = this.getData((JAXXContext)context, Maree.class);
        Route bean = this.getData((JAXXContext)context, Route.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        if (bean == null) {
            this.getStorageService((JAXXContext)context).preCreate((TopiaEntity)maree, (TopiaEntity)context.getEditBean(), this.loador, this.preCreator);
        } else {
            this.loador.load((Object)bean, (Object)context.getEditBean(), true);
            if (!context.getEditBean().isActiviteEmpty()) {
                DBHelper.sortActivites((List)context.getEditBean().getActivite());
            }
        }
        context.setMode(mode);
        if (mode != ObserveContentMode.READ) {
            context.startEdit(bean);
        }
    }

    @Override
    public void startEditUI(RouteUI context, Route o, Route editBean, String ... binding) {
        boolean create = context.getMode() == ObserveContentMode.CREATE;
        context.getValidator().setContextName(create ? "n1-create" : "n1-update");
        if (create) {
            this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.creating.route"));
        } else {
            this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.updating.route"));
        }
        super.startEditUI(context, o, editBean, "jourObservation.date", "lochMatin.text", "niveauVerification.text", "lochSoir.text", "commentaire.text", "close.enabled");
        context.setModified(create);
    }

    @Override
    public void saveUI(RouteUI context, boolean refresh) {
        Maree maree = this.getData((JAXXContext)context, Maree.class);
        Route beanToSave = this.getData((JAXXContext)context, Route.class);
        RouteImpl bean = context.getEditBean();
        boolean create = bean.getTopiaId() == null;
        List oldRoutes = maree.getRoute();
        if (oldRoutes != null && !oldRoutes.isEmpty()) {
            DBHelper.sortRoutes((List)oldRoutes);
        }
        int position = 0;
        try {
            Date date = DBHelper.getDay((Date)bean.getJourObservation());
            bean.setJourObservation(date);
            if (oldRoutes != null && !oldRoutes.isEmpty()) {
                for (Route r : oldRoutes) {
                    if (r.getTopiaId().equals(bean.getTopiaId())) continue;
                    if (date.before(r.getJourObservation())) break;
                    ++position;
                }
            }
            if (create) {
                bean.setOpen(true);
                this.getStorageService((JAXXContext)context).create((TopiaEntity)maree, (TopiaEntity)bean, this.loador, this.creator);
            } else {
                this.getStorageService((JAXXContext)context).update((TopiaEntity)beanToSave, (TopiaEntity)bean, this.loador);
            }
            Date dateFin = DBHelper.getMareeDateFin((Maree)maree);
            log.debug((Object)("maree dateFin : " + dateFin));
            maree.setDateFin(dateFin);
            this.getStorageService((JAXXContext)context).update((TopiaEntity)maree);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        BeanValidatorUtil.setValidatorChanged((JAXXObject)context, (boolean)false, (String[])new String[0]);
        NavigationTreeNode node = this.getSelectedNode(context);
        NavigationTreeNode parentNode = node.getParent();
        int oldPosition = create ? parentNode.getChildCount() : parentNode.getIndex((TreeNode)node);
        ObserveTreeModelBuilder modelBuilder = this.getTreeBuilder((JAXXContext)context);
        if (create) {
            context.setMode(ObserveContentMode.UPDATE);
            modelBuilder.removeChildNode(node);
            node = modelBuilder.addRoute(parentNode, (Route)bean);
            this.stopEditUI(context);
            if (oldPosition != position) {
                modelBuilder.moveNode(parentNode, node, position);
            }
            this.selectNode((JAXXContext)context, node);
        } else if (oldPosition != position) {
            modelBuilder.moveNode(parentNode, node, position);
            this.selectNode((JAXXContext)context, node);
        } else {
            this.repaintNode((JAXXContext)context, node);
        }
    }

    @Override
    public void deleteUI(RouteUI context) {
        Route bean = this.getData((JAXXContext)context, Route.class);
        if (!UIHelper.confirmForEntityDelete(context, Route.class, bean)) {
            return;
        }
        try {
            Maree maree = this.getData((JAXXContext)context, Maree.class);
            this.getStorageService((JAXXContext)context).delete((TopiaEntity)maree, (TopiaEntity)bean, this.deletator);
            Date dateFin = DBHelper.getMareeDateFin((Maree)maree);
            maree.setDateFin(dateFin);
            this.getStorageService((JAXXContext)context).update((TopiaEntity)maree);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        context.stopEdit();
        NavigationTreeNode node = this.getSelectedNode(context);
        NavigationTreeNode parentNode = this.getTreeBuilder((JAXXContext)context).removeChildNode(node);
        this.selectNode((JAXXContext)context, parentNode);
    }

    @Override
    protected ObserveContentMode getObserveContentMode(RouteUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            boolean create;
            Maree maree = this.getData((JAXXContext)context, Maree.class);
            Route bean = this.getData((JAXXContext)context, Route.class);
            boolean bl = create = bean == null;
            if (create) {
                mode = ObserveContentMode.CREATE;
                context.removeContextValue(Route.class);
            } else {
                mode = bean.isOpen() ? ObserveContentMode.UPDATE : ObserveContentMode.READ;
            }
            if (!create && !bean.isOpen()) {
                if (!maree.isOpen()) {
                    this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
                } else {
                    this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.route.not.open"));
                }
            }
        }
        return mode;
    }
}

