/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureThon;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.TailleThon;
import fr.ird.observe.entities.referentiel.CategoriePoids;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.entities.referentiel.RaisonRejet;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.ObserveContentTableHandler;
import fr.ird.observe.ui.content.ObserveContentTableMeta;
import fr.ird.observe.ui.content.ObserveContentTableModel;
import fr.ird.observe.ui.content.ObserveContentTableUI;
import fr.ird.observe.ui.content.data.RejetThonUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.editor.NumberEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityListUpdator;
import org.nuiton.topia.persistence.util.EntityLoador;

public class RejetThonHandler
extends ObserveContentTableHandler<Calee, CaptureThon, RejetThonUI> {
    private static Log log = LogFactory.getLog(RejetThonHandler.class);
    JAXXContextEntryDef<List<EspeceThon>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"all-especes");
    JAXXContextEntryDef<List<CategoriePoids>> ALL_CATEGORIES_ENTRY = UIHelper.newListContextEntryDef((String)"all-categories");
    JAXXContextEntryDef<List<RaisonRejet>> ALL_RAISONS_REJET_ENTRY = UIHelper.newListContextEntryDef((String)"all-raisonRejets");

    public RejetThonHandler() {
        super("rejetThon", Calee.class, CaptureThon.class, EntityLoador.newEntityLoador(Calee.class, (String[])new String[]{"captureThon", "rejetThon", "echantillonThon"}), EntityLoador.newEntityLoador(CaptureThon.class, (String[])new String[]{"calee", "categoriePoids", "poids", "raisonRejet", "rejete", "surLePont", "commentaire"}), EntityListUpdator.newEntityListUpdator(Calee.class, CaptureThon.class, (String)"captureThon"));
    }

    @Override
    public ObserveContentTableModel<Calee, CaptureThon> newTableModel(ObserveContentTableUI<Calee, CaptureThon> context) {
        ArrayList metas = new ArrayList();
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "espece", true));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "categoriePoids", true));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "raisonRejet", true));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "poids", false));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "surLePont", false));
        metas.add(new ObserveContentTableMeta<CaptureThon>(CaptureThon.class, "commentaire", false));
        return new ObserveContentTableModel<Calee, CaptureThon>(context, metas);
    }

    @Override
    public void initUI(final RejetThonUI context) throws Exception {
        super.initUI(context);
        context.getEspece().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObserveContentTableModel model = RejetThonHandler.this.getTableModel(context);
                CaptureThon bean = (CaptureThon)model.getRowBean();
                if (bean.getTopiaId() == null) {
                    EspeceThon espece = (EspeceThon)evt.getNewValue();
                    RejetThonHandler.this.onEspeceChanged(context, model, bean, espece);
                }
            }
        });
        context.getCategoriePoids().addPropertyChangeListener("selectedItem", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObserveContentTableModel model = RejetThonHandler.this.getTableModel(context);
                CaptureThon bean = (CaptureThon)model.getRowBean();
                if (bean.getTopiaId() == null) {
                    CategoriePoids categoriePoids = (CategoriePoids)evt.getNewValue();
                    RejetThonHandler.this.onCategorieChanged(context, model, bean, categoriePoids);
                }
            }
        });
    }

    @Override
    protected Calee loadEditBean(RejetThonUI ui, ObserveContentMode mode) {
        ObserveDataContext dataContext = this.getDataContext((JAXXContext)ui);
        HashSet<EspeceThon> availableEspeces = new HashSet<EspeceThon>();
        List categorieList = dataContext.getEntityList(CategoriePoids.class);
        for (CategoriePoids c : categorieList) {
            availableEspeces.add(c.getEspece());
        }
        ArrayList especeList = new ArrayList(availableEspeces);
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)ui, especeList);
        this.ALL_CATEGORIES_ENTRY.setContextValue((JAXXContext)ui, (Object)categorieList);
        this.ALL_RAISONS_REJET_ENTRY.setContextValue((JAXXContext)ui, (Object)dataContext.getEntityList(RaisonRejet.class));
        return (Calee)super.loadEditBean(ui, mode);
    }

    @Override
    protected Collection<CaptureThon> loadChilds(RejetThonUI ui, Calee bean) {
        Collection childs = this.getChildsUpdator().getChilds((TopiaEntity)bean);
        ArrayList<CaptureThon> data = new ArrayList<CaptureThon>();
        if (childs != null && !childs.isEmpty()) {
            for (CaptureThon c : childs) {
                if (!c.getRejete()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("captureThon " + c.getEspece().getLibelle() + " non retenu."));
                    continue;
                }
                try {
                    CaptureThon c2 = (CaptureThon)this.newTableEditBean();
                    this.getChildLoador().load((TopiaEntity)c, (TopiaEntity)c2, true);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    @Override
    protected boolean prepareSave(RejetThonUI context, Calee toSave, Calee editBean, List<CaptureThon> objets) {
        EchantillonThon echantillon = (EchantillonThon)editBean.getEchantillonThon().get(0);
        HashSet<EspeceThon> especesUsed = new HashSet<EspeceThon>();
        for (CaptureThon c : objets) {
            if (!c.getSurLePont()) continue;
            especesUsed.add(c.getEspece());
        }
        HashSet<TailleThon> tailleToDelete = new HashSet<TailleThon>();
        HashSet<EspeceThon> especesToDelete = new HashSet<EspeceThon>();
        if (echantillon != null && !echantillon.isTailleThonEmpty()) {
            for (TailleThon t : echantillon.getTailleThon()) {
                EspeceThon e = t.getEspece();
                if (especesUsed.contains(e)) continue;
                tailleToDelete.add(t);
                especesToDelete.add(e);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("remove obsolote echantillon " + t + " for espece " + e));
            }
        }
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            Decorator<EspeceThon> decorator = ObserveContext.getDecorator(EspeceThon.class);
            Decorator<TailleThon> decorator2 = ObserveContext.getDecorator(TailleThon.class);
            for (EspeceThon e : especesToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append("\n");
            }
            for (TailleThon t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append("\n");
            }
            int reponse = UIHelper.askUser(I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.table.rejetThon.will.delete.tailleThon", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n._((String)"observe.choice.continue"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            echantillon.getTailleThon().removeAll(tailleToDelete);
        }
        editBean.setRejetThon(!objets.isEmpty());
        for (CaptureThon capture : objets) {
            capture.setRejete(true);
            capture.setCalee(toSave);
        }
        if (!toSave.isCaptureThonEmpty()) {
            for (CaptureThon captureThon : toSave.getCaptureThon()) {
                if (captureThon.getRejete()) continue;
                objets.add(captureThon);
            }
        }
        return true;
    }

    @Override
    protected void onSelectedRowChanged(RejetThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, int editingRow, CaptureThon bean, boolean create) {
        NumberEditor requestFocus;
        CategoriePoids beanCategoriePoids = bean.getCategoriePoids();
        EspeceThon beanEspece = beanCategoriePoids == null ? null : beanCategoriePoids.getEspece();
        RaisonRejet beanRaisonRejet = bean.getRaisonRejet();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected categoriePoid " + beanCategoriePoids));
            log.debug((Object)("selected espece " + beanEspece));
            log.debug((Object)("selected raisonRejet " + beanRaisonRejet));
        }
        if (create) {
            if (model.isCreate()) {
                bean.setSurLePont(true);
            }
            List<EspeceThon> availableEspeces = this.buildEspeceList(context, model, beanEspece, beanCategoriePoids);
            context.getEspece().setData(availableEspeces);
            context.getEspece().setSelectedItem(null);
            if (!model.isCreate()) {
                context.getEspece().setSelectedItem((Object)beanEspece);
                context.getCategoriePoids().setSelectedItem((Object)beanCategoriePoids);
                context.getRaisonRejet().setSelectedItem((Object)beanRaisonRejet);
            }
            requestFocus = context.getEspece();
        } else {
            context.getEspece().setSelectedItem((Object)beanEspece);
            context.getCategoriePoids().setData(Arrays.asList(beanCategoriePoids));
            context.getCategoriePoids().setSelectedItem((Object)beanCategoriePoids);
            context.getRaisonRejet().setData(Arrays.asList(beanRaisonRejet));
            context.getRaisonRejet().setSelectedItem((Object)beanRaisonRejet);
            requestFocus = context.getPoids();
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(RejetThonUI context, DefaultTableCellRenderer renderer) {
        JTable table = context.getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)20);
        UIHelper.fixTableColumnWidth((JTable)table, (int)5, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.rejetThon.especeThon"), I18n.n_((String)"observe.table.rejetThon.especeThon.tip"), I18n.n_((String)"observe.table.rejetThon.categoriePoids"), I18n.n_((String)"observe.table.rejetThon.categoriePoids.tip"), I18n.n_((String)"observe.table.rejetThon.raisonRejet"), I18n.n_((String)"observe.table.rejetThon.raisonRejet.tip"), I18n.n_((String)"observe.table.rejetThon.poids"), I18n.n_((String)"observe.table.rejetThon.poids.tip"), I18n.n_((String)"observe.table.rejetThon.surLePont"), I18n.n_((String)"observe.table.rejetThon.surLePont.tip"), I18n.n_((String)"observe.table.rejetThon.commentaire"), I18n.n_((String)"observe.table.rejetThon.commentaire.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, CategoriePoids.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, RaisonRejet.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((DefaultTableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    protected void onEspeceChanged(RejetThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, CaptureThon bean, EspeceThon espece) {
        List<CategoriePoids> data;
        CategoriePoids categoriePoids = null;
        if (espece == null) {
            data = Collections.EMPTY_LIST;
        } else {
            List<CategoriePoids> availableCategories;
            data = availableCategories = this.buildCategoriePoidsList(context, model, espece);
            categoriePoids = bean.getCategoriePoids();
            if (categoriePoids != null && !availableCategories.contains(categoriePoids)) {
                categoriePoids = null;
            }
        }
        context.getCategoriePoids().setData((List)data);
        context.getCategoriePoids().setSelectedItem(categoriePoids);
    }

    protected void onCategorieChanged(RejetThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, CaptureThon bean, CategoriePoids categoriePoids) {
        List<RaisonRejet> data;
        RaisonRejet raisonRejet = null;
        if (categoriePoids == null) {
            data = Collections.EMPTY_LIST;
        } else {
            List<RaisonRejet> raisonRejetList = this.buildRaisonRejetList(context, model, categoriePoids);
            if (log.isDebugEnabled()) {
                log.debug((Object)("new raisonRejet list " + raisonRejetList));
            }
            data = raisonRejetList;
            raisonRejet = bean.getRaisonRejet();
            if (raisonRejet != null && !raisonRejetList.contains(raisonRejet)) {
                raisonRejet = null;
            }
        }
        context.getRaisonRejet().setData((List)data);
        context.getRaisonRejet().setSelectedItem(raisonRejet);
    }

    protected Set<CategoriePoids> getCategoriePoidsUsed(ObserveContentTableModel<Calee, CaptureThon> model) {
        List list = model.getColumnValues(1);
        HashSet<CategoriePoids> set = new HashSet<CategoriePoids>(list);
        list.clear();
        return set;
    }

    protected Set<RaisonRejet> getRaisonRejetUsed(ObserveContentTableModel<Calee, CaptureThon> model, CategoriePoids categoriePoids) {
        HashSet<RaisonRejet> set = new HashSet<RaisonRejet>();
        if (categoriePoids != null) {
            for (int i = 0; i < model.getRowCount(); ++i) {
                CaptureThon c = model.getValueAt(i);
                if (c == null || !categoriePoids.equals(c.getCategoriePoids()) || c.getRaisonRejet() == null) continue;
                set.add(c.getRaisonRejet());
            }
        }
        return set;
    }

    protected List<EspeceThon> buildEspeceList(RejetThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, EspeceThon espece, CategoriePoids categoriePoids) {
        List<CategoriePoids> categoriePoidsList = this.getAllCategories((JAXXContext)context);
        this.removeFullyUsedCategories(context, model, categoriePoidsList);
        if (categoriePoids != null) {
            categoriePoidsList.add(categoriePoids);
        }
        HashSet<EspeceThon> usedEspeces = new HashSet<EspeceThon>();
        for (CategoriePoids cat : categoriePoidsList) {
            usedEspeces.add(cat.getEspece());
        }
        ArrayList<EspeceThon> result = new ArrayList<EspeceThon>(usedEspeces);
        categoriePoidsList.clear();
        usedEspeces.clear();
        return result;
    }

    protected List<CategoriePoids> buildCategoriePoidsList(RejetThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, EspeceThon espece) {
        List<CategoriePoids> categoriePoidsList = this.getAllCategories((JAXXContext)context);
        Iterator<CategoriePoids> it = categoriePoidsList.iterator();
        while (it.hasNext()) {
            CategoriePoids poidse = it.next();
            if (espece.equals(poidse.getEspece())) continue;
            it.remove();
        }
        this.removeFullyUsedCategories(context, model, categoriePoidsList);
        return categoriePoidsList;
    }

    protected List<RaisonRejet> buildRaisonRejetList(RejetThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, CategoriePoids categoriePoids) {
        ArrayList<RaisonRejet> raisonRejetList = new ArrayList<RaisonRejet>((Collection)this.ALL_RAISONS_REJET_ENTRY.getContextValue((JAXXContext)context));
        for (int i = 0; i < model.getRowCount(); ++i) {
            CaptureThon c = model.getValueAt(i);
            if (c == null || c.getRaisonRejet() == null || !categoriePoids.equals(c.getCategoriePoids())) continue;
            raisonRejetList.remove(c.getRaisonRejet());
        }
        return raisonRejetList;
    }

    protected List<CategoriePoids> getAllCategories(JAXXContext context) {
        ArrayList<CategoriePoids> list = new ArrayList<CategoriePoids>((Collection)this.ALL_CATEGORIES_ENTRY.getContextValue(context));
        return list;
    }

    protected void removeFullyUsedCategories(RejetThonUI context, ObserveContentTableModel<Calee, CaptureThon> model, List<CategoriePoids> categoriePoidsAvaillable) {
        int nbRaisonRejet = ((List)this.ALL_RAISONS_REJET_ENTRY.getContextValue((JAXXContext)context)).size();
        for (CategoriePoids c : this.getCategoriePoidsUsed(model)) {
            Set<RaisonRejet> raisonUsed = this.getRaisonRejetUsed(model, c);
            if (raisonUsed.size() != nbRaisonRejet) continue;
            categoriePoidsAvaillable.remove(c);
        }
    }
}

