/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.referentiel.ActiviteBateau;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.ObserveTreeModelBuilder;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ActiviteUI;
import fr.ird.observe.ui.content.data.ActivitesHandler;
import java.util.Date;
import java.util.List;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Creator;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.EntityLoador;

public class ActiviteHandler
extends ObserveContentHandler<Route, Activite, ActiviteUI> {
    private static Log log = LogFactory.getLog(ActivitesHandler.class);

    public ActiviteHandler() {
        super(new Creator<Route, Activite>(){

            public Activite create(Route parentBean, Activite bean) throws TopiaException {
                Date d = DBHelper.getCurrentHour((Date)parentBean.getJourObservation());
                bean.setHeureObservation(d);
                return bean;
            }
        }, new Creator<Route, Activite>(){

            public Activite create(Route parentBean, Activite bean) throws TopiaException {
                TopiaContext ctxt = parentBean.getTopiaContext();
                Activite beanToSave = (Activite)ObserveDAOHelper.getActiviteDAO((TopiaContext)ctxt).create(new Object[0]);
                bean.setTopiaId(beanToSave.getTopiaId());
                parentBean.addActivite(beanToSave);
                return beanToSave;
            }
        }, new Deletor<Route, Activite>(){

            public void delete(Route parentBean, Activite bean) {
                parentBean.removeActivite(bean);
            }
        }, EntityLoador.newEntityLoador(Activite.class, (String[])new String[]{"quadrant", "latitude", "longitude", "heureObservation", "temperatureSurface", "causeNonCoupSenne", "commentaire", "vitesseBateau", "systemeObserve", "distanceSystemeObserve", "activiteBateau", "activiteEnvironnante", "ventBeaufort", "modeDetection", "calee", "objetFlottant", "open", "latitudeAsDegre", "latitudeAsMinute", "latitudeAsSeconde", "longitudeAsDegre", "longitudeAsMinute", "longitudeAsSeconde", "useSexagecimalFormat"}));
    }

    @Override
    public void openOpenable(ActiviteUI ui) {
        ui.getEditBean().setOpen(true);
        try {
            this.getStorageService((JAXXContext)ui).update((TopiaEntity)this.getData((JAXXContext)ui, Activite.class), (TopiaEntity)ui.getEditBean(), this.loador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            return;
        }
        this.restartEditUI(ui);
    }

    @Override
    public void closeOpenable(ActiviteUI ui) {
        Activite bean;
        ui.getEditBean().setOpen(false);
        try {
            bean = (Activite)this.getStorageService((JAXXContext)ui).update((TopiaEntity)this.getData((JAXXContext)ui, Activite.class), (TopiaEntity)ui.getEditBean(), this.loador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            return;
        }
        this.closeOpenable(ui, (Openable)bean, I18n._((String)"observe.message.activite.not.open"));
    }

    public void addObjetFlottant(ActiviteUI ui) {
        NavigationTreeNode parentNode = this.getSelectedNode(ui);
        NavigationTreeNode node = this.getTreeBuilder((JAXXContext)ui).addObjetFlottant(parentNode, null);
        this.repaintNode((JAXXContext)ui, parentNode, true);
        this.selectNode((JAXXContext)ui, node);
    }

    public void addCalee(ActiviteUI ui) {
        NavigationTreeNode parentNode = this.getSelectedNode(ui);
        NavigationTreeNode node = this.getTreeBuilder((JAXXContext)ui).addCalee(parentNode, null);
        this.repaintNode((JAXXContext)ui, parentNode, true);
        this.selectNode((JAXXContext)ui, node);
    }

    @Override
    public void openUI(ActiviteUI context) throws Exception {
        super.openUI(context);
        Route route = this.getData((JAXXContext)context, Route.class);
        Activite bean = this.getData((JAXXContext)context, Activite.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        context.getEditBean().setUseSexagecimalFormat(false);
        if (bean == null) {
            this.getStorageService((JAXXContext)context).preCreate((TopiaEntity)route, (TopiaEntity)context.getEditBean(), this.loador, this.preCreator);
        } else {
            this.loador.load((Object)bean, (Object)context.getEditBean(), true);
        }
        context.setMode(mode);
        if (mode != ObserveContentMode.READ) {
            this.getDataContext((JAXXContext)context).setEditingActivite(context.getEditBean());
            context.startEdit(bean);
        }
        context.getEditBean().setUseSexagecimalFormat(true);
        context.setModified(false);
    }

    public String getActivite6Label(ActiviteUI ui) {
        try {
            List activites = this.getStorageService((JAXXContext)ui).getList(ActiviteBateau.class);
            for (ActiviteBateau a : activites) {
                if (a.getCode() != 6) continue;
                Decorator<ActiviteBateau> d = ObserveContext.getDecorator(ActiviteBateau.class);
                String label = d.toString((Object)a);
                return label;
            }
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        throw new IllegalStateException(I18n._((String)"observe.error.no.activite.6"));
    }

    @Override
    protected ObserveContentMode getObserveContentMode(ActiviteUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            boolean create;
            Maree maree = this.getData((JAXXContext)context, Maree.class);
            Route route = this.getData((JAXXContext)context, Route.class);
            Activite bean = this.getData((JAXXContext)context, Activite.class);
            boolean bl = create = bean == null;
            if (create) {
                mode = ObserveContentMode.CREATE;
                context.removeContextValue(Activite.class);
            } else {
                mode = bean.isOpen() ? ObserveContentMode.UPDATE : ObserveContentMode.READ;
            }
            if (!create && !bean.isOpen()) {
                if (!route.isOpen()) {
                    this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.route.not.open"));
                } else if (!maree.isOpen()) {
                    this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
                } else if (!bean.isOpen()) {
                    this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
                }
            }
        }
        return mode;
    }

    @Override
    public void saveUI(ActiviteUI context, boolean refresh) {
        Activite bean = context.getEditBean();
        boolean sexagecimalFormat = bean.isUseSexagecimalFormat();
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(false);
        }
        boolean create = bean.getTopiaId() == null;
        Route route = this.getData((JAXXContext)context, Route.class);
        List oldActivites = route.getActivite();
        if (oldActivites != null && !oldActivites.isEmpty()) {
            DBHelper.sortActivites((List)oldActivites);
        }
        int position = 0;
        Date date = bean.getHeureObservation();
        if (oldActivites != null && !oldActivites.isEmpty()) {
            for (Activite a : oldActivites) {
                if (a.getTopiaId().equals(bean.getTopiaId())) continue;
                if (date.before(a.getHeureObservation())) break;
                ++position;
            }
        }
        try {
            if (create) {
                bean.setOpen(true);
                this.getStorageService((JAXXContext)context).create((TopiaEntity)route, (TopiaEntity)bean, this.loador, this.creator);
            } else {
                this.getStorageService((JAXXContext)context).update((TopiaEntity)this.getData((JAXXContext)context, Activite.class), (TopiaEntity)bean, this.loador);
            }
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(true);
        }
        BeanValidatorUtil.setValidatorChanged((JAXXObject)context, (boolean)false, (String[])new String[0]);
        NavigationTreeNode node = this.getSelectedNode(context);
        NavigationTreeNode parentNode = node.getParent();
        int oldPosition = create ? parentNode.getChildCount() : parentNode.getIndex((TreeNode)node);
        ObserveTreeModelBuilder modelBuilder = this.getTreeBuilder((JAXXContext)context);
        if (create) {
            context.setMode(ObserveContentMode.UPDATE);
            modelBuilder.removeChildNode(node);
            node = modelBuilder.addActivite(parentNode, bean);
            this.stopEditUI(context);
            if (oldPosition != position) {
                modelBuilder.moveNode(parentNode, node, position);
            }
            this.selectNode((JAXXContext)context, node);
        } else if (oldPosition != position) {
            modelBuilder.moveNode(parentNode, node, position);
            this.selectNode((JAXXContext)context, node);
        } else {
            this.repaintNode((JAXXContext)context, node);
        }
    }

    @Override
    public void startEditUI(ActiviteUI context, Activite o, Activite editBean, String ... binding) {
        context.getQuadrantBG().clearSelection();
        boolean create = context.getMode() == ObserveContentMode.CREATE;
        context.getValidator().setContextName(create ? "n1-create" : "n1-update");
        if (create) {
            this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.creating.activite"));
        } else {
            this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.updating.activite"));
        }
        super.startEditUI(context, o, editBean, "heureObservation.date", "longitude.text", "latitude.text", "quadrant1.selected", "quadrant2.selected", "quadrant3.selected", "quadrant4.selected", "vitesseBateau.text", "temparatureSurface.text", "commentaire.text", "activiteBateau.selectedItem", "activiteEnvironnante.selectedItem", "ventBeaufort.selectedItem");
        if (create) {
            context.setModified(true);
        }
    }

    @Override
    public void deleteUI(ActiviteUI context) {
        Route route = this.getData((JAXXContext)context, Route.class);
        Activite bean = context.getEditBean();
        if (!UIHelper.confirmForEntityDelete(context, Activite.class, bean)) {
            return;
        }
        try {
            this.getStorageService((JAXXContext)context).delete((TopiaEntity)route, (TopiaEntity)bean, this.deletator);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            return;
        }
        context.stopEdit();
        NavigationTreeNode node = this.getSelectedNode(context);
        NavigationTreeNode parentNode = this.getTreeBuilder((JAXXContext)context).removeChildNode(node);
        this.selectNode((JAXXContext)context, parentNode);
    }
}

