/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContent;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentReferentielUI;
import fr.ird.observe.ui.content.ObserveContentUI;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.BeanValidatorScope;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Creator;
import org.nuiton.topia.persistence.util.Loador;

public abstract class ObserveContentReferentielHandler<E extends TopiaEntity, UI extends ObserveContentReferentielUI<E>>
extends ObserveContentHandler<Void, E, UI> {
    protected Class<E> referentielClass;
    protected String[] dataBinding;

    protected ObserveContentReferentielHandler(Class<E> referentielClass, String[] dataBinding, Creator<Void, E> preCreator, Creator<Void, E> creator, Loador<E> loador) {
        super(preCreator, creator, null, loador);
        this.referentielClass = referentielClass;
        this.dataBinding = dataBinding;
        this.preCreator = preCreator;
        this.creator = creator;
        this.loador = loador;
    }

    @Override
    public void initUI(UI context) throws Exception {
        super.initUI(context);
        StorageService<?> service = this.getStorageService((JAXXContext)context);
        UIHelper.prepareEntityList(service, this.referentielClass, ((ObserveContentReferentielUI)context).getList());
    }

    @Override
    public void startEditUI(UI context, E o, E editBean, String ... binding) {
        super.startEditUI(context, o, editBean, this.dataBinding);
        this.removeAllMessages((ObserveContent<?>)context);
        this.addMessage((ObserveContent<?>)context, BeanValidatorScope.INFO, this.getEntityLabel(this.referentielClass), I18n._((String)"observe.message.referentiel.no.editable"));
    }

    @Override
    public void createUI(UI context) {
        try {
            this.getStorageService((JAXXContext)context).preCreate(context.getRefEditBean(), this.loador);
            ((ObserveContentUI)context).startEdit(null);
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
        }
    }

    @Override
    public void modifyUI(UI context) {
        this.loador.load((Object)context.getSelectedBean(), (Object)context.getRefEditBean(), true);
        ((ObserveContentUI)context).startEdit((TopiaEntity)context.getSelectedBean());
    }

    @Override
    public void saveUI(UI context, boolean refresh) {
        TopiaEntity bean = context.getRefEditBean();
        try {
            if (bean.getTopiaId() == null) {
                this.getStorageService((JAXXContext)context).create(bean, this.loador, this.creator);
            } else {
                this.getStorageService((JAXXContext)context).update((TopiaEntity)((ObserveContentUI)context).getContextValue(this.referentielClass, "edit"), bean, this.loador);
            }
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        ((ObserveContentUI)context).stopEdit();
    }

    @Override
    public void deleteUI(UI context) {
        TopiaEntity bean = context.getSelectedBean();
        if (!UIHelper.confirmForEntityDelete(context, this.referentielClass, bean)) {
            return;
        }
        try {
            this.getStorageService((JAXXContext)context).delete(bean);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        ((ObserveContentUI)context).stopEdit();
    }
}

