/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.ObserveMainUI;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorUtils;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.FileUtil;

public class UIHelper
extends SwingUtil {
    private static final Log log = LogFactory.getLog(UIHelper.class);

    public static void displayInfo(JAXXContext context, String text) {
        ObserveMainUI ui = (ObserveMainUI)ObserveContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        if (ui == null) {
            JOptionPane.showMessageDialog(null, text);
        } else {
            ui.getStatus().setStatus(text);
        }
    }

    public static int askUser(String title, String message, int typeMessage, Object[] options, int defaultOption) {
        return UIHelper.askUser(null, title, message, typeMessage, options, defaultOption);
    }

    public static int askUser(Component parent, String title, String message, int typeMessage, Object[] options, int defaultOption) {
        ObserveContext context;
        if (parent == null && (context = ObserveContext.get()) != null) {
            parent = (Component)ObserveContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
        }
        int response = JOptionPane.showOptionDialog(parent, message, title, -1, typeMessage, null, options, options[defaultOption]);
        return response;
    }

    public static int showConfirmDialog(String title, String message, int operations, int messageType) {
        int response = UIHelper.showConfirmDialog(null, title, message, operations, messageType);
        return response;
    }

    public static int showConfirmDialog(Component parent, String title, String message, int operations, int messageType) {
        ObserveContext context;
        if (parent == null && (context = ObserveContext.get()) != null) {
            parent = (Component)ObserveContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
        }
        int response = JOptionPane.showConfirmDialog(parent, message, title, operations, messageType);
        return response;
    }

    public static File chooseFile(Component parent, String title, String buttonLabel, File incoming, String ... filters) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        File file = FileUtil.getFile((String)title, (String)buttonLabel, (Component)parent, (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        File result = file == null ? incoming : file;
        return result;
    }

    public static File chooseDirectory(Component parent, String title, String buttonLabel, File incoming) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        String file = FileUtil.getDirectory((Component)parent, (String)title, (String)buttonLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        return file == null ? incoming : new File(file);
    }

    public static <E extends TopiaEntity> void prepareEntityList(StorageService<?> storageService, Class<E> entityClass, JList list) throws StorageServiceException {
        Decorator<E> decorator = ObserveContext.getDecorator(entityClass);
        list.putClientProperty("decorator", decorator);
        list.setCellRenderer(new DecoratorListCellRenderer(decorator));
        List data = storageService.getList(entityClass);
        DecoratorUtils.sort((JXPathDecorator)((JXPathDecorator)decorator), (List)data, (int)0);
        list.setListData(data.toArray());
        storageService.addCachePropertyChangeListener(entityClass, new EntitiesListPropertyChangeListener<E>(entityClass, list));
    }

    public static <E extends TopiaEntity> void prepareEntityComboBox(StorageService<?> storageService, Class<E> entityClass, EntityComboBox comboBox) throws StorageServiceException {
        Decorator<E> decorator = ObserveContext.getDecorator(entityClass);
        List data = storageService.getList(entityClass);
        comboBox.init((JXPathDecorator)decorator, data);
        storageService.addCachePropertyChangeListener(entityClass, new EntitiesComboBoxPropertyChangeListener<E>(entityClass, comboBox));
    }

    public static void prepareToogleListSelectionModel(JList list) {
        list.setSelectionModel((ListSelectionModel)new OneClicListSelectionModel(list.getSelectionModel(), list.getModel()));
    }

    public static <E extends TopiaEntity> boolean confirmForEntityDelete(JAXXObject parent, Class<E> beanClass, E bean) {
        return UIHelper.confirmForEntityDelete(parent, beanClass, bean, null);
    }

    public static <E extends TopiaEntity> boolean confirmForEntityDelete(JAXXObject parent, Class<E> beanClass, E bean, String extraMessage) {
        int response;
        String messageDelete;
        if (parent == null) {
            parent = (JAXXObject)ObserveContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)ObserveContext.get());
        }
        Decorator<E> decorator = ObserveContext.getDecorator(beanClass);
        String type = DBHelper.getEntityLabel(beanClass);
        type = I18n._((String)type);
        if (bean == null || bean.getTopiaId() == null || decorator == null) {
            messageDelete = I18n._((String)"observe.message.delete.new", (Object[])new Object[]{type});
        } else {
            try {
                String beanStr = decorator.toString(bean);
                messageDelete = I18n._((String)"observe.message.delete", (Object[])new Object[]{type, beanStr});
            }
            catch (Exception e) {
                messageDelete = I18n._((String)"observe.message.delete.new", (Object[])new Object[]{type});
            }
        }
        if (extraMessage != null) {
            messageDelete = messageDelete + '\n' + extraMessage;
        }
        return (response = UIHelper.askUser((Component)parent, I18n._((String)"observe.title.delete"), messageDelete, 2, new Object[]{I18n._((String)"observe.choice.confirm.delete"), I18n._((String)"observe.choice.cancel")}, 1)) == 0;
    }

    public static DecoratorTableCellRenderer newDecorateTableCellRenderer(TableCellRenderer renderer, Class<?> entityClass) {
        Decorator<?> decorator = ObserveContext.getDecorator(entityClass);
        return new DecoratorTableCellRenderer(renderer, decorator);
    }

    public static TableCellRenderer newStringTableCellRenderer(TableCellRenderer renderer, final int length, final boolean tooltip) {
        return new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String val;
                String val2 = val = value == null ? "" : value.toString();
                if (val.length() > length) {
                    val2 = val.substring(0, length - 3) + "...";
                }
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, val2, isSelected, hasFocus, row, column);
                if (tooltip) {
                    comp.setToolTipText(val);
                }
                return comp;
            }
        };
    }

    public static class ObserveValidatorMessageTableRenderer
    extends SwingValidatorMessageTableRenderer {
        private static final long serialVersionUID = 1L;

        public String getFieldName(JTable table, String value, int row) {
            String fieldName = super.getFieldName(table, value, row);
            if (!DBHelper.getPropertyMatch((String)fieldName).matches()) {
                fieldName = DBHelper.getPropertyLabel((String)fieldName);
            }
            return I18n._((String)fieldName);
        }
    }

    protected static class EntitiesComboBoxPropertyChangeListener<E extends TopiaEntity>
    implements PropertyChangeListener {
        private Class<E> entityClass;
        private EntityComboBox comboBox;

        public EntitiesComboBoxPropertyChangeListener(Class<E> entityClass, EntityComboBox comboBox) {
            this.entityClass = entityClass;
            this.comboBox = comboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List newValue = (List)evt.getNewValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            this.comboBox.setData(newValue);
        }
    }

    protected static class EntitiesListPropertyChangeListener<E extends TopiaEntity>
    implements PropertyChangeListener {
        private Class<E> entityClass;
        private JList list;

        public EntitiesListPropertyChangeListener(Class<E> entityClass, JList list) {
            this.entityClass = entityClass;
            this.list = list;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List newValue = (List)evt.getNewValue();
            Decorator decorator = (Decorator)this.list.getClientProperty("decorator");
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            DecoratorUtils.sort((JXPathDecorator)((JXPathDecorator)decorator), (List)newValue, (int)0);
            this.list.setListData(newValue.toArray());
        }
    }
}

