/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.ObserveDecoratorProvider;
import fr.ird.observe.storage.CreationMode;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.impl.H2StorageService;
import fr.ird.observe.storage.impl.PGStorageService;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveTreeHelper;
import fr.ird.observe.ui.ObserveUIMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContent;
import fr.ird.observe.ui.content.ObserveContentActions;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUI;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.synchro.SynchroPanelUI;
import fr.ird.observe.ui.synchro.SynchroStep;
import fr.ird.observe.ui.synchro.SynchroUIModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIBuilder;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModelBuilder;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import jaxx.runtime.swing.help.JAXXHelpUIHandler;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardUI;
import jaxx.runtime.swing.wizard.WizardUILancher;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.Resource;

@DefaultApplicationContext.AutoLoad
public class ObserveMainUIHandler
implements JAXXHelpUIHandler {
    private static Log log = LogFactory.getLog(ObserveMainUIHandler.class);
    final Runnable reloadUICallback = new Runnable(){

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)"will reload ui");
            }
            ObserveContext context = ObserveContext.get();
            ObserveMainUI ui = ObserveMainUIHandler.this.getUI((JAXXContext)context);
            ObserveConfig config = ui.getConfig();
            ObserveMainUIHandler.this.reloadUI(context, config);
        }
    };

    public ObserveMainUI initUI(ObserveContext rootContext, ObserveConfig config) {
        ObserveTreeHelper treeHelper = new ObserveTreeHelper();
        SwingValidatorMessageTableModel errorModel = new SwingValidatorMessageTableModel();
        if (!config.getLocale().equals(I18n.getLoader().getLanguage().getLocale())) {
            if (log.isInfoEnabled()) {
                log.info((Object)("re-init I18n with locale " + config.getLocale()));
            }
            I18n.init((Locale)config.getLocale());
            ObserveDecoratorProvider decoratorProvider = (ObserveDecoratorProvider)rootContext.getContextValue(ObserveDecoratorProvider.class);
            decoratorProvider.reload();
        }
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)treeHelper).add((Object)errorModel);
        final ObserveMainUI ui = new ObserveMainUI((JAXXContext)context);
        ui.setUndecorated(config.isFullScreen());
        ObserveContext.MAIN_UI_ENTRY_DEF.setContextValue((JAXXContext)rootContext, (Object)ui);
        ErrorDialogUI.init((Frame)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(config.isFullScreen() ? ui : null);
        ActionMap actionMap = ui.getRootPane().getActionMap();
        for (ObserveContentActions actionDef : ObserveContentActions.values()) {
            Action a = actionDef.createAction(ui);
            actionMap.put((Object)actionDef, a);
        }
        AbstractAction a = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JComponent source = (JComponent)e.getSource();
                NavigationTreeNode node = (NavigationTreeNode)source.getClientProperty("node");
                ui.getTreeHelper().selectNode((JAXXContext)ui, node);
            }
        };
        a.putValue("ShortDescription", I18n._((String)"observe.action.selectNode.tip"));
        actionMap.put("selectNode", a);
        return ui;
    }

    public void changeLanguage(ObserveMainUI mainUI, Locale newLocale) {
        ObserveConfig config = mainUI.getConfig();
        config.setLocale(newLocale);
        this.reloadUI(ObserveContext.get(), config);
    }

    public void showGoUp(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        JPopupMenu p = (JPopupMenu)c.getClientProperty("popup");
        if (p == null) {
            throw new IllegalStateException("could not find client property popup on component" + c);
        }
        p.show(c, 2, c.getHeight());
    }

    public void showGoDown(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        JPopupMenu p = (JPopupMenu)c.getClientProperty("popup");
        if (p == null) {
            throw new IllegalStateException("could not find client property popup on component" + c);
        }
        p.show(c, 2, c.getHeight());
    }

    public void showStorageInfo(ObserveMainUI ui) {
        String text = ui.getConfig().isMainStorageOpened() ? ui.getDataContext().getStorage().toString() : I18n._((String)"observe.message.db.none.loaded");
        JOptionPane.showMessageDialog(ui, text, I18n._((String)"observe.title.storage.info"), 1);
    }

    public void launchImportFromFile(final JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        ObserveMainUI mainUI = this.getUI(rootContext);
        new WizardUILancher<StorageStep, StorageUIModel, StorageUI>(rootContext, (Window)mainUI, StorageUI.class, StorageUIModel.class){

            protected void init(StorageUI ui) {
                StorageUIModel model = ui.getModel();
                model.setDbMode(DbMode.LOCAL);
                model.setCreationMode(CreationMode.IMPORT_EXTERNAL_DUMP);
                if (model.isLocalStorageExist()) {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.BACKUP, StorageStep.CONFIRM});
                } else {
                    model.setSteps(new StorageStep[]{StorageStep.CONFIG, StorageStep.CONFIRM});
                }
                ui.setTitle(I18n._((String)"observe.title.import.localDB"));
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                StorageUIHandler handler = (StorageUIHandler)rootContext.getContextValue(StorageUIHandler.class);
                handler.doChangeStorage(rootContext, ui.getModel());
            }

            protected void doCancel(StorageUI ui) {
                super.doCancel((WizardUI)ui);
                ObserveContent selectedUI = (ObserveContent)ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.getContextValue((JAXXContext)ui);
                if (selectedUI != null && selectedUI.isEnabled()) {
                    selectedUI.restartEdit();
                }
            }
        }.start();
    }

    public void launchChangeStorage(final JAXXContext rootContext, final DbMode mode, final String title) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        ObserveMainUI mainUI = this.getUI(rootContext);
        new WizardUILancher<StorageStep, StorageUIModel, StorageUI>(rootContext, (Window)mainUI, StorageUI.class, StorageUIModel.class){

            protected void init(StorageUI ui) {
                super.init((WizardUI)ui);
                if (title != null) {
                    ui.setTitle(I18n._((String)title));
                }
                StorageUIModel model = ui.getModel();
                if (mode != null) {
                    model.setDbMode(mode);
                    model.setExcludeSteps(Arrays.asList(StorageStep.CHOOSE_DB_MODE));
                }
                model.updateUniverse();
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                StorageUIHandler handler = (StorageUIHandler)rootContext.getContextValue(StorageUIHandler.class);
                handler.doChangeStorage(rootContext, ui.getModel());
            }

            protected void doCancel(StorageUI ui) {
                super.doCancel((WizardUI)ui);
                ObserveContent selectedUI = (ObserveContent)ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.getContextValue((JAXXContext)ui);
                if (selectedUI != null && selectedUI.isEnabled()) {
                    selectedUI.restartEdit();
                }
            }
        }.start();
    }

    public void launchExportToFile(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        ObserveMainUI mainUI = this.getUI(rootContext);
        new WizardUILancher<StorageStep, StorageUIModel, StorageUI>(rootContext, (Window)mainUI, StorageUI.class, StorageUIModel.class){

            protected void init(StorageUI ui) {
                ui.setTitle(I18n._((String)"observe.title.save.localDB"));
                ui.getBACKUP().getDoBackup().setSelected(true);
                ui.getBACKUP().getDoBackup().setVisible(false);
                ui.getModel().setSteps(new StorageStep[]{StorageStep.BACKUP, StorageStep.CONFIRM});
            }

            protected void doAction(StorageUI ui) {
                log.info((Object)ui.getName());
                StorageUIHandler handler = ui.getContextValue(StorageUIHandler.class);
                ObserveDataContext dataContext = ui.getContextValue(ObserveDataContext.class);
                StorageService storage = dataContext.getStorage();
                handler.backupLocalDatabase(storage, ui.getModel().getBackupFile());
            }

            protected void doCancel(StorageUI ui) {
                super.doCancel((WizardUI)ui);
                ObserveContent selectedUI = (ObserveContent)ObserveContext.SELECTED_CONTENT_UI_ENTRY_DEF.getContextValue((JAXXContext)ui);
                if (selectedUI != null && selectedUI.isEnabled()) {
                    selectedUI.restartEdit();
                }
            }
        }.start();
    }

    public void launchSynchronizeReferentiel(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new SynchroWizardLauncher(rootContext, I18n._((String)"observe.title.synchronizeReferentiel"), I18n._((String)"observe.title.synchronizeReferentiel.tip"), null){

            protected void init(SynchroPanelUI ui) {
                ui.getModel().addOperation(SynchroStep.SYNCHRONIZE_REFERENTIEL);
                ui.blockOperations();
            }
        }.start();
    }

    public void launchExportData(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new SynchroWizardLauncher(rootContext, I18n._((String)"observe.title.exportData"), I18n._((String)"observe.title.exportData.tip"), null){

            protected void init(SynchroPanelUI ui) {
                ui.getModel().addOperation(SynchroStep.EXPORT_DATA);
                ui.blockOperations();
            }
        }.start();
    }

    public void launchValidateData(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new SynchroWizardLauncher(rootContext, I18n._((String)"observe.title.validateData"), I18n._((String)"observe.title.validateData.tip"), null){

            protected void init(SynchroPanelUI ui) {
                ui.getModel().addOperation(SynchroStep.VALIDATE_DATA);
                ui.blockOperations();
            }
        }.start();
    }

    public void launchImportGPS(JAXXContext rootContext) {
        boolean canContinue = this.ensureModification(rootContext);
        if (!canContinue) {
            return;
        }
        new SynchroWizardLauncher(rootContext, I18n._((String)"observe.title.importGPS"), I18n._((String)"observe.title.importGPS.tip"), null){

            protected void init(SynchroPanelUI ui) {
                ui.getModel().addOperation(SynchroStep.IMPORT_GPS);
                ui.blockOperations();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ObserveMainUI ui) {
        log.info((Object)"ObServe quitting...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        try {
            ui.dispose();
        }
        finally {
            System.exit(0);
        }
    }

    public void changeScreen(ObserveMainUI ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ObserveConfig config = ui.getConfig();
        config.setFullScreen(fullscreen);
        this.reloadUI(ObserveContext.get(), config);
    }

    public void showConfig(JAXXContext context) {
        ObserveMainUI ui = this.getUI(context);
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        ConfigUIModelBuilder builder = new ConfigUIModelBuilder();
        builder.createModel((ApplicationConfig)config);
        builder.setReloadUICallback(this.reloadUICallback);
        builder.addCategory(I18n.n_((String)"observe.config.category.directories"), I18n.n_((String)"observe.config.category.directories.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.CONFIG_FILE);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.DB_DIRECTORY);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.TMP_DIRECTORY);
        builder.addCategory(I18n.n_((String)"observe.config.category.h2"), I18n.n_((String)"observe.config.category.h2.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.H2_LOGIN);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.H2_PASSWORD);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.H2_CAN_MIGRATE);
        builder.addCategory(I18n.n_((String)"observe.config.category.obstuna"), I18n.n_((String)"observe.config.category.obstuna.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.OBSTUNA_URL);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.OBSTUNA_LOGIN);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.OBSTUNA_USE_SSL_CERT);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.OBSTUNA_SSL_CERTIFICAT_FILE);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.OBSTUNA_CAN_MIGRATE);
        builder.addCategory(I18n.n_((String)"observe.config.category.changeStorage"), I18n.n_((String)"observe.config.category.changeStorage.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.DEFAULT_DB_MODE, "defaultDbMode");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.DEFAULT_CREATION_MODE, "defaultCreationMode");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.CAN_GENERATE_EMPTY_DB, "canGenerateEmptyDb");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.STORE_REMOTE_STORAGE, "storeResumeStorage");
        builder.addCategory(I18n.n_((String)"observe.config.category.gps"), I18n.n_((String)"observe.config.category.gps.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.DEFAULT_GPS_MAX_DELAY, "defaultGpsMaxDelay");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.DEFAULT_GPS_MAX_SPEED, "defaultGpsMaxSpeed");
        builder.addCategory(I18n.n_((String)"observe.config.category.synchro"), I18n.n_((String)"observe.config.category.synchro.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.CHANGE_SYNCHRO_SRC, "changeSynchroSrc");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.DISPLAY_SYNCHRO_RESUME, "displaySynchroResume");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.H2_CAN_MIGRATE);
        builder.addCategory(I18n.n_((String)"observe.config.category.other"), I18n.n_((String)"observe.config.category.other.description"));
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.SHOW_NUMBER_EDITOR_BUTTON, "showNumberEditorButton");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.AUTO_POPUP_NUMBER_EDITOR, "autoPopupNumberEditor");
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.FULL_SCREEN, "fullScreen");
        builder.setOptionNeedReloadUI(true);
        builder.addOption((ApplicationConfig.OptionDef)ObserveConfig.Option.LOCALE, "locale");
        builder.setOptionNeedReloadUI(true);
        ConfigUIModel model = builder.flushModel();
        ConfigUI configUI = ConfigUIBuilder.newConfigUI((JAXXContext)context, (ConfigUIModel)model, (String)"observe.config.category.directories");
        ConfigUIBuilder.showConfigUI((ConfigUI)configUI, (Frame)ui, (boolean)false);
    }

    public void showHelp(JAXXContext context, JAXXHelpBroker broker, String helpId) {
        ObserveMainUI mainUI = this.getUI(context);
        if (helpId == null) {
            helpId = broker.getDefaultID();
        }
        log.debug((Object)("show help " + helpId));
        mainUI.getHelp().setCurrentID(helpId);
        mainUI.setContextValue(mainUI.getMode(), "oldMode");
        mainUI.setMode(ObserveUIMode.HELP);
    }

    public void closeHelp(JAXXContext context) {
        ObserveMainUI mainUI = this.getUI(context);
        ObserveUIMode oldMode = mainUI.getContextValue(ObserveUIMode.class, "oldMode");
        if (oldMode == null) {
            ObserveDataContext dataContext = (ObserveDataContext)context.getContextValue(ObserveDataContext.class);
            StorageService mainStorage = dataContext.getStorage();
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        mainUI.setMode(oldMode);
    }

    public void gotoSite(JAXXContext rootContext) {
        ObserveConfig config = (ObserveConfig)((Object)rootContext.getContextValue(ObserveConfig.class));
        URL siteURL = config.getOptionAsURL("application.site.url");
        UIHelper.displayInfo(rootContext, I18n._((String)"observe.message.goto.site", (Object[])new Object[]{siteURL}));
        log.info((Object)("goto " + siteURL));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void showAbout(ObserveMainUI ui) {
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;

            public void buildTopPanel() {
                this.topPanel.setLayout(new BorderLayout());
                ImageIcon logoIcon = Resource.getIcon((String)"/icons/logo-OT_web.png");
                JLabel labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "West");
                logoIcon = Resource.getIcon((String)"/icons/logo_ird.png");
                labelIcon = new JLabel(logoIcon);
                this.topPanel.add((Component)labelIcon, "East");
            }
        };
        about.setTitle(I18n._((String)"observe.title.about"));
        about.setAboutText(I18n._((String)"observe.about.message"));
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setIconPath("/icons/logo-OT_web.png");
        about.setLicenseFile("META-INF/observe-swing-LICENSE.txt");
        about.setThirdpartyFile("META-INF/observe-swing-THIRD-PARTY.txt");
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected void reloadUI(ObserveContext rootContext, ObserveConfig config) {
        ((ObserveDataContext)rootContext.getContextValue(ObserveDataContext.class)).removeJaxxPropertyChangeListener();
        ((ObserveConfig)((Object)rootContext.getContextValue(ObserveConfig.class))).removeJaxxPropertyChangeListener();
        ObserveMainUI ui = this.getUI((JAXXContext)rootContext);
        ObserveDataContext dataContext = (ObserveDataContext)rootContext.getContextValue(ObserveDataContext.class);
        StorageService mainStorage = dataContext.getStorage();
        NavigationTreeNode node = null;
        ObserveUIMode oldMode = null;
        if (ui != null) {
            oldMode = ui.getMode();
            node = ui.getTreeHelper().getSelectedNode((JAXXContext)ui);
            ErrorDialogUI.init(null);
            ObserveContext.MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            ui.dispose();
            ui.setVisible(false);
            if (mainStorage != null) {
                mainStorage.removeCachePropertyChangeListeners();
            }
        }
        ui = this.initUI(rootContext, config);
        if (oldMode == null) {
            oldMode = mainStorage == null ? ObserveUIMode.NO_DB : ObserveUIMode.DB;
        }
        ui.setMode(oldMode);
        if (node != null) {
            ui.getTreeHelper().selectNode((JAXXContext)ui, node.getFullPath());
        }
        ui.getNavigation().requestFocus();
        ui.setVisible(true);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        JPanel container;
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        ObserveMainUI ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        Boolean wasClosed = null;
        CardLayout2 layout = ui.getContentLayout();
        Component currentContent = layout.getVisibleComponent((Container)(container = ui.getContent()));
        if (currentContent != null && currentContent instanceof ObserveContent) {
            wasClosed = ObserveContentHandler.checkEdit((ObserveContentUI)((Object)currentContent));
        }
        return wasClosed == null || wasClosed != false;
    }

    ObserveMainUI getUI(JAXXContext context) {
        if (context instanceof ObserveMainUI) {
            return (ObserveMainUI)context;
        }
        ObserveMainUI ui = (ObserveMainUI)ObserveContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    class SynchroWizardLauncher
    extends WizardUILancher<SynchroStep, SynchroUIModel, SynchroPanelUI> {
        protected Component parent;

        public SynchroWizardLauncher(JAXXContext context, String title, String tip, ImageIcon icon) {
            super(context, SynchroPanelUI.class, SynchroUIModel.class, title, tip, icon);
        }

        protected void start(SynchroPanelUI ui) {
            super.start((WizardUI)ui);
            ObserveMainUI mainUI = ObserveMainUIHandler.this.getUI((JAXXContext)ui);
            String title = (String)ui.getClientProperty("title");
            String tip = (String)ui.getClientProperty("tip");
            ImageIcon icon = (ImageIcon)ui.getClientProperty("icon");
            if (mainUI == null) {
                JDialog dialog = new JDialog();
                dialog.setSize(650, 800);
                dialog.setTitle(I18n._((String)title));
                dialog.setContentPane(ui);
                if (icon != null) {
                    dialog.setIconImage(icon.getImage());
                }
                dialog.setDefaultCloseOperation(2);
                dialog.setAlwaysOnTop(true);
                this.parent = dialog;
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("closing dialog " + e.getWindow().getName()));
                        }
                        if (((SynchroPanelUI)SynchroWizardLauncher.this.ui).getModel().getModelState() != WizardOperationState.CANCELED) {
                            log.info((Object)("cancel panel from dialog !" + e.getWindow().getName()));
                            ((SynchroPanelUI)SynchroWizardLauncher.this.ui).cancel();
                            return;
                        }
                    }
                });
                dialog.setVisible(true);
            } else {
                JXTitledPanel panel = mainUI.getSynchroWizard();
                panel.setTitle(I18n._((String)title));
                panel.setToolTipText(I18n._((String)tip));
                panel.setContentContainer((Container)ui);
                mainUI.setContextValue(ui.getModel());
                this.parent = mainUI;
                mainUI.setMode(ObserveUIMode.SYNCHRO);
            }
        }

        protected void doAction(SynchroPanelUI ui) {
            log.info((Object)this);
        }

        protected void doCancel(SynchroPanelUI ui) {
            log.info((Object)this);
        }

        protected void doClose(SynchroPanelUI ui, boolean wasCanceled) {
            log.info((Object)((Object)((Object)this) + ", was canceled ? " + wasCanceled));
            if (this.parent instanceof ObserveMainUI) {
                ObserveMainUI mainUI = (ObserveMainUI)this.parent;
                boolean needReload = false;
                needReload = !wasCanceled && ui.getModel().isLocalServiceNeedSave();
                StorageService<?> previousService = ui.getModel().getPreviousService();
                if (needReload && previousService != null) {
                    needReload = previousService instanceof H2StorageService;
                }
                try {
                    if (ui.getModel().getSynchroService() != null) {
                        ui.getModel().getSynchroService().doClose(false);
                    }
                }
                catch (StorageServiceException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                try {
                    if (ui.getModel().getReferentielService() != null) {
                        ui.getModel().getReferentielService().doClose(false);
                    }
                }
                catch (StorageServiceException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                try {
                    if (ui.getModel().getLocalService() != null) {
                        ui.getModel().getLocalService().doClose(false);
                    }
                }
                catch (StorageServiceException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                if (previousService != null && previousService instanceof PGStorageService) {
                    mainUI.setMode(ObserveUIMode.DB);
                    mainUI.getTreeHelper().selectInitialNode(mainUI);
                    return;
                }
                ObserveContext context = ObserveContext.get();
                if (((ObserveConfig)((Object)context.getContextValue(ObserveConfig.class))).isLocalStorageExist()) {
                    try {
                        if (previousService != null && previousService.isOpen()) {
                            previousService.doClose(false);
                        }
                        H2StorageService service = context.newLocalStorageService();
                        context.prepareMainStorage((StorageService<?>)service);
                        service.doOpen();
                        mainUI.setMode(ObserveUIMode.DB);
                        mainUI.getTreeHelper().selectInitialNode(mainUI);
                        return;
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                        ErrorDialogUI.showError((Exception)ex);
                    }
                }
                mainUI.setMode(ObserveUIMode.NO_DB);
            } else {
                JDialog dialog = (JDialog)this.parent;
                if (dialog.isVisible()) {
                    log.info((Object)"dispose ui! ");
                    dialog.dispose();
                }
            }
        }
    }
}

