/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.update.CommitUpdateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommitTracker
implements Runnable {
    protected static final Logger log = LoggerFactory.getLogger(CommitTracker.class);
    public final int DOC_COMMIT_DELAY_MS = 1;
    private int docsUpperBound;
    private long timeUpperBound;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture pending;
    private AtomicLong docsSinceCommit = new AtomicLong(0L);
    private AtomicInteger autoCommitCount = new AtomicInteger(0);
    private final SolrCore core;
    private final boolean softCommit;
    private final boolean waitSearcher;
    private String name;

    public CommitTracker(String name, SolrCore core, int docsUpperBound, int timeUpperBound, boolean waitSearcher, boolean softCommit) {
        this.core = core;
        this.name = name;
        this.pending = null;
        this.docsUpperBound = docsUpperBound;
        this.timeUpperBound = timeUpperBound;
        this.softCommit = softCommit;
        this.waitSearcher = waitSearcher;
        SolrCore.log.info(name + " AutoCommit: " + this);
    }

    public synchronized void close() {
        if (this.pending != null) {
            this.pending.cancel(true);
            this.pending = null;
        }
        this.scheduler.shutdownNow();
    }

    public void scheduleCommitWithin(long commitMaxTime) {
        this._scheduleCommitWithin(commitMaxTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _scheduleCommitWithin(long commitMaxTime) {
        if (commitMaxTime <= 0L) {
            return;
        }
        CommitTracker commitTracker = this;
        synchronized (commitTracker) {
            boolean canceled;
            if (this.pending != null && this.pending.getDelay(TimeUnit.MILLISECONDS) <= commitMaxTime) {
                return;
            }
            if (this.pending != null && !(canceled = this.pending.cancel(false))) {
                return;
            }
            this.pending = this.scheduler.schedule(this, commitMaxTime, TimeUnit.MILLISECONDS);
        }
    }

    public void addedDocument(int commitWithin) {
        long ctime;
        long docs;
        if (this.docsUpperBound > 0 && (docs = this.docsSinceCommit.incrementAndGet()) == (long)(this.docsUpperBound + 1)) {
            this.docsSinceCommit.set(0L);
            this._scheduleCommitWithin(1L);
        }
        long l = ctime = commitWithin > 0 ? (long)commitWithin : this.timeUpperBound;
        if (ctime > 0L) {
            this._scheduleCommitWithin(ctime);
        }
    }

    public void didCommit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didRollback() {
        CommitTracker commitTracker = this;
        synchronized (commitTracker) {
            if (this.pending != null) {
                this.pending.cancel(false);
                this.pending = null;
            }
            this.docsSinceCommit.set(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CommitTracker commitTracker = this;
        synchronized (commitTracker) {
            this.pending = null;
        }
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.core, (SolrParams)new ModifiableSolrParams());
        try {
            try {
                CommitUpdateCommand command = new CommitUpdateCommand(false);
                command.waitSearcher = this.waitSearcher;
                this.autoCommitCount.incrementAndGet();
                this.core.getUpdateHandler().commit(command);
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"auto commit error...", (Throwable)e);
                Object var4_6 = null;
                req.close();
            }
            Object var4_5 = null;
            req.close();
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            req.close();
            throw throwable;
        }
    }

    public int getCommitCount() {
        return this.autoCommitCount.get();
    }

    public String toString() {
        if (this.timeUpperBound > 0L || this.docsUpperBound > 0) {
            return (this.timeUpperBound > 0L ? "if uncommited for " + this.timeUpperBound + "ms; " : "") + (this.docsUpperBound > 0 ? "if " + this.docsUpperBound + " uncommited docs " : "");
        }
        return "disabled";
    }

    public long getTimeUpperBound() {
        return this.timeUpperBound;
    }

    int getDocsUpperBound() {
        return this.docsUpperBound;
    }

    void setDocsUpperBound(int docsUpperBound) {
        this.docsUpperBound = docsUpperBound;
    }

    void setTimeUpperBound(long timeUpperBound) {
        this.timeUpperBound = timeUpperBound;
    }
}

