/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.util.Collection;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyI18nAbstract;

public class WikittyI18nHelper {
    private WikittyI18nHelper() {
    }

    public static Set<String> getTranslatableValues(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet("WikittyI18n", "translatableValues", String.class);
        return result;
    }

    public static void setTranslatableValues(Wikitty wikitty, Set<String> translatableValues) {
        wikitty.setField("WikittyI18n", "translatableValues", translatableValues);
    }

    public static void addAllTranslatableValues(Wikitty wikitty, Collection<String> translatableValues) {
        if (translatableValues != null) {
            for (String v : translatableValues) {
                WikittyI18nHelper.addTranslatableValues(wikitty, v);
            }
        }
    }

    public static void addTranslatableValues(Wikitty wikitty, String ... element) {
        for (String v : element) {
            wikitty.addToField("WikittyI18n", "translatableValues", v);
        }
    }

    public static void removeTranslatableValues(Wikitty wikitty, String ... element) {
        for (String v : element) {
            wikitty.removeFromField("WikittyI18n", "translatableValues", v);
        }
    }

    public static void clearTranslatableValues(Wikitty wikitty) {
        wikitty.clearField("WikittyI18n", "translatableValues");
    }

    public static Set<String> getLang(Wikitty wikitty) {
        Set<String> result = wikitty.getFieldAsSet("WikittyI18n", "lang", String.class);
        return result;
    }

    public static void setLang(Wikitty wikitty, Set<String> lang) {
        wikitty.setField("WikittyI18n", "lang", lang);
    }

    public static void addAllLang(Wikitty wikitty, Collection<String> lang) {
        if (lang != null) {
            for (String v : lang) {
                WikittyI18nHelper.addLang(wikitty, v);
            }
        }
    }

    public static void addLang(Wikitty wikitty, String ... element) {
        for (String v : element) {
            wikitty.addToField("WikittyI18n", "lang", v);
        }
    }

    public static void removeLang(Wikitty wikitty, String ... element) {
        for (String v : element) {
            wikitty.removeFromField("WikittyI18n", "lang", v);
        }
    }

    public static void clearLang(Wikitty wikitty) {
        wikitty.clearField("WikittyI18n", "lang");
    }

    public static String getTranslations(Wikitty wikitty) {
        String value = wikitty.getFieldAsString("WikittyI18n", "translations");
        return value;
    }

    public static String setTranslations(Wikitty wikitty, String translations) {
        String oldValue = WikittyI18nHelper.getTranslations(wikitty);
        wikitty.setField("WikittyI18n", "translations", translations);
        return oldValue;
    }

    public static boolean equals(Wikitty w1, Wikitty w2) {
        Object f2;
        Object f1;
        boolean result = true;
        if (result) {
            f1 = w1.getFieldAsObject("WikittyI18n", "translatableValues");
            boolean bl = result = f1 == (f2 = w2.getFieldAsObject("WikittyI18n", "translatableValues")) || f1 != null && f1.equals(f2);
        }
        if (result) {
            f1 = w1.getFieldAsObject("WikittyI18n", "lang");
            boolean bl = result = f1 == (f2 = w2.getFieldAsObject("WikittyI18n", "lang")) || f1 != null && f1.equals(f2);
        }
        if (result) {
            f1 = w1.getFieldAsObject("WikittyI18n", "translations");
            result = f1 == (f2 = w2.getFieldAsObject("WikittyI18n", "translations")) || f1 != null && f1.equals(f2);
        }
        return result;
    }

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return WikittyI18nHelper.hasExtension(wikitty);
    }

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension("WikittyI18n");
    }

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyI18nAbstract.extensions) {
            wikitty.addExtension(ext);
        }
    }

    public static String toString(Wikitty wikitty) {
        return wikitty.toString("WikittyI18n");
    }

    public static void addMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        wikitty.addMetaExtension(WikittyI18nAbstract.extensionWikittyI18n, extension);
    }

    public static boolean hasMetaExtension(WikittyExtension extension, Wikitty wikitty) {
        return wikitty.hasMetaExtension("WikittyI18n", extension.getName());
    }

    public static String getMetaFieldName(WikittyExtension extension, String fieldName) {
        String metaFieldName = WikittyI18nHelper.getMetaFieldName(extension.getName(), fieldName);
        return metaFieldName;
    }

    public static String getMetaFieldName(String extensionName, String fieldName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyI18n", extensionName, fieldName);
        return metaFieldName;
    }

    public static Set<String> getTranslatableValues(String extensionName, Wikitty wikitty) {
        String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "translatableValues");
        Set result = (Set)wikitty.getFqField(fieldName);
        return result;
    }

    public static void setTranslatableValues(String extensionName, Wikitty wikitty, Set<String> translatableValues) {
        WikittyI18nHelper.clearTranslatableValues(extensionName, wikitty);
        WikittyI18nHelper.addAllTranslatableValues(extensionName, wikitty, translatableValues);
    }

    public static void addAllTranslatableValues(String extensionName, Wikitty wikitty, Collection<String> translatableValues) {
        if (translatableValues != null) {
            for (String id : translatableValues) {
                WikittyI18nHelper.addTranslatableValues(extensionName, wikitty, id);
            }
        }
    }

    public static void addTranslatableValues(String extensionName, Wikitty wikitty, String ... element) {
        for (String v : element) {
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "translatableValues");
            wikitty.addToField(fieldName, v);
        }
    }

    public static void removeTranslatableValues(String extensionName, Wikitty wikitty, String ... element) {
        for (String v : element) {
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "translatableValues");
            wikitty.removeFromField(fieldName, v);
        }
    }

    public static void clearTranslatableValues(String extensionName, Wikitty wikitty) {
        String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "translatableValues");
        wikitty.clearField(fieldName);
    }

    public static Set<String> getLang(String extensionName, Wikitty wikitty) {
        String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "lang");
        Set result = (Set)wikitty.getFqField(fieldName);
        return result;
    }

    public static void setLang(String extensionName, Wikitty wikitty, Set<String> lang) {
        WikittyI18nHelper.clearLang(extensionName, wikitty);
        WikittyI18nHelper.addAllLang(extensionName, wikitty, lang);
    }

    public static void addAllLang(String extensionName, Wikitty wikitty, Collection<String> lang) {
        if (lang != null) {
            for (String id : lang) {
                WikittyI18nHelper.addLang(extensionName, wikitty, id);
            }
        }
    }

    public static void addLang(String extensionName, Wikitty wikitty, String ... element) {
        for (String v : element) {
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "lang");
            wikitty.addToField(fieldName, v);
        }
    }

    public static void removeLang(String extensionName, Wikitty wikitty, String ... element) {
        for (String v : element) {
            String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "lang");
            wikitty.removeFromField(fieldName, v);
        }
    }

    public static void clearLang(String extensionName, Wikitty wikitty) {
        String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "lang");
        wikitty.clearField(fieldName);
    }

    public static String getTranslations(String extensionName, Wikitty wikitty) {
        String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "translations");
        String value = (String)wikitty.getFqField(fieldName);
        return value;
    }

    public static String setTranslations(String extensionName, Wikitty wikitty, String translations) {
        String oldValue = WikittyI18nHelper.getTranslations(extensionName, wikitty);
        String fieldName = WikittyI18nHelper.getMetaFieldName(extensionName, "translations");
        wikitty.setFqField(fieldName, translations);
        return oldValue;
    }
}

