/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.tier;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.tier.Shape;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;

public class CartesianShapeFilter
extends Filter {
    private final Shape shape;
    private final String fieldName;

    CartesianShapeFilter(Shape shape, String fieldName) {
        this.shape = shape;
        this.fieldName = fieldName;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        FixedBitSet bits = new FixedBitSet(reader.maxDoc());
        TermDocs termDocs = reader.termDocs();
        List<Double> area = this.shape.getArea();
        int sz = area.size();
        Term term = new Term(this.fieldName);
        for (int i = 0; i < sz; ++i) {
            double boxId = area.get(i);
            termDocs.seek(term.createTerm(NumericUtils.doubleToPrefixCoded((double)boxId)));
            while (termDocs.next()) {
                bits.set(termDocs.doc());
            }
        }
        return bits;
    }
}

