/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.config;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionConverter {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$config$OptionConverter == null ? (class$org$apache$jcs$config$OptionConverter = OptionConverter.class$("org.apache.jcs.config.OptionConverter")) : class$org$apache$jcs$config$OptionConverter));
    static String DELIM_START = "${";
    static char DELIM_STOP = (char)125;
    static int DELIM_START_LEN = 2;
    static int DELIM_STOP_LEN = 1;
    static StringBuffer sbuf = new StringBuffer();
    static /* synthetic */ Class class$org$apache$jcs$config$OptionConverter;

    private OptionConverter() {
    }

    public static String[] concatanateArrays(String[] l, String[] r) {
        int len = l.length + r.length;
        String[] a = new String[len];
        System.arraycopy(l, 0, a, 0, l.length);
        System.arraycopy(r, 0, a, l.length, r.length);
        return a;
    }

    public static String convertSpecialChars(String s) {
        int len = s.length();
        StringBuffer sbuf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            int c;
            if ((c = s.charAt(i++)) == 92) {
                if ((c = s.charAt(i++)) == 110) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 116) {
                    c = 9;
                } else if (c == 102) {
                    c = 12;
                } else if (c == 8) {
                    c = 8;
                } else if (c == 34) {
                    c = 34;
                } else if (c == 39) {
                    c = 39;
                } else if (c == 92) {
                    c = 92;
                }
            }
            sbuf.append((char)c);
        }
        return sbuf.toString();
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e) {
            log.debug((Object)("Was not allowed to read system property \"" + key + "\"."));
            return def;
        }
    }

    public static Object instantiateByKey(Properties props, String key, Class superClass, Object defaultValue) {
        String className = OptionConverter.findAndSubst(key, props);
        if (className == null) {
            if (log.isTraceEnabled()) {
                log.info((Object)("Could not find value for key " + key));
            }
            return defaultValue;
        }
        return OptionConverter.instantiateByClassName(className.trim(), superClass, defaultValue);
    }

    public static boolean toBoolean(String value, boolean dEfault) {
        if (value == null) {
            return dEfault;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static int toInt(String value, int dEfault) {
        if (value != null) {
            String s = value.trim();
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException e) {
                log.error((Object)("[" + s + "] is not in proper int form."));
                e.printStackTrace();
            }
        }
        return dEfault;
    }

    public static long toFileSize(String value, long dEfault) {
        if (value == null) {
            return dEfault;
        }
        String s = value.trim().toUpperCase();
        long multiplier = 1L;
        int index = s.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            s = s.substring(0, index);
        } else {
            index = s.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                s = s.substring(0, index);
            } else {
                index = s.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    s = s.substring(0, index);
                }
            }
        }
        if (s != null) {
            try {
                return Long.valueOf(s) * multiplier;
            }
            catch (NumberFormatException e) {
                log.error((Object)("[" + s + "] is not in proper int form"));
                log.error((Object)("[" + value + "] not in expected format"), (Throwable)e);
            }
        }
        return dEfault;
    }

    public static String findAndSubst(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Bad option value [" + value + "]"), (Throwable)e);
            return value;
        }
    }

    public static Object instantiateByClassName(String className, Class superClass, Object defaultValue) {
        if (className != null) {
            try {
                Class<?> classObj = Class.forName(className);
                if (!superClass.isAssignableFrom(classObj)) {
                    log.error((Object)("A \"" + className + "\" object is not assignable to a \"" + superClass.getName() + "\" variable."));
                    return defaultValue;
                }
                return classObj.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Could not instantiate class [" + className + "]"), (Throwable)e);
            }
        }
        return defaultValue;
    }

    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        sbuf.setLength(0);
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(DELIM_STOP, j);
            if (k == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j + '.');
            }
            String key = val.substring(j += DELIM_START_LEN, k);
            String replacement = OptionConverter.getSystemProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                sbuf.append(replacement);
            }
            i = k + DELIM_STOP_LEN;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

