/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.RangeIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeTable
extends Table {
    public static final String NAME = "SYSTEM_RANGE";
    private Expression min;
    private Expression max;
    private boolean optimized;

    public RangeTable(Schema schema, Expression expression, Expression expression2) throws SQLException {
        super(schema, 0, NAME, true, true);
        Column[] columnArray = new Column[]{new Column("X", 5)};
        this.min = expression;
        this.max = expression2;
        this.setColumns(columnArray);
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getSQL() {
        return "SYSTEM_RANGE(" + this.min.getSQL() + ", " + this.max.getSQL() + ")";
    }

    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        throw Message.getUnsupportedException(NAME);
    }

    @Override
    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException(NAME);
    }

    @Override
    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException(NAME);
    }

    @Override
    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException(NAME);
    }

    @Override
    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException(NAME);
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public long getRowCount(Session session) throws SQLException {
        return Math.max(0L, this.getMax(session) - this.getMin(session) + 1L);
    }

    @Override
    public String getTableType() {
        throw Message.throwInternalError();
    }

    @Override
    public Index getScanIndex(Session session) {
        return new RangeIndex(this, IndexColumn.wrap(this.columns));
    }

    public long getMin(Session session) throws SQLException {
        this.optimize(session);
        return this.min.getValue(session).getLong();
    }

    public long getMax(Session session) throws SQLException {
        this.optimize(session);
        return this.max.getValue(session).getLong();
    }

    private void optimize(Session session) throws SQLException {
        if (!this.optimized) {
            this.min = this.min.optimize(session);
            this.max = this.max.optimize(session);
            this.optimized = true;
        }
    }

    @Override
    public ObjectArray<Index> getIndexes() {
        return null;
    }

    @Override
    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException(NAME);
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

