/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.search.function.ValueSourceScorer;

public abstract class StringIndexDocValues
extends DocValues {
    protected final FieldCache.StringIndex index;
    protected final int[] order;
    protected final String[] lookup;
    protected final ValueSource vs;

    public StringIndexDocValues(ValueSource vs, IndexReader reader, String field) throws IOException {
        try {
            this.index = FieldCache.DEFAULT.getStringIndex(reader, field);
        }
        catch (RuntimeException e) {
            throw new StringIndexException(field, e);
        }
        this.order = this.index.order;
        this.lookup = this.index.lookup;
        this.vs = vs;
    }

    protected abstract String toTerm(String var1);

    public ValueSourceScorer getRangeScorer(IndexReader reader, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        lowerVal = lowerVal == null ? null : this.toTerm(lowerVal);
        upperVal = upperVal == null ? null : this.toTerm(upperVal);
        int lower = Integer.MIN_VALUE;
        if (lowerVal != null) {
            lower = this.index.binarySearchLookup(lowerVal);
            if (lower < 0) {
                lower = -lower - 1;
            } else if (!includeLower) {
                ++lower;
            }
        }
        int upper = Integer.MAX_VALUE;
        if (upperVal != null) {
            upper = this.index.binarySearchLookup(upperVal);
            if (upper < 0) {
                upper = -upper - 2;
            } else if (!includeUpper) {
                --upper;
            }
        }
        final int ll = lower;
        final int uu = upper;
        return new ValueSourceScorer(reader, this){

            public boolean matchesValue(int doc) {
                int ord = StringIndexDocValues.this.order[doc];
                return ord >= ll && ord <= uu;
            }
        };
    }

    public String toString(int doc) {
        return this.vs.description() + '=' + this.strVal(doc);
    }

    public static final class StringIndexException
    extends RuntimeException {
        public StringIndexException(String fieldName, RuntimeException cause) {
            super("Can't initialize StringIndex to generate (function) DocValues for field: " + fieldName, cause);
        }
    }
}

