/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.threadpool;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.props.PropertyLoader;
import org.apache.jcs.utils.threadpool.PoolConfiguration;
import org.apache.jcs.utils.threadpool.ThreadPool;

public class ThreadPoolManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$threadpool$ThreadPoolManager == null ? (class$org$apache$jcs$utils$threadpool$ThreadPoolManager = ThreadPoolManager.class$("org.apache.jcs.utils.threadpool.ThreadPoolManager")) : class$org$apache$jcs$utils$threadpool$ThreadPoolManager));
    private static boolean useBoundary_DEFAULT = true;
    private static int boundarySize_DEFAULT = 2000;
    private static int maximumPoolSize_DEFAULT = 150;
    private static int minimumPoolSize_DEFAULT = 4;
    private static int keepAliveTime_DEFAULT = 300000;
    private static String whenBlockedPolicy_DEFAULT = "RUN";
    private static int startUpSize_DEFAULT = 4;
    private static PoolConfiguration defaultConfig;
    private static String propsFileName;
    private static String PROP_NAME_ROOT;
    private static String DEFAULT_PROP_NAME_ROOT;
    private static Properties props;
    private static HashMap pools;
    private static ThreadPoolManager INSTANCE;
    static /* synthetic */ Class class$org$apache$jcs$utils$threadpool$ThreadPoolManager;

    private ThreadPoolManager() {
        this.configure();
    }

    private ThreadPool createPool(PoolConfiguration config) {
        PooledExecutor pool = null;
        LinkedQueue queue = null;
        if (config.isUseBoundary()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating a Bounded Buffer to use for the pool");
            }
            queue = new BoundedBuffer(config.getBoundarySize());
            pool = new PooledExecutor((Channel)queue, config.getMaximumPoolSize());
            pool.setThreadFactory((ThreadFactory)new MyThreadFactory());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating a non bounded Linked Queue to use for the pool");
            }
            queue = new LinkedQueue();
            pool = new PooledExecutor((Channel)queue, config.getMaximumPoolSize());
        }
        pool.setMinimumPoolSize(config.getMinimumPoolSize());
        pool.setKeepAliveTime((long)config.getKeepAliveTime());
        if (config.getWhenBlockedPolicy().equals("ABORT")) {
            pool.abortWhenBlocked();
        } else if (config.getWhenBlockedPolicy().equals("RUN")) {
            pool.runWhenBlocked();
        } else if (config.getWhenBlockedPolicy().equals("WAIT")) {
            pool.waitWhenBlocked();
        } else if (config.getWhenBlockedPolicy().equals("ABORT")) {
            pool.abortWhenBlocked();
        } else if (config.getWhenBlockedPolicy().equals("DISCARDOLDEST")) {
            pool.discardOldestWhenBlocked();
        }
        pool.createThreads(config.getStartUpSize());
        return new ThreadPool(pool, (Channel)queue);
    }

    public static synchronized ThreadPoolManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPoolManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getPool(String name) {
        ThreadPool pool = null;
        HashMap hashMap = pools;
        synchronized (hashMap) {
            pool = (ThreadPool)pools.get(name);
            if (pool == null) {
                PoolConfiguration config;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating pool for name [" + name + "]"));
                }
                if ((pool = this.createPool(config = this.loadConfig(PROP_NAME_ROOT + "." + name))) != null) {
                    pools.put(name, pool);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PoolName = " + this.getPoolNames()));
                }
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getPoolNames() {
        ArrayList poolNames = new ArrayList();
        HashMap hashMap = pools;
        synchronized (hashMap) {
            Set names = pools.keySet();
            Iterator it = names.iterator();
            while (it.hasNext()) {
                poolNames.add(it.next());
            }
        }
        return poolNames;
    }

    public static void setPropsFileName(String propsFileName) {
        ThreadPoolManager.propsFileName = propsFileName;
    }

    public static String getPropsFileName() {
        return propsFileName;
    }

    public static void setProps(Properties props) {
        ThreadPoolManager.props = props;
    }

    public static Properties getProps() {
        return props;
    }

    protected void configure() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing ThreadPoolManager");
        }
        if (props == null) {
            try {
                props = PropertyLoader.loadProperties(propsFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File contained " + props.size() + " properties"));
                }
            }
            catch (Exception e) {
                log.error((Object)("Problem loading properties. propsFileName [" + propsFileName + "]"), (Throwable)e);
            }
        }
        if (props == null) {
            log.warn((Object)"No configuration settings found.  Using hardcoded default values for all pools.");
            props = new Properties();
        }
        defaultConfig = new PoolConfiguration(useBoundary_DEFAULT, boundarySize_DEFAULT, maximumPoolSize_DEFAULT, minimumPoolSize_DEFAULT, keepAliveTime_DEFAULT, whenBlockedPolicy_DEFAULT, startUpSize_DEFAULT);
        defaultConfig = this.loadConfig(DEFAULT_PROP_NAME_ROOT);
    }

    protected PoolConfiguration loadConfig(String root) {
        PoolConfiguration config = (PoolConfiguration)defaultConfig.clone();
        if (props.containsKey(root + ".useBoundary")) {
            try {
                config.setUseBoundary(Boolean.valueOf((String)props.get(root + ".useBoundary")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"useBoundary not a boolean.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".boundarySize")) {
            try {
                config.setBoundarySize(Integer.parseInt((String)props.get(root + ".boundarySize")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"boundarySize not a number.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".maximumPoolSize")) {
            try {
                config.setMaximumPoolSize(Integer.parseInt((String)props.get(root + ".maximumPoolSize")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"maximumPoolSize not a number.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".minimumPoolSize")) {
            try {
                config.setMinimumPoolSize(Integer.parseInt((String)props.get(root + ".minimumPoolSize")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"minimumPoolSize not a number.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".keepAliveTime")) {
            try {
                config.setKeepAliveTime(Integer.parseInt((String)props.get(root + ".keepAliveTime")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"keepAliveTime not a number.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".whenBlockedPolicy")) {
            config.setWhenBlockedPolicy((String)props.get(root + ".whenBlockedPolicy"));
        }
        if (props.containsKey(root + ".startUpSize")) {
            try {
                config.setStartUpSize(Integer.parseInt((String)props.get(root + ".startUpSize")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"startUpSize not a number.", (Throwable)nfe);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(root + " PoolConfiguration = " + config));
        }
        return config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        propsFileName = "cache.ccf";
        PROP_NAME_ROOT = "thread_pool";
        DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
        props = null;
        pools = new HashMap();
        INSTANCE = null;
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            t.setDaemon(true);
            return t;
        }
    }
}

