/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import org.apache.lucene.spatial.DistanceUtils;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.MultiValueSource;
import org.apache.solr.search.function.distance.VectorDistanceFunction;

public class SquaredEuclideanFunction
extends VectorDistanceFunction {
    protected String name = "sqedist";

    public SquaredEuclideanFunction(MultiValueSource source1, MultiValueSource source2) {
        super(-1.0f, source1, source2);
    }

    protected String name() {
        return this.name;
    }

    protected double distance(int doc, DocValues dv1, DocValues dv2) {
        double[] vals1 = new double[this.source1.dimension()];
        double[] vals2 = new double[this.source1.dimension()];
        dv1.doubleVal(doc, vals1);
        dv2.doubleVal(doc, vals2);
        return DistanceUtils.squaredEuclideanDistance((double[])vals1, (double[])vals2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SquaredEuclideanFunction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SquaredEuclideanFunction that = (SquaredEuclideanFunction)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

