/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.spatial.DistanceUtils;
import org.apache.lucene.spatial.geohash.GeoHashUtils;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class GeohashHaversineFunction
extends ValueSource {
    private ValueSource geoHash1;
    private ValueSource geoHash2;
    private double radius;

    public GeohashHaversineFunction(ValueSource geoHash1, ValueSource geoHash2, double radius) {
        this.geoHash1 = geoHash1;
        this.geoHash2 = geoHash2;
        this.radius = radius;
    }

    protected String name() {
        return "ghhsin";
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final DocValues gh1DV = this.geoHash1.getValues(context, reader);
        final DocValues gh2DV = this.geoHash2.getValues(context, reader);
        return new DocValues(){

            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            public int intVal(int doc) {
                return (int)this.doubleVal(doc);
            }

            public long longVal(int doc) {
                return (long)this.doubleVal(doc);
            }

            public double doubleVal(int doc) {
                return GeohashHaversineFunction.this.distance(doc, gh1DV, gh2DV);
            }

            public String strVal(int doc) {
                return Double.toString(this.doubleVal(doc));
            }

            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(GeohashHaversineFunction.this.name()).append('(');
                sb.append(gh1DV.toString(doc)).append(',').append(gh2DV.toString(doc));
                sb.append(')');
                return sb.toString();
            }
        };
    }

    protected double distance(int doc, DocValues gh1DV, DocValues gh2DV) {
        double result = 0.0;
        String h1 = gh1DV.strVal(doc);
        String h2 = gh2DV.strVal(doc);
        if (h1 != null && h2 != null && !h1.equals(h2)) {
            double[] h1Pair = GeoHashUtils.decode((String)h1);
            double[] h2Pair = GeoHashUtils.decode((String)h2);
            result = DistanceUtils.haversine((double)Math.toRadians(h1Pair[0]), (double)Math.toRadians(h1Pair[1]), (double)Math.toRadians(h2Pair[0]), (double)Math.toRadians(h2Pair[1]), (double)this.radius);
        } else if (h1 == null || h2 == null) {
            result = Double.MAX_VALUE;
        }
        return result;
    }

    public void createWeight(Map context, Searcher searcher) throws IOException {
        this.geoHash1.createWeight(context, searcher);
        this.geoHash2.createWeight(context, searcher);
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        GeohashHaversineFunction other = (GeohashHaversineFunction)o;
        return this.name().equals(other.name()) && this.geoHash1.equals(other.geoHash1) && this.geoHash2.equals(other.geoHash2) && this.radius == other.radius;
    }

    public int hashCode() {
        int result = this.geoHash1.hashCode();
        result = 31 * result + this.geoHash2.hashCode();
        result = 31 * result + this.name().hashCode();
        long temp = Double.doubleToRawLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        sb.append(this.geoHash1).append(',').append(this.geoHash2);
        sb.append(')');
        return sb.toString();
    }
}

