/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.ConstNumberSource;
import org.apache.solr.search.function.DocValues;

public class DoubleConstValueSource
extends ConstNumberSource {
    final double constant;
    private final float fv;
    private final long lv;

    public DoubleConstValueSource(double constant) {
        this.constant = constant;
        this.fv = (float)constant;
        this.lv = (long)constant;
    }

    public String description() {
        return "const(" + this.constant + ")";
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new DocValues(){

            public float floatVal(int doc) {
                return DoubleConstValueSource.this.fv;
            }

            public int intVal(int doc) {
                return (int)DoubleConstValueSource.this.lv;
            }

            public long longVal(int doc) {
                return DoubleConstValueSource.this.lv;
            }

            public double doubleVal(int doc) {
                return DoubleConstValueSource.this.constant;
            }

            public String strVal(int doc) {
                return Double.toString(DoubleConstValueSource.this.constant);
            }

            public String toString(int doc) {
                return DoubleConstValueSource.this.description();
            }
        };
    }

    public int hashCode() {
        long bits = Double.doubleToRawLongBits(this.constant);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoubleConstValueSource)) {
            return false;
        }
        DoubleConstValueSource other = (DoubleConstValueSource)o;
        return this.constant == other.constant;
    }

    public int getInt() {
        return (int)this.lv;
    }

    public long getLong() {
        return this.lv;
    }

    public float getFloat() {
        return this.fv;
    }

    public double getDouble() {
        return this.constant;
    }

    public Number getNumber() {
        return this.constant;
    }
}

