/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AgentSearchResults.java 235 2011-09-21 10:34:48Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.6/refcomp-client/src/main/java/fr/inra/refcomp/client/user/AgentSearchResults.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import fr.inra.refcomp.client.RefComp;
import fr.inra.refcomp.client.constants.CSS;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.constants.Unauthorized;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Agent;
import fr.inra.refcomp.entities.Cati;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.EntitiesList;
import fr.inra.refcomp.entities.Skill;
import fr.inra.refcomp.entities.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuiton.web.gwt.comparable.ComparableAnchor;
import org.nuiton.web.gwt.misc.LoaderNotification;
import org.nuiton.web.gwt.table.DefaultTableModel;
import org.nuiton.web.gwt.table.SortableFlexTableWithModel;
import org.nuiton.web.gwt.table.SortableTableModel;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 12/01/11
 */
public class AgentSearchResults extends Composite {

    public static final int NAME_COL = 0;
    public static int DEPARTMENT_COL = 1;
    public static int UNIT_COL = 2;
    public static int CATI_COL = 3;
    public static int CODE_COL = 4;

    @UiTemplate("SearchResults.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, AgentSearchResults> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    SortableFlexTableWithModel resultsTable;

    @UiField
    InlineLabel searchField;

    protected DefaultTableModel model;

    public AgentSearchResults() {
        initWidget(binder.createAndBindUi(this));

        SortableTableModel sortableModel = new SortableTableModel(model);

        resultsTable.setModel(sortableModel);
    }

    public AgentSearchResults(final String searchString, final EntitiesList results) {
        initWidget(binder.createAndBindUi(this));

        StorageServiceAsync service = GWT.create(StorageService.class);

        service.isLoggedIn(new AsyncCallback<Boolean>() {
            @Override
            public void onFailure(Throwable throwable) {
                RefComp.logOut();
                RootPanel content = RootPanel.get("content");
                content.clear();
                content.add(new Unauthorized());
                LoaderNotification.closeLoader();
            }

            @Override
            public void onSuccess(Boolean isLoggedIn) {
                if (!isLoggedIn) {
                    RefComp.logOut();
                    RootPanel content = RootPanel.get("content");
                    content.clear();
                    content.add(new Unauthorized());
                    LoaderNotification.closeLoader();
                } else {
                    Object[][] data = new Object[][]{};

                    RefcompMessages messages = GWT.create(RefcompMessages.class);
                    String[] columns = {
                            messages.agentName(),
                            messages.department(),
                            messages.unit(),
                            messages.cati(),
                            messages.jobTypeReference()};

                    model = new DefaultTableModel(data, columns);

                    SortableTableModel sortableModel = new SortableTableModel(model);

                    if (searchString != null) {
                        searchField.setText(URL.decodeQueryString(searchString));
                    }

                    Map<BusinessEntity,Skill> agents = results.getEntities();

                    if (agents.size() > 0) {
                        for (Map.Entry<BusinessEntity, Skill> entry : agents.entrySet()) {
                            Agent agent = (Agent) entry.getKey();
                            addRow(agent, results);
                        }

                        resultsTable.setModel(sortableModel);

                        for (int i = 0; i < columns.length; i++) {
                            resultsTable.setText(0, i, columns[i]);
                            resultsTable.getCellFormatter().setStyleName(0, i, CSS.SORTABLE);
                        }

                    } else {
                        resultsTable.setVisible(false);
                    }

                    sortableModel.setSortedColumn(NAME_COL, SortableTableModel.ASC);

                    LoaderNotification.closeLoader();
                }
            }
        });
    }

    protected void addRow(final Agent agent, EntitiesList dependencies) {
        int columnCount = model.getColumnCount();

        Object[] row = new Object[columnCount];

        // If the agent is null, it means it is an old
        // damaged data. Do not display it.
        if (agent == null) {
            return;
        }

        //Name with link to the agent skills list
        ComparableAnchor nameLink = new ComparableAnchor(agent.getFirstName() + " " +
                agent.getLastName());
        nameLink.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                History.newItem("agentSheet?agent=" + agent.getWikittyId());
            }
        });
        row[NAME_COL] = nameLink;

        //Department
        Department department = (Department) dependencies.getDependency(
                agent.getDepartment());
        if (department != null) {
            String text = department.getName();
            row[DEPARTMENT_COL] = text;
        }

        //Units
        List<String> units = new ArrayList<String>(agent.getUnit());
        String displayedUnits = "";
        for (String id:units) {
            Unit unit = (Unit) dependencies.getDependency(id);
            if (unit != null) {
                String text = unit.getName();
                displayedUnits += text +"\n";
            }
        }
        row[UNIT_COL] = displayedUnits;

        //Cati
        Cati cati = (Cati) dependencies.getDependency(agent.getCati());
        if (cati != null) {
            String text = cati.getName();
            row[CATI_COL] = text;
        }

        //comment
        row[CODE_COL] = agent.getJobTypeReference();

        model.addRow(row);
    }

}
