/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: Menu.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/constants/Menu.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.constants;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import fr.inra.refcomp.client.Login;
import fr.inra.refcomp.client.admin.importexport.ImportExport;
import fr.inra.refcomp.client.admin.skills.PrintSkills;
import fr.inra.refcomp.client.user.MyAccount;
import fr.inra.refcomp.client.user.Search;
import fr.inra.refcomp.client.RefComp;
import fr.inra.refcomp.client.admin.cati.AdminCati;
import fr.inra.refcomp.client.admin.frequencies.AdminFrequencies;
import fr.inra.refcomp.client.admin.departments.AdminDepartments;
import fr.inra.refcomp.client.admin.skills.AdminSkills;
import fr.inra.refcomp.client.admin.units.AdminUnits;
import fr.inra.refcomp.client.admin.users.AdminUsers;
import fr.inra.refcomp.client.Home;
import fr.inra.refcomp.client.agent.SkillsTableScreen;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 10 nov. 2010
 */
public class Menu extends Composite {

    private static final StorageServiceAsync service = GWT.create(StorageService.class);

    @UiTemplate("Menu.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, Menu> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    public Menu() {
        initWidget(binder.createAndBindUi(this));
        refresh();
    }

    @UiField
    static Anchor login;

    @UiField
    static Anchor search;

    @UiField
    static Anchor mySkills;

    @UiField
    static Anchor myAccount;

    @UiField
    static Anchor adminSkills;

    @UiField
    static Anchor adminFrequencies;

    @UiField
    static Anchor adminCati;

    @UiField
    static Anchor adminDepartments;

    @UiField
    static Anchor adminUnits;

    @UiField
    static Anchor adminUsers;

    @UiField
    static Anchor adminPrintSkills;

    @UiField
    static Anchor adminImportExport;

    @UiHandler("home")
    void doClickHome(ClickEvent event) {
        RootPanel content = RootPanel.get("content");
        content.clear();
        content.add(new Home());
        History.newItem("home");
    }

    @UiHandler("login")
    public static void doClickLogout(ClickEvent event) {

        if (RefComp.isLoggedIn()) {

            RootPanel content = RootPanel.get("content");
            content.clear();
            content.add(new Home());
            History.newItem("home");


            service.logout(new AsyncCallback<Void>() {
                @Override
                public void onFailure(Throwable caught) {
                    RefComp.logOut();
                    logOut();
                }

                @Override
                public void onSuccess(Void result) {
                    RefComp.logOut();
                    logOut();
                }
            });

        } else {
            RootPanel content = RootPanel.get("content");
            content.clear();
            content.add(new Login());
            History.newItem("login");
        }
    }

    @UiHandler("search")
    public static void search(ClickEvent event) {
        RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new Search());
        History.newItem("search");
    }

    @UiHandler("mySkills")
    void doClickMySkills(ClickEvent event) {

        RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new SkillsTableScreen(true));
        History.newItem("mySkills");
    }

    @UiHandler("myAccount")
    void doClickMyAccount(ClickEvent event) {

        RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new MyAccount());
        History.newItem("myAccount");
    }

    @UiHandler("adminFrequencies")
    void doClickAdminFrequencies(ClickEvent event) {

        RootPanel content = RootPanel.get("content");
        
        content.clear();

        content.add(new AdminFrequencies());
        History.newItem("adminFrequencies");
    }

    @UiHandler("adminSkills")
    void doClickAdminSkills(ClickEvent event) {

        RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new AdminSkills());
        History.newItem("adminSkills");
    }

    @UiHandler("adminCati")
    void doClickAdminCati(ClickEvent event) {

        RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new AdminCati());
        History.newItem("adminCati");
    }

    @UiHandler("adminDepartments")
    void doClickAdminDepartments(ClickEvent event) {

        RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new AdminDepartments());
        History.newItem("adminDepartments");
    }

    @UiHandler("adminUnits")
    void doClickAdminUnits(ClickEvent event) {

        RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new AdminUnits());
        History.newItem("adminUnits");
    }

    @UiHandler("adminUsers")
    void doClickAdminUsers(ClickEvent event) {

        final RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new AdminUsers());
        History.newItem("adminUsers");

    }

    @UiHandler("adminPrintSkills")
    void doClickAdminPrintSkills(ClickEvent event) {

        final RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new PrintSkills());
        History.newItem("adminPrintSkills");

    }

    @UiHandler("adminImportExport")
    void doClickAdminImportExport(ClickEvent event) {

        final RootPanel content = RootPanel.get("content");

        content.clear();

        content.add(new ImportExport());
        History.newItem("adminImportExport");

    }

    public static void logIn(){
        login.setText("Logout");
        refresh();
    }

    public static void logOut() {
        login.setText("Login");
        refresh();

    }

    protected static void refresh() {
        service.isLoggedIn(new AsyncCallback<Boolean>() {
            @Override
            public void onFailure(Throwable caught) {
                cleanMenu();
            }

            @Override
            public void onSuccess(Boolean result) {
                if (result) {
                    cleanMenu();
                    userMenu();
                    service.isAgent(new AsyncCallback<Boolean>() {
                        @Override
                        public void onFailure(Throwable caught) {
                            cleanMenu();
                        }

                        @Override
                        public void onSuccess(Boolean result) {
                            if (result){
                                agentMenu();
                            }
                        }
                    });

                    service.isAdmin(new AsyncCallback<Boolean>() {
                        @Override
                        public void onFailure(Throwable caught) {
                            cleanMenu();
                        }

                        @Override
                        public void onSuccess(Boolean result) {
                            if (result) {
                                adminMenu();
                            }
                        }
                    });
                } else {
                    cleanMenu();
                }
            }
        });
    }

    protected static void cleanMenu() {
        mySkills.setVisible(false);
        myAccount.setVisible(false);
        search.setVisible(false);
        adminSkills.setVisible(false);
        adminFrequencies.setVisible(false);
        adminCati.setVisible(false);
        adminDepartments.setVisible(false);
        adminUnits.setVisible(false);
        adminUsers.setVisible(false);
        adminPrintSkills.setVisible(false);
        adminImportExport.setVisible(false);
    }

    protected static void adminMenu() {
        adminSkills.setVisible(true);
        adminFrequencies.setVisible(true);
        adminCati.setVisible(true);
        adminDepartments.setVisible(true);
        adminUnits.setVisible(true);
        adminUsers.setVisible(true);
        adminPrintSkills.setVisible(true);
        adminImportExport.setVisible(true);
    }

    protected static void agentMenu() {
        userMenu();
        mySkills.setVisible(true);
    }

    protected static void userMenu() {
        search.setVisible(true);
        myAccount.setVisible(true);
    }

}
