/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.actions;

import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCache;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCaches;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RenameSpeciesBatchAction
extends LongActionSupport<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    protected Species selectedSpecies;

    public RenameSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport = ((SpeciesBatchUIModel)this.getModel()).getSpeciesOrBenthosBatchUISupport();
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        int selectedRowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
        List referents = this.getDataContext().getReferentSpecies();
        Map referentsById = Speciess.splitReferenceSpeciesByReferenceTaxonId((Iterable)referents);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)((SpeciesBatchUIHandler)this.handler).getModel();
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Serializable categoryValue = firstSampleCategory.getCategoryValue();
        Collection speciesUsedForFirstCategory = model.getSpeciesUsed().get((Object)((CaracteristicQualitativeValue)categoryValue));
        ArrayList<Species> speciesList = new ArrayList<Species>(speciesOrBenthosBatchUISupport.getReferentSpeciesWithSurveyCode(true));
        speciesList.removeAll(speciesUsedForFirstCategory);
        ArrayList<Species> allSpeciesList = new ArrayList<Species>(this.getDataContext().getSpecies());
        allSpeciesList.removeAll(speciesUsedForFirstCategory);
        allSpeciesList.removeAll(speciesOrBenthosBatchUISupport.getReferentOtherSpeciesWithSurveyCode(true));
        Multimap speciesByReferent = Speciess.splitByReferenceTaxonId(allSpeciesList);
        for (Species species : speciesUsedForFirstCategory) {
            Collection synonyms = speciesByReferent.get((Object)String.valueOf(species.getReferenceTaxonId()));
            allSpeciesList.removeAll(synonyms);
        }
        if (row.containsIndividualObservations(true)) {
            Species s;
            Species species;
            TaxonCache taxonCache = TaxonCaches.createSpeciesCacheWithoutVernacularCode((TuttiPersistence)this.getContext().getPersistenceService(), (TuttiProtocol)this.getDataContext().getProtocol());
            species = row.getSpecies();
            String lengthStepPmfmId = taxonCache.getLengthStepPmfmId(species);
            Iterator i = speciesList.iterator();
            while (i.hasNext()) {
                s = (Species)i.next();
                if (StringUtils.equals((CharSequence)lengthStepPmfmId, (CharSequence)taxonCache.getLengthStepPmfmId(s))) continue;
                i.remove();
            }
            i = allSpeciesList.iterator();
            while (i.hasNext()) {
                s = (Species)i.next();
                if (StringUtils.equals((CharSequence)lengthStepPmfmId, (CharSequence)taxonCache.getLengthStepPmfmId(s))) continue;
                i.remove();
            }
        }
        this.selectedSpecies = this.openAddSpeciesDialog(I18n.t((String)"tutti.selectSpecies.title", (Object[])new Object[0]), allSpeciesList, speciesList);
        if (this.selectedSpecies != null && !this.selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = this.decorate(this.selectedSpecies, "fromProtocol");
            String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
            this.selectedSpecies = (Species)referentsById.get(taxonId);
            String decoratedReferent = this.decorate(this.selectedSpecies, "fromProtocol");
            this.sendMessage(I18n.t((String)"tutti.flash.info.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        }
        return result &= this.selectedSpecies != null;
    }

    public void releaseAction() {
        this.selectedSpecies = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        int selectedRowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        persistenceService.changeSpeciesBatchSpecies(row.getIdAsInt(), this.selectedSpecies);
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Serializable categoryValue = firstSampleCategory.getCategoryValue();
        Collection speciesUsed = ((SpeciesBatchUIModel)this.getModel()).getSpeciesUsed().get((Object)((CaracteristicQualitativeValue)categoryValue));
        speciesUsed.remove(row.getSpecies());
        this.changeChildrenSpecies(row, this.selectedSpecies);
        speciesUsed.add(this.selectedSpecies);
        this.setIndividualObservationSpecies(row, this.selectedSpecies);
    }

    protected void setIndividualObservationSpecies(SpeciesBatchRowModel row, Species species) {
        List<SpeciesBatchRowModel> children;
        boolean mustSave = false;
        for (IndividualObservationBatchRowModel o : row.getIndividualObservation()) {
            o.setSpecies(species);
            mustSave = true;
        }
        if (mustSave) {
            ((SpeciesBatchUIHandler)this.handler).saveRow(row);
        }
        if ((children = row.getChildBatch()) != null) {
            for (SpeciesBatchRowModel c : children) {
                this.setIndividualObservationSpecies(c, species);
            }
        }
    }

    protected void changeChildrenSpecies(SpeciesBatchRowModel row, Species species) {
        row.setSpecies(species);
        List<SpeciesBatchRowModel> children = row.getChildBatch();
        if (children != null) {
            for (SpeciesBatchRowModel child : children) {
                this.changeChildrenSpecies(child, species);
            }
        }
    }
}

