/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXOperation;
import com.intel.bluetooth.obex.OBEXOperationInputStream;
import com.intel.bluetooth.obex.OBEXOperationOutputStream;
import com.intel.bluetooth.obex.OBEXServerSessionImpl;
import com.intel.bluetooth.obex.OBEXSessionBase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.HeaderSet;
import javax.obex.Operation;

abstract class OBEXServerOperation
implements Operation,
OBEXOperation {
    protected OBEXServerSessionImpl session;
    protected HeaderSet receivedHeaders;
    protected OBEXHeaderSetImpl sendHeaders;
    protected boolean isClosed = false;
    protected boolean isAborted = false;
    protected boolean finalPacketReceived = false;
    protected boolean requestEnded = false;
    protected boolean errorReceived = false;
    protected boolean incommingDataReceived = false;
    protected OBEXOperationOutputStream outputStream;
    protected boolean outputStreamOpened = false;
    protected OBEXOperationInputStream inputStream;
    protected boolean inputStreamOpened = false;

    protected OBEXServerOperation(OBEXServerSessionImpl session, OBEXHeaderSetImpl receivedHeaders) throws IOException {
        this.session = session;
        this.receivedHeaders = receivedHeaders;
        if (receivedHeaders.hasAuthenticationChallenge()) {
            this.sendHeaders = OBEXSessionBase.createOBEXHeaderSetImpl();
            this.session.handleAuthenticationChallenge(receivedHeaders, this.sendHeaders);
        }
    }

    boolean exchangeRequestPhasePackets() throws IOException {
        this.session.writePacket(144, null);
        return this.readRequestPacket();
    }

    protected abstract boolean readRequestPacket() throws IOException;

    void writeResponse(int responseCode) throws IOException {
        DebugLog.debug0x("server operation reply final", responseCode);
        this.session.writePacket(responseCode, this.sendHeaders);
        this.sendHeaders = null;
        if (responseCode == 160) {
            while (!this.finalPacketReceived && !this.session.isClosed()) {
                DebugLog.debug("server waits to receive final packet");
                this.readRequestPacket();
                if (this.errorReceived) continue;
                this.session.writePacket(responseCode, null);
            }
        } else {
            DebugLog.debug("sent final reply");
        }
    }

    protected void processIncommingData(HeaderSet dataHeaders, boolean eof) throws IOException {
        if (this.inputStream == null) {
            return;
        }
        byte[] data = (byte[])dataHeaders.getHeader(72);
        if (data == null && (data = (byte[])dataHeaders.getHeader(73)) != null) {
            eof = true;
        }
        if (data != null) {
            this.incommingDataReceived = true;
            DebugLog.debug("server received Data eof: " + eof + " len:", data.length);
            this.inputStream.appendData(data, eof);
        } else if (eof) {
            this.inputStream.appendData(null, eof);
        }
    }

    public void abort() throws IOException {
        throw new IOException("Can't abort server operation");
    }

    public HeaderSet getReceivedHeaders() throws IOException {
        return OBEXHeaderSetImpl.cloneHeaders(this.receivedHeaders);
    }

    public int getResponseCode() throws IOException {
        throw new IOException("Operation object was created by an OBEX server");
    }

    public void sendHeaders(HeaderSet headers) throws IOException {
        if (headers == null) {
            throw new NullPointerException("headers are null");
        }
        OBEXHeaderSetImpl.validateCreatedHeaderSet(headers);
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        if (this.sendHeaders != null) {
            OBEXHeaderSetImpl.appendHeaders(this.sendHeaders, headers);
        } else {
            this.sendHeaders = (OBEXHeaderSetImpl)headers;
        }
    }

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        Long len;
        try {
            len = (Long)this.receivedHeaders.getHeader(195);
        }
        catch (IOException e) {
            return -1L;
        }
        if (len == null) {
            return -1L;
        }
        return len;
    }

    public String getType() {
        try {
            return (String)this.receivedHeaders.getHeader(66);
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isIncommingDataReceived() {
        return this.incommingDataReceived;
    }

    public boolean isErrorReceived() {
        return this.errorReceived;
    }

    public abstract /* synthetic */ InputStream openInputStream() throws IOException;

    public abstract /* synthetic */ OutputStream openOutputStream() throws IOException;
}

