/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.zones.tree;

import com.google.common.collect.ImmutableMap;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.StrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.SubStrataNode;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.ZoneEditorNodeSupport;
import fr.ifremer.tutti.ui.swing.content.protocol.zones.tree.node.ZoneNode;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ZoneEditorTreeModelSupport
extends DefaultTreeModel {
    private static final Log log = LogFactory.getLog(ZoneEditorTreeModelSupport.class);
    private boolean creatingModel;
    private ImmutableMap<String, String> locationLabelCache;
    private final Set<TreeModelEvent> nodeInserted = new LinkedHashSet<TreeModelEvent>();

    public ZoneEditorTreeModelSupport(String rootLabel) {
        super(new ZoneNode("No fucking way! I am not a zone", rootLabel));
    }

    public void setCreatingModel(boolean creatingModel) {
        this.creatingModel = creatingModel;
        if (creatingModel) {
            this.nodeInserted.clear();
        } else {
            try {
                this.nodeInserted.forEach(treeModelEvent -> this.fireTreeNodesInserted(treeModelEvent.getSource(), treeModelEvent.getPath(), treeModelEvent.getChildIndices(), treeModelEvent.getChildren()));
            }
            finally {
                this.nodeInserted.clear();
            }
        }
    }

    public void addNode(ZoneEditorNodeSupport parent, ZoneEditorNodeSupport newChild) {
        int index = parent.getFutureNodePosition(newChild);
        this.insertNodeInto(newChild, parent, index);
    }

    @Override
    public ZoneNode getRoot() {
        return (ZoneNode)super.getRoot();
    }

    @Override
    protected void fireTreeNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.creatingModel) {
            return;
        }
        super.fireTreeNodesChanged(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.creatingModel) {
            this.nodeInserted.add(new TreeModelEvent(source, path, childIndices, children));
            return;
        }
        super.fireTreeNodesInserted(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.creatingModel) {
            return;
        }
        super.fireTreeNodesRemoved(source, path, childIndices, children);
    }

    @Override
    protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
        if (this.creatingModel) {
            return;
        }
        super.fireTreeStructureChanged(source, path, childIndices, children);
    }

    protected String getLocationLabel(String locationId) {
        String locationLabel = (String)this.locationLabelCache.get((Object)locationId);
        Objects.requireNonNull(locationLabel, "Libell\u00e9 de location non trouv\u00e9 pour l'identifiant: " + locationId);
        return locationLabel;
    }

    public void setLocationLabelCache(ImmutableMap<String, String> locationLabelCache) {
        this.locationLabelCache = locationLabelCache;
    }

    public StrataNode addStrata(ZoneNode zoneNode, String strataId) {
        String strataLabel = this.getLocationLabel(strataId);
        if (log.isInfoEnabled()) {
            log.info((Object)("Add strata: " + strataLabel + " to zone node: " + zoneNode));
        }
        StrataNode strataNode = new StrataNode(strataId, strataLabel);
        this.addNode(zoneNode, strataNode);
        return strataNode;
    }

    public SubStrataNode addSubsStrata(StrataNode strataNode, String subStrataId) {
        String subStrataLabel = this.getLocationLabel(subStrataId);
        if (log.isInfoEnabled()) {
            log.info((Object)("Add subStrata: " + subStrataLabel + " to strata node: " + strataNode));
        }
        SubStrataNode subStrataNode = new SubStrataNode(subStrataId, subStrataLabel);
        this.addNode(strataNode, subStrataNode);
        return subStrataNode;
    }

    public StrataNode getOrCreateStrataNode(ZoneNode zoneNode, String strataId) {
        Optional<StrataNode> optionalStrataNode = zoneNode.tryFindStrataNode(strataId);
        StrataNode strataNode = optionalStrataNode.isPresent() ? optionalStrataNode.get() : this.addStrata(zoneNode, strataId);
        return strataNode;
    }

    public void moveSubStratas(StrataNode sourceNode, StrataNode targetNode) {
        EnumerationUtils.toList(sourceNode.children()).forEach(subStrataNode -> {
            this.removeNodeFromParent((MutableTreeNode)subStrataNode);
            this.addNode(targetNode, (ZoneEditorNodeSupport)subStrataNode);
        });
    }
}

