/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;
import fr.ifremer.tutti.service.genericformat.consumer.CsvConsumerForAttachment;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class LoadAttachmentsAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(LoadAttachmentsAction.class);

    public LoadAttachmentsAction(GenericFormatContextSupport importContext) {
        super(importContext);
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getImportRequest().isImportAttachments();
    }

    @Override
    protected void skipExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.load.attachments", (Object[])new Object[0]));
        if (!this.importContext.getImportRequest().isImportAttachments()) {
            GenericFormatCsvFileResult importFileResult = this.importContext.getAttachmentFileResult();
            importFileResult.setSkipped(true);
        }
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Load attachments definitions.");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.load.attachments", (Object[])new Object[0]));
        GenericFormatCsvFileResult importFileResult = this.importContext.getAttachmentFileResult();
        try (CsvConsumerForAttachment consumer = this.importContext.loadAttachments(false);){
            ArrayListMultimap attachmentRowsByObjectId = ArrayListMultimap.create();
            for (ImportRow row : consumer) {
                consumer.validateRow(row);
                if (!row.isValid()) continue;
                AttachmentRow bean = (AttachmentRow)row.getBean();
                attachmentRowsByObjectId.put((Object)(bean.getObjectType() + "_" + bean.getObjectId()), (Object)bean);
            }
            importFileResult.flushErrors(consumer);
            this.importContext.setAttachmentRows((Multimap<String, AttachmentRow>)attachmentRowsByObjectId);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close attachments.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
    }
}

