/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer;

import com.google.common.collect.Maps;
import fr.ifremer.tutti.ichtyometer.RemoteDeviceCantGetNameException;
import java.io.IOException;
import java.util.Map;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteDevicesFinder {
    private static final Log log = LogFactory.getLog(RemoteDevicesFinder.class);
    private final Map<String, RemoteDevice> devices;
    private final int maximumNumberOfTryToConnect;
    private final Object lock;

    public RemoteDevicesFinder(int maximumNumberOfTryToConnect, Object lock) {
        this.maximumNumberOfTryToConnect = maximumNumberOfTryToConnect;
        this.lock = lock;
        this.devices = Maps.newTreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RemoteDevice> findDevices(LocalDevice localDevice) throws BluetoothStateException, InterruptedException {
        DevicesDiscoveryListener listener = new DevicesDiscoveryListener();
        Object object = this.lock;
        synchronized (object) {
            for (int tryRound = 0; tryRound < this.maximumNumberOfTryToConnect && this.devices.isEmpty(); ++tryRound) {
                boolean started = localDevice.getDiscoveryAgent().startInquiry(10390272, (DiscoveryListener)listener);
                if (!started) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Wait for device inquiry to complete... (try " + tryRound + ")"));
                }
                this.lock.wait();
                if (!log.isInfoEnabled()) continue;
                log.info((Object)(this.devices.size() + " device(s) found"));
            }
        }
        return this.devices;
    }

    protected class DevicesDiscoveryListener
    implements DiscoveryListener {
        protected DevicesDiscoveryListener() {
        }

        public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Device " + btDevice.getBluetoothAddress() + " found"));
            }
            String friendlyName = null;
            for (int tryRound = 0; tryRound < RemoteDevicesFinder.this.maximumNumberOfTryToConnect && friendlyName == null; ++tryRound) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Try to get device friendlyName (try " + tryRound + ")"));
                }
                friendlyName = this.getName(btDevice);
            }
            if (friendlyName == null) {
                throw new RemoteDeviceCantGetNameException(btDevice.getBluetoothAddress());
            }
            RemoteDevicesFinder.this.devices.put(friendlyName, btDevice);
        }

        protected String getName(RemoteDevice btDevice) {
            String friendlyName;
            block3: {
                friendlyName = null;
                try {
                    friendlyName = btDevice.getFriendlyName(false);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Name: " + friendlyName));
                    }
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Can't get name of remote", (Throwable)e);
                }
            }
            return friendlyName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void inquiryCompleted(int discType) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Device Inquiry completed!");
            }
            Object object = RemoteDevicesFinder.this.lock;
            synchronized (object) {
                RemoteDevicesFinder.this.lock.notifyAll();
            }
        }

        public void serviceSearchCompleted(int transID, int respCode) {
        }

        public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        }
    }
}

