/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;

public class SequenceSnapshotGenerator
extends JdbcSnapshotGenerator {
    public SequenceSnapshotGenerator() {
        super(Sequence.class, new Class[]{Schema.class});
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getDatabase().supportsSequences()) {
            return;
        }
        if (foundObject instanceof Schema) {
            List<Map<String, ?>> sequenceNames;
            Schema schema = (Schema)foundObject;
            Database database = snapshot.getDatabase();
            if (!database.supportsSequences()) {
                this.updateListeners("Sequences not supported for " + database.toString() + " ...");
            }
            if ((sequenceNames = ExecutorService.getInstance().getExecutor(database).queryForList(new RawSqlStatement(this.getSelectSequenceSql(schema, database)))) != null) {
                for (Map<String, ?> sequence : sequenceNames) {
                    schema.addDatabaseObject(new Sequence().setName(this.cleanNameFromDatabase((String)sequence.get("SEQUENCE_NAME"), database)).setSchema(schema));
                }
            }
        }
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        Database database = snapshot.getDatabase();
        if (!database.supportsSequences()) {
            return null;
        }
        List<Map<String, ?>> sequences = ExecutorService.getInstance().getExecutor(database).queryForList(new RawSqlStatement(this.getSelectSequenceSql(example.getSchema(), database)));
        for (Map<String, ?> sequenceRow : sequences) {
            String name = this.cleanNameFromDatabase((String)sequenceRow.get("SEQUENCE_NAME"), database);
            if ((!database.isCaseSensitive() || !name.equals(example.getName())) && (database.isCaseSensitive() || !name.equalsIgnoreCase(example.getName()))) continue;
            Sequence seq = new Sequence();
            seq.setName(name);
            seq.setSchema(example.getSchema());
            seq.setStartValue(this.toBigInteger(sequenceRow.get("START_VALUE"), database));
            seq.setMinValue(this.toBigInteger(sequenceRow.get("MIN_VALUE"), database));
            seq.setMaxValue(this.toBigInteger(sequenceRow.get("MAX_VALUE"), database));
            seq.setCacheSize(this.toBigInteger(sequenceRow.get("CACHE_SIZE"), database));
            seq.setIncrementBy(this.toBigInteger(sequenceRow.get("INCREMENT_BY"), database));
            seq.setWillCycle(this.toBoolean(sequenceRow.get("WILL_CYCLE"), database));
            seq.setOrdered(this.toBoolean(sequenceRow.get("IS_ORDERED"), database));
            return seq;
        }
        return null;
    }

    protected Boolean toBoolean(Object value, Database database) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String valueAsString = value.toString();
        if ((valueAsString = valueAsString.replace("'", "")).equalsIgnoreCase("true") || valueAsString.equalsIgnoreCase("'true'") || valueAsString.equalsIgnoreCase("y") || valueAsString.equalsIgnoreCase("1") || valueAsString.equalsIgnoreCase("t")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected BigInteger toBigInteger(Object value, Database database) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        return new BigInteger(value.toString());
    }

    protected String getSelectSequenceSql(Schema schema, Database database) {
        if (database instanceof DB2Database) {
            return "SELECT SEQNAME AS SEQUENCE_NAME FROM SYSCAT.SEQUENCES WHERE SEQTYPE='S' AND SEQSCHEMA = '" + schema.getCatalogName() + "'";
        }
        if (database instanceof DerbyDatabase) {
            return "SELECT   seq.SEQUENCENAME AS SEQUENCE_NAME FROM   SYS.SYSSEQUENCES seq,   SYS.SYSSCHEMAS sch WHERE   sch.SCHEMANAME = '" + schema.getName() + "' AND " + "  sch.SCHEMAID = seq.SCHEMAID";
        }
        if (database instanceof FirebirdDatabase) {
            return "SELECT RDB$GENERATOR_NAME AS SEQUENCE_NAME FROM RDB$GENERATORS WHERE RDB$SYSTEM_FLAG IS NULL OR RDB$SYSTEM_FLAG = 0";
        }
        if (database instanceof H2Database) {
            return "SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA = '" + schema.getName() + "' AND IS_GENERATED=FALSE";
        }
        if (database instanceof HsqlDatabase) {
            return "SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES WHERE SEQUENCE_SCHEMA = '" + schema.getName() + "'";
        }
        if (database instanceof InformixDatabase) {
            return "SELECT tabname AS SEQUENCE_NAME FROM systables t, syssequences s WHERE s.tabid = t.tabid AND t.owner = '" + schema.getName() + "'";
        }
        if (database instanceof OracleDatabase) {
            return "SELECT SEQUENCE_NAME AS SEQUENCE_NAME, MIN_VALUE, MAX_VALUE, INCREMENT_BY, CYCLE_FLAG AS WILL_CYCLE, ORDER_FLAG AS IS_ORDERED, LAST_NUMBER as START_VALUE, CACHE_SIZE FROM ALL_SEQUENCES WHERE SEQUENCE_OWNER = '" + schema.getCatalogName() + "'";
        }
        if (database instanceof PostgresDatabase) {
            return "SELECT relname AS SEQUENCE_NAME FROM pg_class, pg_namespace WHERE relkind='S' AND pg_class.relnamespace = pg_namespace.oid AND nspname = '" + schema.getName() + "' " + "AND 'nextval(''" + schema.getName() + "." + "'||relname||'''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null) " + "AND 'nextval(''" + schema.getName() + "." + "\"'||relname||'\"''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null) " + "AND 'nextval('''||relname||'''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null)" + "AND 'nextval(''\"'||relname||'\"''::regclass)' not in (select adsrc from pg_attrdef where adsrc is not null)";
        }
        if (database instanceof MSSQLDatabase) {
            return "SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES WHERE SEQUENCE_SCHEMA = '" + schema.getName() + "'";
        }
        throw new UnexpectedLiquibaseException("Don't know how to query for sequences on " + database);
    }
}

