/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.text.BreakIterator;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.LineBreakContext;
import org.xhtmlrenderer.layout.TextUtil;
import org.xhtmlrenderer.layout.UrlAwareLineBreakIterator;
import org.xhtmlrenderer.render.FSFont;

public class Breaker {
    public static void breakFirstLetter(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c);
        context.setEnd(Breaker.getFirstLetterEnd(context.getMaster(), context.getStart()));
        context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
        if (context.getWidth() > avail) {
            context.setNeedsNewLine(true);
            context.setUnbreakable(true);
        }
    }

    private static int getFirstLetterEnd(String text, int start) {
        boolean letterFound = false;
        int end = text.length();
        for (int i = start; i < end; ++i) {
            char currentChar = text.charAt(i);
            if (TextUtil.isFirstLetterSeparatorChar(currentChar)) continue;
            if (letterFound) {
                return i;
            }
            letterFound = true;
        }
        return end;
    }

    public static void breakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style) {
        FSFont font = style.getFSFont(c);
        IdentValue whitespace = style.getWhitespace();
        if (whitespace == IdentValue.NOWRAP) {
            context.setEnd(context.getLast());
            context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            return;
        }
        if (whitespace == IdentValue.PRE || whitespace == IdentValue.PRE_WRAP || whitespace == IdentValue.PRE_LINE) {
            int n = context.getStartSubstring().indexOf("\n");
            if (n > -1) {
                context.setEnd(context.getStart() + n + 1);
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
                context.setNeedsNewLine(true);
                context.setEndsOnNL(true);
            } else if (whitespace == IdentValue.PRE) {
                context.setEnd(context.getLast());
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            }
        }
        if (whitespace == IdentValue.PRE || context.isNeedsNewLine() && context.getWidth() <= avail) {
            return;
        }
        context.setEndsOnNL(false);
        Breaker.doBreakText(c, context, avail, style, false);
    }

    private static void doBreakText(LayoutContext c, LineBreakContext context, int avail, CalculatedStyle style, boolean tryToBreakAnywhere) {
        int graphicsLength;
        FSFont font = style.getFSFont(c);
        String currentString = context.getStartSubstring();
        BreakIterator iterator = Breaker.getWordStream(currentString);
        int left = 0;
        int right = tryToBreakAnywhere ? 1 : iterator.next();
        int lastWrap = 0;
        int lastGraphicsLength = 0;
        for (graphicsLength = 0; right > 0 && graphicsLength <= avail; graphicsLength += c.getTextRenderer().getWidth(c.getFontContext(), font, currentString.substring(left, right))) {
            lastGraphicsLength = graphicsLength;
            lastWrap = left;
            left = right;
            if (tryToBreakAnywhere) {
                right = (right + 1) % currentString.length();
                continue;
            }
            right = iterator.next();
        }
        if (graphicsLength <= avail) {
            lastWrap = left;
            lastGraphicsLength = graphicsLength;
            graphicsLength += c.getTextRenderer().getWidth(c.getFontContext(), font, currentString.substring(left));
        }
        if (graphicsLength <= avail) {
            context.setWidth(graphicsLength);
            context.setEnd(context.getMaster().length());
            return;
        }
        context.setNeedsNewLine(true);
        if (lastWrap == 0 && style.getWordWrap() == IdentValue.BREAK_WORD && !tryToBreakAnywhere) {
            Breaker.doBreakText(c, context, avail, style, true);
            return;
        }
        if (lastWrap != 0) {
            context.setEnd(context.getStart() + lastWrap);
            context.setWidth(lastGraphicsLength);
        } else {
            if (left == 0) {
                left = currentString.length();
            }
            context.setEnd(context.getStart() + left);
            context.setUnbreakable(true);
            if (left == currentString.length()) {
                context.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), font, context.getCalculatedSubstring()));
            } else {
                context.setWidth(graphicsLength);
            }
        }
    }

    public static BreakIterator getWordStream(String s) {
        UrlAwareLineBreakIterator i = new UrlAwareLineBreakIterator();
        ((BreakIterator)i).setText(s);
        return i;
    }
}

