/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryVessel;
import fr.ifremer.tutti.service.referential.csv.VesselRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryVessel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialTemporaryVesselService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialTemporaryVesselService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public ReferentialImportRequest<Vessel, String> createReferentialImportRequest() {
        ArrayList existingVessels = Lists.newArrayList(this.persistenceService.getAllVessel());
        return new ReferentialImportRequest<Vessel, String>(existingVessels, TuttiEntities.newIdFunction(), Vessels.GET_INTERNAL_REGISTRATION_CODE);
    }

    public ReferentialImportResult<Vessel> importTemporaryVessel(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import vessels from file: " + file));
        }
        ReferentialImportRequest<Vessel, String> requestResult = this.createReferentialImportRequest();
        try (CsvConsumerForTemporaryVessel consumer = new CsvConsumerForTemporaryVessel(file.toPath(), this.getCsvSeparator(), true);){
            for (ImportRow bean : consumer) {
                consumer.checkRow(bean, this.persistenceService, this.decoratorService, requestResult);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.import.vessels.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        ReferentialImportResult<Vessel> result = this.executeImportRequest(requestResult);
        return result;
    }

    public ReferentialImportResult<Vessel> executeImportRequest(ReferentialImportRequest<Vessel, String> requestResult) {
        ReferentialImportResult<Vessel> result = new ReferentialImportResult<Vessel>();
        if (requestResult.withEntitiesToDelete()) {
            List<String> idsToDelete = requestResult.getIdsToDelete();
            this.persistenceService.deleteTemporaryVessels(idsToDelete);
            result.setNbRefDeleted(idsToDelete.size());
        }
        if (requestResult.withEntitiesToAdd()) {
            List<Vessel> entitiesToAdd = requestResult.getEntitiesToAdd();
            List<Vessel> entitiesAdded = this.persistenceService.addTemporaryVessels(entitiesToAdd);
            result.addAllRefsAdded(entitiesAdded);
        }
        if (requestResult.withEntitiesToUpdate()) {
            List<Vessel> entitiesToUpdate = requestResult.getEntitiesToUpdate();
            List<Vessel> entitiesUpdated = this.persistenceService.updateTemporaryVessels(entitiesToUpdate);
            result.addAllRefsUpdated(entitiesUpdated);
        }
        if (requestResult.withEntitiesToLink()) {
            List<Vessel> entitiesToLink = requestResult.getEntitiesToLink();
            List<Vessel> entitiesLinked = this.persistenceService.linkTemporaryVessels(entitiesToLink);
            result.addAllRefsLinked(entitiesLinked);
        }
        return result;
    }

    public List<Vessel> getTemporaryVessels() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all vessels from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllVessel());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " vessels"));
        }
        List<Vessel> toExport = this.persistenceService.retainTemporaryVesselList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary vessels"));
        }
        return toExport;
    }

    public void exportExistingTemporaryVessel(File file) throws IOException {
        List<Vessel> toExport = this.getTemporaryVessels();
        this.exportTemporaryVessel(file, toExport);
    }

    public void exportTemporaryVesselExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Vessel v = Vessels.newVessel();
        v.setRegistrationCode("RegCode1");
        v.setName("Temporary fishing vessel name 1");
        v.setInternationalRegistrationCode("International registration code F1");
        v.setScientificVessel(false);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode2");
        v.setName("Temporary fishing vessel name 2");
        v.setInternationalRegistrationCode("International registration code F2");
        v.setScientificVessel(false);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode3");
        v.setName("Temporary scientific vessel name 3");
        v.setInternationalRegistrationCode("International registration code S3");
        v.setScientificVessel(true);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setRegistrationCode("RegCode4");
        v.setName("Temporary scientific vessel name 4");
        v.setInternationalRegistrationCode("International registration code S4");
        v.setScientificVessel(true);
        toExport.add(v);
        this.exportTemporaryVessel(file, toExport);
    }

    public void exportTemporaryVessel(File file, List<Vessel> toExport) throws IOException {
        try (CsvProducerForTemporaryVessel producerForTemporaryVessel = new CsvProducerForTemporaryVessel(file.toPath(), this.getCsvSeparator());){
            List<VesselRow> dataToExport = producerForTemporaryVessel.getDataToExport(toExport);
            producerForTemporaryVessel.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.vessel.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    protected char getCsvSeparator() {
        return ';';
    }
}

