/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSetMetaData
implements IResultSetMetaData {
    private java.sql.ResultSetMetaData rsMetadata;
    private static Logger logger = Logger.getLogger(ResultSetMetaData.class.getName());

    private void assertNotNull(Object o) throws OdaException {
        if (o == null) {
            throw new JDBCException("odajdbc.driver.ResultSetMetadataCannotNull", 116);
        }
    }

    public ResultSetMetaData(java.sql.ResultSetMetaData rsMeta) throws OdaException {
        this.rsMetadata = rsMeta;
    }

    public int getColumnCount() throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "getColumnCount", "ResultSetMetaData.getColumnCount( )");
        this.assertNotNull(this.rsMetadata);
        try {
            return this.rsMetadata.getColumnCount();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetColumnCount", e);
        }
    }

    public String getColumnName(int index) throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "getColumnName", "ResultSetMetaData.getColumnName( )");
        this.assertNotNull(this.rsMetadata);
        try {
            return this.rsMetadata.getColumnName(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetColumnName", e);
        }
    }

    public String getColumnLabel(int index) throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "getColumnLabel", "ResultSetMetaData.getColumnLabel( )");
        this.assertNotNull(this.rsMetadata);
        try {
            return this.rsMetadata.getColumnLabel(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetColumnLabel", e);
        }
    }

    public int getColumnType(int index) throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "getColumnType", "ResultSetMetaData.getColumnType( )");
        this.assertNotNull(this.rsMetadata);
        try {
            int reType = this.getColumnTypeForSpecialJDBCDriver(index);
            if (reType != 1111) {
                return reType;
            }
            reType = this.rsMetadata.getColumnType(index);
            if (reType == 3) {
                int scale = this.rsMetadata.getScale(index);
                int precision = this.rsMetadata.getPrecision(index);
                if (scale == 0 && precision > 0 && precision <= 9) {
                    reType = 4;
                } else if (precision > 9 && precision <= 15) {
                    reType = 8;
                } else if (precision > 15) {
                    reType = 3;
                }
            }
            return reType;
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetColumnType", e);
        }
    }

    public int getColumnTypeForSpecialJDBCDriver(int index) {
        block4: {
            try {
                if (!"java.sql.Timestamp".equals(this.rsMetadata.getColumnClassName(index))) break block4;
                return 93;
            }
            catch (Exception exception) {
                return 1111;
            }
        }
        if ("java.lang.String".equals(this.rsMetadata.getColumnClassName(index))) {
            return 12;
        }
        return 1111;
    }

    public String getColumnTypeName(int index) throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "getColumnTypeName", "ResultSetMetaData.getColumnTypeName( )");
        this.assertNotNull(this.rsMetadata);
        try {
            return this.rsMetadata.getColumnTypeName(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetColumnTypeName", e);
        }
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "getColumnDisplayLength", "ResultSetMetaData.getColumnDisplayLength( )");
        this.assertNotNull(this.rsMetadata);
        try {
            return this.rsMetadata.getColumnDisplaySize(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetColumnDisplaySize", e);
        }
    }

    public int getPrecision(int index) throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "getPrecision", "ResultSetMetaData.getPrecision( )");
        this.assertNotNull(this.rsMetadata);
        try {
            return this.rsMetadata.getPrecision(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetResultSetMetaDataPrecision", e);
        }
        catch (RuntimeException e) {
            throw new JDBCException("odajdbc.CannotGetResultSetMetaDataPrecision", new SQLException(e.getMessage()));
        }
    }

    public int getScale(int index) throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "getScale", "ResultSetMetaData.getScale( )");
        this.assertNotNull(this.rsMetadata);
        try {
            return this.rsMetadata.getScale(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetResultSetMetaDataScale", e);
        }
        catch (RuntimeException e) {
            throw new JDBCException("odajdbc.CannotGetResultSetMetaDataScale", new SQLException(e.getMessage()));
        }
    }

    public int isNullable(int index) throws OdaException {
        logger.logp(Level.FINEST, ResultSetMetaData.class.getName(), "isNullable", "ResultSetMetaData.isNullable( )");
        this.assertNotNull(this.rsMetadata);
        try {
            return this.rsMetadata.isNullable(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotDetermineColumnSupportForNull", e);
        }
    }
}

