/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.servicelocator.ServiceLocator;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;

public class DatabaseObjectFactory {
    private static DatabaseObjectFactory instance;
    private Set<Class<? extends DatabaseObject>> standardTypes;

    public static DatabaseObjectFactory getInstance() {
        if (instance == null) {
            instance = new DatabaseObjectFactory();
        }
        return instance;
    }

    private DatabaseObjectFactory() {
    }

    public Set<Class<? extends DatabaseObject>> parseTypes(String typesString) {
        Class<DatabaseObject>[] classes;
        if (StringUtils.trimToNull(typesString) == null) {
            return this.getStandardTypes();
        }
        HashSet<Class<? extends DatabaseObject>> returnSet = new HashSet<Class<? extends DatabaseObject>>();
        HashSet<String> typesToInclude = new HashSet<String>(Arrays.asList(typesString.toLowerCase().split("\\s*,\\s*")));
        HashSet<String> typesNotFound = new HashSet<String>(typesToInclude);
        Class<DatabaseObject>[] classArray = classes = ServiceLocator.getInstance().findClasses(DatabaseObject.class);
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<DatabaseObject> clazz = classArray[n2];
            if (typesToInclude.contains(clazz.getSimpleName().toLowerCase()) || typesToInclude.contains(String.valueOf(clazz.getSimpleName().toLowerCase()) + "s") || typesToInclude.contains(String.valueOf(clazz.getSimpleName().toLowerCase()) + "es")) {
                returnSet.add(clazz);
                typesNotFound.remove(clazz.getSimpleName().toLowerCase());
                typesNotFound.remove(String.valueOf(clazz.getSimpleName().toLowerCase()) + "s");
                typesNotFound.remove(String.valueOf(clazz.getSimpleName().toLowerCase()) + "es");
            }
            ++n2;
        }
        if (typesNotFound.size() > 0) {
            throw new UnexpectedLiquibaseException("Unknown snapshot type(s) " + StringUtils.join(typesNotFound, ", "));
        }
        return returnSet;
    }

    public Set<Class<? extends DatabaseObject>> getStandardTypes() {
        if (this.standardTypes == null) {
            Class<DatabaseObject>[] classes;
            HashSet<Class<? extends DatabaseObject>> set = new HashSet<Class<? extends DatabaseObject>>();
            Class<DatabaseObject>[] classArray = classes = ServiceLocator.getInstance().findClasses(DatabaseObject.class);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<DatabaseObject> clazz = classArray[n2];
                try {
                    if (clazz.newInstance().snapshotByDefault()) {
                        set.add(clazz);
                    }
                }
                catch (Exception e) {
                    LogFactory.getLogger().info("Cannot construct " + clazz.getName() + " to determine if it should be included in the snapshot by default");
                }
                ++n2;
            }
            this.standardTypes = set;
        }
        return this.standardTypes;
    }
}

