/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.intercept;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.hibernate.tool.hbm2ddl.TableMetadata;

public class SynchroInterceptorUtils {
    private SynchroInterceptorUtils() {
    }

    public static <T, U extends SynchroInterceptor> List<U> load(Class<U> clazz) {
        ArrayList result = Lists.newArrayList();
        ServiceLoader<SynchroInterceptor> loader = ServiceLoader.load(clazz);
        for (SynchroInterceptor interceptor : loader) {
            result.add(interceptor);
        }
        return result;
    }

    public static <T, U extends SynchroInterceptor> List<U> filter(List<U> interceptors, final SynchroDatabaseConfiguration config) {
        Collection result = Collections2.filter(interceptors, (Predicate)new Predicate<SynchroInterceptor>(){

            public boolean apply(SynchroInterceptor interceptor) {
                return interceptor.apply(config);
            }
        });
        return ImmutableList.copyOf((Collection)result);
    }

    public static <T, U extends SynchroInterceptor> List<U> filter(List<U> interceptors, final SynchroDatabaseMetadata meta, final TableMetadata table) {
        Collection result = Collections2.filter(interceptors, (Predicate)new Predicate<SynchroInterceptor>(){

            public boolean apply(SynchroInterceptor interceptor) {
                return interceptor.apply(meta, table);
            }
        });
        return ImmutableList.copyOf((Collection)result);
    }

    public static <T, U extends SynchroInterceptor> U chain(List<U> interceptors, SynchroDatabaseMetadata meta, TableMetadata table, Class<? extends SynchroInterceptor> chainClazz) {
        List<U> filteredInterceptors = SynchroInterceptorUtils.filter(interceptors, meta, table);
        try {
            return (U)SynchroInterceptorUtils.createChain(filteredInterceptors, chainClazz);
        }
        catch (InstantiationException e) {
            throw new SynchroTechnicalException("Could not instantiate interceptor : " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SynchroTechnicalException("Could not instantiate interceptor : " + e.getMessage(), e);
        }
    }

    public static <T, U extends SynchroInterceptor, V extends SynchroInterceptor> U chain(Collection<U> interceptors, Class<V> chainClazz) {
        try {
            return (U)SynchroInterceptorUtils.createChain(interceptors, chainClazz);
        }
        catch (InstantiationException e) {
            throw new SynchroTechnicalException("Could not instantiate interceptor : " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SynchroTechnicalException("Could not instantiate interceptor : " + e.getMessage(), e);
        }
    }

    protected static <T, U extends SynchroInterceptor> SynchroInterceptor createChain(Collection<U> interceptors, Class<? extends SynchroInterceptor> chainClazz) throws InstantiationException, IllegalAccessException {
        SynchroInterceptor result = null;
        SynchroInterceptor previous = null;
        for (SynchroInterceptor interceptor : interceptors) {
            SynchroInterceptor newChain = null;
            newChain = interceptor instanceof SynchroInterceptor ? interceptor : SynchroInterceptorUtils.encapsulate(interceptor, chainClazz);
            if (result == null) {
                result = newChain;
            } else if (previous != null) {
                previous.setNext(newChain);
            }
            previous = newChain;
        }
        return result;
    }

    protected static <T, U extends SynchroInterceptor> SynchroInterceptor encapsulate(U delegate, Class<? extends SynchroInterceptor> chainClass) throws InstantiationException, IllegalAccessException {
        SynchroInterceptor chain = chainClass.newInstance();
        chain.setNext(delegate);
        return chain;
    }
}

