/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchRow;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportFishingOperationActionSupport;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAttachment;
import java.util.ArrayList;
import java.util.List;

public class CreateAccidentalCatchRowsAction
extends ExportFishingOperationActionSupport {
    private final PersistenceService persistenceService;

    public CreateAccidentalCatchRowsAction(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public boolean doExecute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        return exportContext.isExportAccidentalCatch() && operationContext.isWithCatchBatch();
    }

    @Override
    public void execute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        List<AccidentalCatchRow> accidentalCatchRows = exportContext.getProducerForAccidentalCatch().getDataToExport(operationContext);
        operationContext.setAccidentalCatchRows(accidentalCatchRows);
        exportContext.getProducerForSpecies().prepareAccidentalRows(accidentalCatchRows);
        if (exportContext.isExportAttachments()) {
            List<AttachmentRow> attachmentRows = this.getAttachmentRows(exportContext, operationContext.getAccidentalBatches());
            operationContext.addAttachmentRows(attachmentRows);
        }
    }

    protected List<AttachmentRow> getAttachmentRows(GenericFormatExportContext exportContext, List<AccidentalBatch> accidentalBatches) {
        CsvProducerForAttachment producerForAttachment = exportContext.getProducerForAttachment();
        ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
        for (AccidentalBatch accidentalBatch : accidentalBatches) {
            List<Attachment> attachments = this.persistenceService.getAllAttachments(ObjectTypeCode.SAMPLE, accidentalBatch.getIdAsInt());
            producerForAttachment.addAttachments(attachments, attachmentRows);
        }
        return attachmentRows;
    }
}

