// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/usertypes/HibernateStringClobType.vsl in andromda-hibernate-cartridge.
//
package org.andromda.persistence.hibernate.usertypes;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;

/**
 * <p>
 * A hibernate user type which converts a Clob into a String and back again.
 * </p>
 */
public class HibernateStringClobType
    implements UserType, Serializable
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -9186242984664002079L;

    /**
     * @see org.hibernate.usertype.UserType#sqlTypes()
     */
    @Override
    public int[] sqlTypes()
    {
        return new int[] {Types.CLOB};
    }

    /**
     * @see org.hibernate.usertype.UserType#returnedClass()
     */
    @Override
    public Class<?> returnedClass()
    {
        return String.class;
    }

    /**
     * @see org.hibernate.usertype.UserType#equals(Object, Object)
     */
    @Override
    public boolean equals(
        Object x,
        Object y)
        throws HibernateException
    {
        boolean equal = false;
        if (x == y)
        {
            equal = true;
        }
        else if (x == null || y == null)
        {
            equal = false;
        }
        else if (!(x instanceof String) || !(y instanceof String))
        {
            equal = false;
        }
        else
        {
            equal = ((String)x).equals(y);
        }
        return equal;
    }

    /**
     * @see org.hibernate.usertype.UserType#nullSafeGet(java.sql.ResultSet, String[], Object)
     */
    public Object nullSafeGet(
        ResultSet resultSet,
        String[] names,
        Object owner)
        throws HibernateException, SQLException
    {
        final StringBuilder buffer = new StringBuilder();
        try
        {
            //First we get the stream
            Reader inputStream = resultSet.getCharacterStream(names[0]);
            if (inputStream == null)
            {
                return null;
            }
            char[] buf = new char[1024];
            int read = -1;

            while ((read = inputStream.read(buf)) > 0)
            {
                buffer.append(new String(
                        buf,
                        0,
                        read));
            }
            inputStream.close();
        }
        catch (IOException exception)
        {
            throw new HibernateException("Unable to read from resultset", exception);
        }
        return buffer.toString();
    }

    /**
     * @see org.hibernate.usertype.UserType#nullSafeSet(java.sql.PreparedStatement, Object, int)
     */
    public void nullSafeSet(
        PreparedStatement preparedStatement,
        Object data,
        int index)
        throws HibernateException, SQLException
    {
        if (data != null)
        {
            StringReader r = new StringReader((String)data);
            preparedStatement.setCharacterStream(
                index,
                r,
                ((String)data).length());
        }
        else
        {
            preparedStatement.setNull(
                index,
                sqlTypes()[0]);
        }
    }

    /**
     * @see org.hibernate.usertype.UserType#nullSafeGet(java.sql.ResultSet, String[], Object)
     */
    @Override
    public Object nullSafeGet(ResultSet resultSet, String[] names,
        SessionImplementor session, Object owner) throws HibernateException, SQLException
    {
        return this.nullSafeGet(resultSet, names, owner);
    }

    /**
     * @see org.hibernate.usertype.UserType#nullSafeSet(java.sql.PreparedStatement, Object, int)
     */
    @Override
    public void nullSafeSet(
        PreparedStatement preparedStatement,
        Object data,
        int index,
        SessionImplementor session)
        throws HibernateException, SQLException
    {
        this.nullSafeSet(preparedStatement, data, index);
    }

    /**
     * @see org.hibernate.usertype.UserType#deepCopy(Object)
     */
    @Override
    public Object deepCopy(Object value)
        throws HibernateException
    {
        return value;
    }

    /**
     * @see org.hibernate.usertype.UserType#isMutable()
     */
    @Override
    public boolean isMutable()
    {
        return false;
    }

    /**
     * @see org.hibernate.usertype.UserType#replace(Object original, Object target, Object owner)
     */
    @Override
    public Object replace(Object original, Object target, Object owner)
    {
        return this.deepCopy(original);
    }

    /**
     * @see org.hibernate.usertype.UserType#assemble(Serializable cached, Object owner)
     */
    @Override
    public Object assemble(Serializable cached, Object owner)
    {
        return this.deepCopy(cached);
    }

    /**
     * @see org.hibernate.usertype.UserType#disassemble(Object value)
     */
    @Override
     public Serializable disassemble(Object value)
     {
        return (Serializable)value;
     }

     /**
      * @param x
      * @return x.hashCode()
      * @see Object#hashCode()
      */
    @Override
     public int hashCode(Object x)
     {
        return x.hashCode();
     }
}